/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef HODJNPODJ_BARBERSHOP_RESOURCE_H
#define HODJNPODJ_BARBERSHOP_RESOURCE_H

namespace Bagel {
namespace HodjNPodj {
namespace Barbershop {

#define HILITE_BORDER       3

#define INI_SECTION         "Barbershop"
#define INI_LETTERSSOLVED   "LettersSolved"

#define LSLVD_DEFAULT       6
#define MIN_LSLVD           0
#define MAX_LSLVD           20

#define INI_TIME            "Time"
#define TIME_DEFAULT        180
#define MIN_TIME            15
#define MAX_TIME            601

#define INI_REC             "Record"
#define REC_DEFAULT         0
#define CRYPT_RECS          200

//{{NO_DEPENDENCIES}}
// App Studio generated include file.
// Used by USERCFG.RC
//
#define IDD_RULES_DIALOG                900
#define IDC_RULES_OKAY                  900
#define IDC_RULES_ARROWDN               901
#define IDC_RULES_ARROWUP               902
#define IDC_RULES_INVALID               903

} // namespace Barbershop
} // namespace HodjNPodj
} // namespace Bagel

#endif
