#!/bin/sh

clean_id()
{
	tr "\r\n" "~" | sed '
s/~*$//;
s/|/\&pipe;/g;
s/&/\&amp;/g;
s/</\&lt;/g;
s/>/\&gt;/g;
s/"/\&quot;/g;
s/'\''/\&apos;/g;
s/~\+/<br>/g;
'
	echo ""
}

genpage()
{
	local dir scripts name desc html
	
	dir="$1"
	scripts="$2"

	name=`cat $dir/ID.name`
	desc=`cat $dir/ID.desc`
	html=`ls $dir/*.html | grep -v index.html`
	./tags < "$html" | awk -v "fn_ref=../packages/XREF" -v "scripts=$scripts" -v "name=$name" -v "desc=$desc" '
	BEGIN {
		while((getline < fn_ref) > 0) {
			REF[$2] = $3
		}
		print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">"
		print "<html>"
		print "<head>"
		print "  <title> sch-rnd scripting example:", name, "</title>"
		print "  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=us-ascii\">"
		print "</head>"
		print "<body>"
		print "<!-- ******* DO NOT EDIT THIS FILE, it is generated by rosetta_genpages.sh ******* -->"
		print "<!-- nopdf=\"yes\"--> &lt;-- back to the <a href=\"../index.html\">index of scripting examples</a>"
		print "<h4>" name "</h4>"
		print desc

		print "<h5> Example implementation </h5>"
		v = split(scripts, S, "[\r\n]+")
		for(n = 1; n <= v; n++) {
			lang=S[n]
			sub("^ex[.]", "", lang)
			if (n != 1)
				print " | "
			print "<a href=\"" S[n] "\">" lang "</a>"
		}

		print "<h5> Explanation, step by step </h5>"
	}
	/^<ref>/ {
		gsub("</?ref>", "", $0)
		name=$0
		gsub("[ \t]*", "", name)
		if (name in REF) {
			link_begin="<a href=\"../" REF[name]  "\">"
			link_end = "</a>"
		}
		else {
			link_begin=""
			link_end=""
		}
		print "<i>" link_begin $0 link_end "</i>"
		next
	}

	{ print $0 }

	END {
		print "</body>"
		print "</html>"
	}

	' > "$dir/index.html"
}

gen_index()
{

	awk -v "template=$1" '
		BEGIN {
			FS="[|]"
			q = "\""
			LANGS["rb"] = "ruby"
			LANGS["pl"] = "perl"
			LANGS["py"] = "python"
			LANGS["stt"] = "stutter"
			LANGS["scm"] = "scheme"
		}

		($1 == "scripts") {
			s = $3
			gsub("ex[.]", "", s)
			v = split(s, S, " ")
			s = ""
			for(n = 1; n <= v; n++) {
				if (S[n] in LANGS)
					s = s " " LANGS[S[n]]
				else
					s = s " " S[n]
			}
			DATA[$2, $1] = s
			next
		}

		($1 == "name") {
			if (names == "")
				names = $2
			else
				names = names "|" $2
		}


		{
			# DATA[script, name] = "hello world"
			DATA[$2, $1] = $3
		}

		function generate(cmd   ,N,n,v,name,level) {
			if (cmd == "index") {
				print "<table border=1 cellspacing=0 cellpadding=15>"
				print "<tr><th>example <th> description"
				v = split(names, N, "[|]")
				for(n = 1; n <= v; n++) {
					name = N[n]
					print "<tr>"
					print " <td><a href=" q name "/index.html" q ">" DATA[name, "name"] "</a>"
					print " <td>" DATA[name, "desc"]
				}
				print "</table>"
			}
			else
				print "Do not know how to generate " cmd > "/dev/stderr"
		}

		END {
			FS=""
			while((getline < template) > 0) {
				if (match($0, "<rosetta[ \t][^>]*>")) {
					print substr($0, 1, RSTART-1)
					cmd=substr($0, RSTART+8, RLENGTH-9)
					sub("^[ \t]*", "", cmd)
					generate(cmd)
					print substr($0, RSTART+RLENGTH)
				}
				else
					print $0
			}
		}
	'

}

list=`cat ../list`
for n in $list
do
	if test -d "../$n"
	then
		bn=`basename $n`
		scripts=`cd ../$n && ls *.fawk`
		genpage "../$n" "$scripts"
		echo -n "desc|$bn|"
		clean_id < ../$n/ID.desc
		echo -n "name|$bn|"
		clean_id < ../$n/ID.name
		echo -n "scripts|$bn|"
		echo $scripts
	fi
done | gen_index index.templ.html > ../index.html


