// This test ensures that patterns also get a link generated.

//@ compile-flags: -Zunstable-options --generate-link-to-definition

#![crate_name = "foo"]

//@ has 'src/foo/assoc-items.rs.html'

pub trait Trait {
    type T;
}
pub trait Another {
    type T;
    const X: u32;
}

pub struct Foo;

impl Foo {
    pub fn new() -> Self { Foo }
}

pub struct C;

impl C {
    pub fn wat() {}
}

// These two links must not change and in particular must contain `/derive.`!
//@ has - '//a[@href="{{channel}}/core/fmt/macros/derive.Debug.html"]' 'Debug'
//@ has - '//a[@href="{{channel}}/core/cmp/derive.PartialEq.html"]' 'PartialEq'
#[derive(Debug, PartialEq)]
pub struct Bar;
impl Trait for Bar {
    type T = Foo;
}
impl Another for Bar {
    type T = C;
    const X: u32 = 12;
}

pub fn bar() {
    //@ has - '//a[@href="#20"]' 'new'
    <Bar as Trait>::T::new();
    //@ has - '//a[@href="#26"]' 'wat'
    <Bar as Another>::T::wat();

    match 12u32 {
        //@ has - '//a[@href="#14"]' 'X'
        <Bar as Another>::X => {}
        _ => {}
    }
}

pub struct Far {
        //@ has - '//a[@href="#10"]' 'T'
    x: <Bar as Trait>::T,
}
