% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchReduceResults.R
\name{batchReduceResults}
\alias{batchReduceResults}
\title{Reduces results via a binary function and adds jobs for this to a registry.}
\usage{
batchReduceResults(
  reg,
  reg2,
  fun,
  ids,
  part = NA_character_,
  init,
  block.size,
  more.args = list()
)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry whose results should be reduced by \code{fun}.}

\item{reg2}{[\code{\link{Registry}}]\cr
Empty registry that should store the job for the mapping.}

\item{fun}{[\code{function(aggr, job, res, ...)}]\cr
Function to reduce results with.}

\item{ids}{[\code{integer}]\cr
Ids of jobs whose results should be reduced with \code{fun}.
Default is all jobs.}

\item{part}{[\code{character}]
Only useful for multiple result files, then defines which result file part(s) should be loaded.
\code{NA} means all parts are loaded, which is the default.}

\item{init}{[any]\cr
Initial object for reducing.}

\item{block.size}{[\code{integer(1)}]\cr
Number of results reduced in one job.}

\item{more.args}{[\code{list}]\cr
A list of other arguments passed to \code{fun}.
Default is empty list.}
}
\value{
Vector of type \code{integer} with job ids.
}
\description{
Each jobs reduces a certain number of results on one slave.
You can then submit these jobs to the batch system.
Later, you can do a final reduction with \code{\link{reduceResults}} on the master.
}
\examples{
# generating example results:
reg1 = makeRegistry(id = "BatchJobsExample1", file.dir = tempfile(), seed = 123)
f = function(x) x^2
batchMap(reg1, f, 1:20)
submitJobs(reg1)
waitForJobs(reg1)

# define function to reduce on slave, we want to sum the squares
myreduce = function(aggr, job, res) aggr + res

# sum 5 results on each slave process, i.e. 4 jobs
reg2 = makeRegistry(id = "BatchJobsExample2", file.dir = tempfile(), seed = 123)
batchReduceResults(reg1, reg2, fun = myreduce, init = 0, block.size = 5)
submitJobs(reg2)
waitForJobs(reg2)

# now reduce one final time on master
reduceResults(reg2, fun = myreduce)
}
