# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    AddonType,
    DhcpTypeEnum,
    HostKind,
    LicenseKind,
    MaintenanceManagementOperationKind,
    PlacementPolicyType,
    RescheduleOperationConstraintKind,
    ScheduleOperationConstraintKind,
    ScriptExecutionParameterType,
    VcfLicenseKind,
)

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    """


class Addon(ProxyResource):
    """An addon resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.AddonProperties
    """

    properties: Optional["_models.AddonProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AddonProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AddonProperties(_Model):
    """The properties of an addon.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AddonArcProperties, AddonHcxProperties, AddonSrmProperties, AddonVrProperties

    :ivar addon_type: Addon type. Required. Known values are: "SRM", "VR", "HCX", and "Arc".
    :vartype addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    """

    __mapping__: dict[str, _Model] = {}
    addon_type: str = rest_discriminator(name="addonType", visibility=["read", "create", "update", "delete", "query"])
    """Addon type. Required. Known values are: \"SRM\", \"VR\", \"HCX\", and \"Arc\"."""
    provisioning_state: Optional[Union[str, "_models.AddonProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the addon provisioning. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Cancelled\", \"Building\", \"Deleting\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        addon_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AddonArcProperties(AddonProperties, discriminator="Arc"):
    """The properties of an Arc addon.

    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar v_center: The VMware vCenter resource ID.
    :vartype v_center: str
    :ivar addon_type: The type of private cloud addon. Required.
    :vartype addon_type: str or ~azure.mgmt.avs.models.ARC
    """

    v_center: Optional[str] = rest_field(name="vCenter", visibility=["read", "create", "update", "delete", "query"])
    """The VMware vCenter resource ID."""
    addon_type: Literal[AddonType.ARC] = rest_discriminator(name="addonType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of private cloud addon. Required."""

    @overload
    def __init__(
        self,
        *,
        v_center: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.addon_type = AddonType.ARC  # type: ignore


class AddonHcxProperties(AddonProperties, discriminator="HCX"):
    """The properties of an HCX addon.

    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar offer: The HCX offer, example VMware MaaS Cloud Provider (Enterprise). Required.
    :vartype offer: str
    :ivar addon_type: The type of private cloud addon. Required.
    :vartype addon_type: str or ~azure.mgmt.avs.models.HCX
    :ivar management_network: HCX management network.
    :vartype management_network: str
    :ivar uplink_network: HCX uplink network.
    :vartype uplink_network: str
    """

    offer: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The HCX offer, example VMware MaaS Cloud Provider (Enterprise). Required."""
    addon_type: Literal[AddonType.HCX] = rest_discriminator(name="addonType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of private cloud addon. Required."""
    management_network: Optional[str] = rest_field(
        name="managementNetwork", visibility=["read", "create", "update", "delete", "query"]
    )
    """HCX management network."""
    uplink_network: Optional[str] = rest_field(
        name="uplinkNetwork", visibility=["read", "create", "update", "delete", "query"]
    )
    """HCX uplink network."""

    @overload
    def __init__(
        self,
        *,
        offer: str,
        management_network: Optional[str] = None,
        uplink_network: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.addon_type = AddonType.HCX  # type: ignore


class AddonSrmProperties(AddonProperties, discriminator="SRM"):
    """The properties of a Site Recovery Manager (SRM) addon.

    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar license_key: The Site Recovery Manager (SRM) license.
    :vartype license_key: str
    :ivar addon_type: The type of private cloud addon. Required.
    :vartype addon_type: str or ~azure.mgmt.avs.models.SRM
    """

    license_key: Optional[str] = rest_field(
        name="licenseKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Site Recovery Manager (SRM) license."""
    addon_type: Literal[AddonType.SRM] = rest_discriminator(name="addonType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of private cloud addon. Required."""

    @overload
    def __init__(
        self,
        *,
        license_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.addon_type = AddonType.SRM  # type: ignore


class AddonVrProperties(AddonProperties, discriminator="VR"):
    """The properties of a vSphere Replication (VR) addon.

    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar vrs_count: The vSphere Replication Server (VRS) count. Required.
    :vartype vrs_count: int
    :ivar addon_type: The type of private cloud addon. Required.
    :vartype addon_type: str or ~azure.mgmt.avs.models.VR
    """

    vrs_count: int = rest_field(name="vrsCount", visibility=["read", "create", "update", "delete", "query"])
    """The vSphere Replication Server (VRS) count. Required."""
    addon_type: Literal[AddonType.VR] = rest_discriminator(name="addonType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of private cloud addon. Required."""

    @overload
    def __init__(
        self,
        *,
        vrs_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.addon_type = AddonType.VR  # type: ignore


class AdminCredentials(_Model):
    """Administrative credentials for accessing vCenter and NSX-T.

    :ivar nsxt_username: NSX-T Manager username.
    :vartype nsxt_username: str
    :ivar nsxt_password: NSX-T Manager password.
    :vartype nsxt_password: str
    :ivar vcenter_username: vCenter admin username.
    :vartype vcenter_username: str
    :ivar vcenter_password: vCenter admin password.
    :vartype vcenter_password: str
    """

    nsxt_username: Optional[str] = rest_field(name="nsxtUsername", visibility=["read"])
    """NSX-T Manager username."""
    nsxt_password: Optional[str] = rest_field(name="nsxtPassword", visibility=["read"])
    """NSX-T Manager password."""
    vcenter_username: Optional[str] = rest_field(name="vcenterUsername", visibility=["read"])
    """vCenter admin username."""
    vcenter_password: Optional[str] = rest_field(name="vcenterPassword", visibility=["read"])
    """vCenter admin password."""


class AvailabilityProperties(_Model):
    """The properties describing private cloud availability zone distribution.

    :ivar strategy: The availability strategy for the private cloud. Known values are: "SingleZone"
     and "DualZone".
    :vartype strategy: str or ~azure.mgmt.avs.models.AvailabilityStrategy
    :ivar zone: The primary availability zone for the private cloud.
    :vartype zone: int
    :ivar secondary_zone: The secondary availability zone for the private cloud.
    :vartype secondary_zone: int
    """

    strategy: Optional[Union[str, "_models.AvailabilityStrategy"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The availability strategy for the private cloud. Known values are: \"SingleZone\" and
     \"DualZone\"."""
    zone: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The primary availability zone for the private cloud."""
    secondary_zone: Optional[int] = rest_field(
        name="secondaryZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """The secondary availability zone for the private cloud."""

    @overload
    def __init__(
        self,
        *,
        strategy: Optional[Union[str, "_models.AvailabilityStrategy"]] = None,
        zone: Optional[int] = None,
        secondary_zone: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RescheduleOperationConstraint(_Model):
    """Defines constraints for reschedule operation on maintenance.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AvailableWindowForMaintenanceWhileRescheduleOperation, BlockedWhileRescheduleOperation

    :ivar kind: The kind of operation. Required. Known values are: "AvailableWindowForMaintenance"
     and "Blocked".
    :vartype kind: str or ~azure.mgmt.avs.models.RescheduleOperationConstraintKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read"])
    """The kind of operation. Required. Known values are: \"AvailableWindowForMaintenance\" and
     \"Blocked\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvailableWindowForMaintenanceWhileRescheduleOperation(
    RescheduleOperationConstraint, discriminator="AvailableWindowForMaintenance"
):  # pylint: disable=name-too-long
    """Time window in which Customer can reschedule maintenance.

    :ivar kind: The kind of constraint. Required. Time window in which maintenance can be
     rescheduled
    :vartype kind: str or
     ~azure.mgmt.avs.models.AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_RESCHEDULE_OPERATION
    :ivar starts_at: Start date time. Required.
    :vartype starts_at: ~datetime.datetime
    :ivar ends_at: End date Time. Required.
    :vartype ends_at: ~datetime.datetime
    """

    kind: Literal[RescheduleOperationConstraintKind.AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_RESCHEDULE_OPERATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of constraint. Required. Time window in which maintenance can be rescheduled"""
    starts_at: datetime.datetime = rest_field(name="startsAt", visibility=["read"], format="rfc3339")
    """Start date time. Required."""
    ends_at: datetime.datetime = rest_field(name="endsAt", visibility=["read"], format="rfc3339")
    """End date Time. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = RescheduleOperationConstraintKind.AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_RESCHEDULE_OPERATION  # type: ignore


class ScheduleOperationConstraint(_Model):
    """Defines constraints for schedule operation on maintenance.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AvailableWindowForMaintenanceWhileScheduleOperation, BlockedWhileScheduleOperation,
    SchedulingWindow

    :ivar kind: The kind of operation. Required. Known values are: "SchedulingWindow",
     "AvailableWindowForMaintenance", and "Blocked".
    :vartype kind: str or ~azure.mgmt.avs.models.ScheduleOperationConstraintKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read"])
    """The kind of operation. Required. Known values are: \"SchedulingWindow\",
     \"AvailableWindowForMaintenance\", and \"Blocked\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvailableWindowForMaintenanceWhileScheduleOperation(
    ScheduleOperationConstraint, discriminator="AvailableWindowForMaintenance"
):  # pylint: disable=name-too-long
    """Time window in which Customer can to schedule maintenance.

    :ivar kind: The kind of constraint. Required. Time window in which maintenance can be scheduled
    :vartype kind: str or
     ~azure.mgmt.avs.models.AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_SCHEDULE_OPERATION
    :ivar starts_at: Start date time. Required.
    :vartype starts_at: ~datetime.datetime
    :ivar ends_at: End date Time. Required.
    :vartype ends_at: ~datetime.datetime
    """

    kind: Literal[ScheduleOperationConstraintKind.AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_SCHEDULE_OPERATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of constraint. Required. Time window in which maintenance can be scheduled"""
    starts_at: datetime.datetime = rest_field(name="startsAt", visibility=["read"], format="rfc3339")
    """Start date time. Required."""
    ends_at: datetime.datetime = rest_field(name="endsAt", visibility=["read"], format="rfc3339")
    """End date Time. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ScheduleOperationConstraintKind.AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_SCHEDULE_OPERATION  # type: ignore


class BlockedDatesConstraintTimeRange(_Model):
    """Blocked Time range Constraints for maintenance.

    :ivar starts_at: Start date time. Required.
    :vartype starts_at: ~datetime.datetime
    :ivar ends_at: End date Time. Required.
    :vartype ends_at: ~datetime.datetime
    :ivar reason: Reason category for blocking maintenance reschedule.
    :vartype reason: str
    """

    starts_at: datetime.datetime = rest_field(name="startsAt", visibility=["read"], format="rfc3339")
    """Start date time. Required."""
    ends_at: datetime.datetime = rest_field(name="endsAt", visibility=["read"], format="rfc3339")
    """End date Time. Required."""
    reason: Optional[str] = rest_field(visibility=["read"])
    """Reason category for blocking maintenance reschedule."""


class BlockedWhileRescheduleOperation(RescheduleOperationConstraint, discriminator="Blocked"):
    """Time ranges blocked for rescheduling maintenance.

    :ivar kind: The kind of constraint. Required. Blocked time range constraint
    :vartype kind: str or ~azure.mgmt.avs.models.BLOCKED_WHILE_RESCHEDULE_OPERATION
    :ivar category: Category of blocked date. Required. Known values are: "HiPriorityEvent",
     "QuotaExhausted", and "Holiday".
    :vartype category: str or ~azure.mgmt.avs.models.BlockedDatesConstraintCategory
    :ivar time_ranges: Date ranges blocked for schedule.
    :vartype time_ranges: list[~azure.mgmt.avs.models.BlockedDatesConstraintTimeRange]
    """

    kind: Literal[RescheduleOperationConstraintKind.BLOCKED_WHILE_RESCHEDULE_OPERATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of constraint. Required. Blocked time range constraint"""
    category: Union[str, "_models.BlockedDatesConstraintCategory"] = rest_field(visibility=["read"])
    """Category of blocked date. Required. Known values are: \"HiPriorityEvent\", \"QuotaExhausted\",
     and \"Holiday\"."""
    time_ranges: Optional[list["_models.BlockedDatesConstraintTimeRange"]] = rest_field(
        name="timeRanges", visibility=["read"]
    )
    """Date ranges blocked for schedule."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = RescheduleOperationConstraintKind.BLOCKED_WHILE_RESCHEDULE_OPERATION  # type: ignore


class BlockedWhileScheduleOperation(ScheduleOperationConstraint, discriminator="Blocked"):
    """Time ranges blocked for scheduling maintenance.

    :ivar kind: The kind of constraint. Required. Blocked time range constraint
    :vartype kind: str or ~azure.mgmt.avs.models.BLOCKED_WHILE_SCHEDULE_OPERATION
    :ivar category: Category of blocked date. Required. Known values are: "HiPriorityEvent",
     "QuotaExhausted", and "Holiday".
    :vartype category: str or ~azure.mgmt.avs.models.BlockedDatesConstraintCategory
    :ivar time_ranges: Date ranges blocked for schedule.
    :vartype time_ranges: list[~azure.mgmt.avs.models.BlockedDatesConstraintTimeRange]
    """

    kind: Literal[ScheduleOperationConstraintKind.BLOCKED_WHILE_SCHEDULE_OPERATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of constraint. Required. Blocked time range constraint"""
    category: Union[str, "_models.BlockedDatesConstraintCategory"] = rest_field(visibility=["read"])
    """Category of blocked date. Required. Known values are: \"HiPriorityEvent\", \"QuotaExhausted\",
     and \"Holiday\"."""
    time_ranges: Optional[list["_models.BlockedDatesConstraintTimeRange"]] = rest_field(
        name="timeRanges", visibility=["read"]
    )
    """Date ranges blocked for schedule."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ScheduleOperationConstraintKind.BLOCKED_WHILE_SCHEDULE_OPERATION  # type: ignore


class Circuit(_Model):
    """An ExpressRoute Circuit.

    :ivar primary_subnet: CIDR of primary subnet.
    :vartype primary_subnet: str
    :ivar secondary_subnet: CIDR of secondary subnet.
    :vartype secondary_subnet: str
    :ivar express_route_id: Identifier of the ExpressRoute Circuit (Microsoft Colo only).
    :vartype express_route_id: str
    :ivar express_route_private_peering_id: ExpressRoute Circuit private peering identifier.
    :vartype express_route_private_peering_id: str
    """

    primary_subnet: Optional[str] = rest_field(name="primarySubnet", visibility=["read"])
    """CIDR of primary subnet."""
    secondary_subnet: Optional[str] = rest_field(name="secondarySubnet", visibility=["read"])
    """CIDR of secondary subnet."""
    express_route_id: Optional[str] = rest_field(name="expressRouteID", visibility=["read"])
    """Identifier of the ExpressRoute Circuit (Microsoft Colo only)."""
    express_route_private_peering_id: Optional[str] = rest_field(
        name="expressRoutePrivatePeeringID", visibility=["read"]
    )
    """ExpressRoute Circuit private peering identifier."""


class CloudLink(ProxyResource):
    """A cloud link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.CloudLinkProperties
    """

    properties: Optional["_models.CloudLinkProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "status", "linked_cloud"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CloudLinkProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CloudLinkProperties(_Model):
    """The properties of a cloud link.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.CloudLinkProvisioningState
    :ivar status: The state of the cloud link. Known values are: "Active", "Building", "Deleting",
     "Failed", and "Disconnected".
    :vartype status: str or ~azure.mgmt.avs.models.CloudLinkStatus
    :ivar linked_cloud: Identifier of the other private cloud participating in the link.
    :vartype linked_cloud: str
    """

    provisioning_state: Optional[Union[str, "_models.CloudLinkProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    status: Optional[Union[str, "_models.CloudLinkStatus"]] = rest_field(visibility=["read"])
    """The state of the cloud link. Known values are: \"Active\", \"Building\", \"Deleting\",
     \"Failed\", and \"Disconnected\"."""
    linked_cloud: Optional[str] = rest_field(
        name="linkedCloud", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the other private cloud participating in the link."""

    @overload
    def __init__(
        self,
        *,
        linked_cloud: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Cluster(ProxyResource):
    """A cluster resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.ClusterProperties
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource. Required.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    """

    properties: Optional["_models.ClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource. Required."""

    __flattened_items = ["cluster_size", "provisioning_state", "cluster_id", "hosts", "vsan_datastore_name"]

    @overload
    def __init__(
        self,
        *,
        sku: "_models.Sku",
        properties: Optional["_models.ClusterProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ClusterProperties(_Model):
    """The properties of a cluster.

    :ivar cluster_size: The cluster size.
    :vartype cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :ivar hosts: The hosts.
    :vartype hosts: list[str]
    :ivar vsan_datastore_name: Name of the vsan datastore associated with the cluster.
    :vartype vsan_datastore_name: str
    """

    cluster_size: Optional[int] = rest_field(
        name="clusterSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The cluster size."""
    provisioning_state: Optional[Union[str, "_models.ClusterProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the cluster provisioning. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Cancelled\", \"Deleting\", and \"Updating\"."""
    cluster_id: Optional[int] = rest_field(name="clusterId", visibility=["read"])
    """The identity."""
    hosts: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The hosts."""
    vsan_datastore_name: Optional[str] = rest_field(
        name="vsanDatastoreName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the vsan datastore associated with the cluster."""

    @overload
    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[list[str]] = None,
        vsan_datastore_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterUpdate(_Model):
    """An update of a cluster resource.

    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar properties: The properties of a cluster resource that may be updated.
    :vartype properties: ~azure.mgmt.avs.models.ClusterUpdateProperties
    """

    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""
    properties: Optional["_models.ClusterUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a cluster resource that may be updated."""

    __flattened_items = ["cluster_size", "hosts"]

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        properties: Optional["_models.ClusterUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ClusterUpdateProperties(_Model):
    """The properties of a cluster that may be updated.

    :ivar cluster_size: The cluster size.
    :vartype cluster_size: int
    :ivar hosts: The hosts.
    :vartype hosts: list[str]
    """

    cluster_size: Optional[int] = rest_field(
        name="clusterSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The cluster size."""
    hosts: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The hosts."""

    @overload
    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterZone(_Model):
    """Zone and associated hosts info.

    :ivar hosts: List of hosts belonging to the availability zone in a cluster.
    :vartype hosts: list[str]
    :ivar zone: Availability zone identifier.
    :vartype zone: str
    """

    hosts: Optional[list[str]] = rest_field(visibility=["read"])
    """List of hosts belonging to the availability zone in a cluster."""
    zone: Optional[str] = rest_field(visibility=["read"])
    """Availability zone identifier."""


class ClusterZoneList(_Model):
    """List of all zones and associated hosts for a cluster.

    :ivar zones: Zone and associated hosts info.
    :vartype zones: list[~azure.mgmt.avs.models.ClusterZone]
    """

    zones: Optional[list["_models.ClusterZone"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Zone and associated hosts info."""

    @overload
    def __init__(
        self,
        *,
        zones: Optional[list["_models.ClusterZone"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Datastore(ProxyResource):
    """A datastore resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.DatastoreProperties
    """

    properties: Optional["_models.DatastoreProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "provisioning_state",
        "net_app_volume",
        "disk_pool_volume",
        "elastic_san_volume",
        "pure_storage_volume",
        "status",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DatastoreProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DatastoreProperties(_Model):
    """The properties of a datastore.

    :ivar provisioning_state: The state of the datastore provisioning. Known values are:
     "Succeeded", "Failed", "Canceled", "Cancelled", "Pending", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.DatastoreProvisioningState
    :ivar net_app_volume: An Azure NetApp Files volume.
    :vartype net_app_volume: ~azure.mgmt.avs.models.NetAppVolume
    :ivar disk_pool_volume: An iSCSI volume.
    :vartype disk_pool_volume: ~azure.mgmt.avs.models.DiskPoolVolume
    :ivar elastic_san_volume: An Elastic SAN volume.
    :vartype elastic_san_volume: ~azure.mgmt.avs.models.ElasticSanVolume
    :ivar pure_storage_volume: A Pure Storage volume.
    :vartype pure_storage_volume: ~azure.mgmt.avs.models.PureStorageVolume
    :ivar status: The operational status of the datastore. Known values are: "Unknown",
     "Accessible", "Inaccessible", "Attached", "Detached", "LostCommunication", and "DeadOrError".
    :vartype status: str or ~azure.mgmt.avs.models.DatastoreStatus
    """

    provisioning_state: Optional[Union[str, "_models.DatastoreProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the datastore provisioning. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Cancelled\", \"Pending\", \"Creating\", \"Updating\", and \"Deleting\"."""
    net_app_volume: Optional["_models.NetAppVolume"] = rest_field(
        name="netAppVolume", visibility=["read", "create", "update", "delete", "query"]
    )
    """An Azure NetApp Files volume."""
    disk_pool_volume: Optional["_models.DiskPoolVolume"] = rest_field(
        name="diskPoolVolume", visibility=["read", "create", "update", "delete", "query"]
    )
    """An iSCSI volume."""
    elastic_san_volume: Optional["_models.ElasticSanVolume"] = rest_field(
        name="elasticSanVolume", visibility=["read", "create", "update", "delete", "query"]
    )
    """An Elastic SAN volume."""
    pure_storage_volume: Optional["_models.PureStorageVolume"] = rest_field(
        name="pureStorageVolume", visibility=["read", "create", "update", "delete", "query"]
    )
    """A Pure Storage volume."""
    status: Optional[Union[str, "_models.DatastoreStatus"]] = rest_field(visibility=["read"])
    """The operational status of the datastore. Known values are: \"Unknown\", \"Accessible\",
     \"Inaccessible\", \"Attached\", \"Detached\", \"LostCommunication\", and \"DeadOrError\"."""

    @overload
    def __init__(
        self,
        *,
        net_app_volume: Optional["_models.NetAppVolume"] = None,
        disk_pool_volume: Optional["_models.DiskPoolVolume"] = None,
        elastic_san_volume: Optional["_models.ElasticSanVolume"] = None,
        pure_storage_volume: Optional["_models.PureStorageVolume"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskPoolVolume(_Model):
    """An iSCSI volume from Microsoft.StoragePool provider.

    :ivar target_id: Azure resource ID of the iSCSI target. Required.
    :vartype target_id: str
    :ivar lun_name: Name of the LUN to be used for datastore. Required.
    :vartype lun_name: str
    :ivar mount_option: Mode that describes whether the LUN has to be mounted as a datastore or
     attached as a LUN. Known values are: "MOUNT" and "ATTACH".
    :vartype mount_option: str or ~azure.mgmt.avs.models.MountOptionEnum
    :ivar path: Device path.
    :vartype path: str
    """

    target_id: str = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the iSCSI target. Required."""
    lun_name: str = rest_field(name="lunName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the LUN to be used for datastore. Required."""
    mount_option: Optional[Union[str, "_models.MountOptionEnum"]] = rest_field(
        name="mountOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mode that describes whether the LUN has to be mounted as a datastore or
     attached as a LUN. Known values are: \"MOUNT\" and \"ATTACH\"."""
    path: Optional[str] = rest_field(visibility=["read"])
    """Device path."""

    @overload
    def __init__(
        self,
        *,
        target_id: str,
        lun_name: str,
        mount_option: Optional[Union[str, "_models.MountOptionEnum"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ElasticSanVolume(_Model):
    """An Elastic SAN volume from Microsoft.ElasticSan provider.

    :ivar target_id: Azure resource ID of the Elastic SAN Volume. Required.
    :vartype target_id: str
    """

    target_id: str = rest_field(name="targetId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the Elastic SAN Volume. Required."""

    @overload
    def __init__(
        self,
        *,
        target_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Encryption(_Model):
    """The properties of customer managed encryption key.

    :ivar status: Status of customer managed encryption key. Known values are: "Enabled" and
     "Disabled".
    :vartype status: str or ~azure.mgmt.avs.models.EncryptionState
    :ivar key_vault_properties: The key vault where the encryption key is stored.
    :vartype key_vault_properties: ~azure.mgmt.avs.models.EncryptionKeyVaultProperties
    """

    status: Optional[Union[str, "_models.EncryptionState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of customer managed encryption key. Known values are: \"Enabled\" and \"Disabled\"."""
    key_vault_properties: Optional["_models.EncryptionKeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The key vault where the encryption key is stored."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.EncryptionState"]] = None,
        key_vault_properties: Optional["_models.EncryptionKeyVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionKeyVaultProperties(_Model):
    """An Encryption Key.

    :ivar key_name: The name of the key.
    :vartype key_name: str
    :ivar key_version: The version of the key.
    :vartype key_version: str
    :ivar auto_detected_key_version: The auto-detected version of the key if versionType is
     auto-detected.
    :vartype auto_detected_key_version: str
    :ivar key_vault_url: The URL of the vault.
    :vartype key_vault_url: str
    :ivar key_state: The state of key provided. Known values are: "Connected" and "AccessDenied".
    :vartype key_state: str or ~azure.mgmt.avs.models.EncryptionKeyStatus
    :ivar version_type: Property of the key if user provided or auto detected. Known values are:
     "Fixed" and "AutoDetected".
    :vartype version_type: str or ~azure.mgmt.avs.models.EncryptionVersionType
    """

    key_name: Optional[str] = rest_field(name="keyName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the key."""
    key_version: Optional[str] = rest_field(
        name="keyVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the key."""
    auto_detected_key_version: Optional[str] = rest_field(name="autoDetectedKeyVersion", visibility=["read"])
    """The auto-detected version of the key if versionType is auto-detected."""
    key_vault_url: Optional[str] = rest_field(
        name="keyVaultUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the vault."""
    key_state: Optional[Union[str, "_models.EncryptionKeyStatus"]] = rest_field(name="keyState", visibility=["read"])
    """The state of key provided. Known values are: \"Connected\" and \"AccessDenied\"."""
    version_type: Optional[Union[str, "_models.EncryptionVersionType"]] = rest_field(
        name="versionType", visibility=["read"]
    )
    """Property of the key if user provided or auto detected. Known values are: \"Fixed\" and
     \"AutoDetected\"."""

    @overload
    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Endpoints(_Model):
    """Endpoint addresses.

    :ivar nsxt_manager: Endpoint FQDN for the NSX-T Data Center manager.
    :vartype nsxt_manager: str
    :ivar vcsa: Endpoint FQDN for Virtual Center Server Appliance.
    :vartype vcsa: str
    :ivar hcx_cloud_manager: Endpoint FQDN for the HCX Cloud Manager.
    :vartype hcx_cloud_manager: str
    :ivar nsxt_manager_ip: Endpoint IP for the NSX-T Data Center manager.
    :vartype nsxt_manager_ip: str
    :ivar vcenter_ip: Endpoint IP for Virtual Center Server Appliance.
    :vartype vcenter_ip: str
    :ivar hcx_cloud_manager_ip: Endpoint IP for the HCX Cloud Manager.
    :vartype hcx_cloud_manager_ip: str
    """

    nsxt_manager: Optional[str] = rest_field(name="nsxtManager", visibility=["read"])
    """Endpoint FQDN for the NSX-T Data Center manager."""
    vcsa: Optional[str] = rest_field(visibility=["read"])
    """Endpoint FQDN for Virtual Center Server Appliance."""
    hcx_cloud_manager: Optional[str] = rest_field(name="hcxCloudManager", visibility=["read"])
    """Endpoint FQDN for the HCX Cloud Manager."""
    nsxt_manager_ip: Optional[str] = rest_field(name="nsxtManagerIp", visibility=["read"])
    """Endpoint IP for the NSX-T Data Center manager."""
    vcenter_ip: Optional[str] = rest_field(name="vcenterIp", visibility=["read"])
    """Endpoint IP for Virtual Center Server Appliance."""
    hcx_cloud_manager_ip: Optional[str] = rest_field(name="hcxCloudManagerIp", visibility=["read"])
    """Endpoint IP for the HCX Cloud Manager."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.avs.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.avs.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.avs.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExpressRouteAuthorization(ProxyResource):
    """ExpressRoute Circuit Authorization.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.ExpressRouteAuthorizationProperties
    """

    properties: Optional["_models.ExpressRouteAuthorizationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "provisioning_state",
        "express_route_authorization_id",
        "express_route_authorization_key",
        "express_route_id",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ExpressRouteAuthorizationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ExpressRouteAuthorizationProperties(_Model):
    """The properties of an ExpressRoute Circuit Authorization resource.

    :ivar provisioning_state: The state of the ExpressRoute Circuit Authorization provisioning.
     Known values are: "Succeeded", "Failed", "Canceled", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.ExpressRouteAuthorizationProvisioningState
    :ivar express_route_authorization_id: The ID of the ExpressRoute Circuit Authorization.
    :vartype express_route_authorization_id: str
    :ivar express_route_authorization_key: The key of the ExpressRoute Circuit Authorization.
    :vartype express_route_authorization_key: str
    :ivar express_route_id: The ID of the ExpressRoute Circuit.
    :vartype express_route_id: str
    """

    provisioning_state: Optional[Union[str, "_models.ExpressRouteAuthorizationProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the ExpressRoute Circuit Authorization provisioning. Known values are:
     \"Succeeded\", \"Failed\", \"Canceled\", and \"Updating\"."""
    express_route_authorization_id: Optional[str] = rest_field(name="expressRouteAuthorizationId", visibility=["read"])
    """The ID of the ExpressRoute Circuit Authorization."""
    express_route_authorization_key: Optional[str] = rest_field(
        name="expressRouteAuthorizationKey", visibility=["read"]
    )
    """The key of the ExpressRoute Circuit Authorization."""
    express_route_id: Optional[str] = rest_field(
        name="expressRouteId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the ExpressRoute Circuit."""

    @overload
    def __init__(
        self,
        *,
        express_route_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HostProperties(_Model):
    """The properties of a host.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GeneralHostProperties, SpecializedHostProperties

    :ivar kind: The kind of host. Required. Known values are: "General" and "Specialized".
    :vartype kind: str or ~azure.mgmt.avs.models.HostKind
    :ivar provisioning_state: The state of the host provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.HostProvisioningState
    :ivar display_name: Display name of the host in VMware vCenter.
    :vartype display_name: str
    :ivar mo_ref_id: vCenter managed object reference ID of the host.
    :vartype mo_ref_id: str
    :ivar fqdn: Fully qualified domain name of the host.
    :vartype fqdn: str
    :ivar maintenance: If provided, the host is in maintenance. The value is the reason for
     maintenance. Known values are: "Replacement" and "Upgrade".
    :vartype maintenance: str or ~azure.mgmt.avs.models.HostMaintenance
    :ivar fault_domain:
    :vartype fault_domain: str
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create"])
    """The kind of host. Required. Known values are: \"General\" and \"Specialized\"."""
    provisioning_state: Optional[Union[str, "_models.HostProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the host provisioning. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the host in VMware vCenter."""
    mo_ref_id: Optional[str] = rest_field(name="moRefId", visibility=["read"])
    """vCenter managed object reference ID of the host."""
    fqdn: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified domain name of the host."""
    maintenance: Optional[Union[str, "_models.HostMaintenance"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """If provided, the host is in maintenance. The value is the reason for maintenance. Known values
     are: \"Replacement\" and \"Upgrade\"."""
    fault_domain: Optional[str] = rest_field(name="faultDomain", visibility=["read"])

    @overload
    def __init__(
        self,
        *,
        kind: str,
        display_name: Optional[str] = None,
        maintenance: Optional[Union[str, "_models.HostMaintenance"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GeneralHostProperties(HostProperties, discriminator="General"):
    """The properties of a general host.

    :ivar provisioning_state: The state of the host provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.HostProvisioningState
    :ivar display_name: Display name of the host in VMware vCenter.
    :vartype display_name: str
    :ivar mo_ref_id: vCenter managed object reference ID of the host.
    :vartype mo_ref_id: str
    :ivar fqdn: Fully qualified domain name of the host.
    :vartype fqdn: str
    :ivar maintenance: If provided, the host is in maintenance. The value is the reason for
     maintenance. Known values are: "Replacement" and "Upgrade".
    :vartype maintenance: str or ~azure.mgmt.avs.models.HostMaintenance
    :ivar fault_domain:
    :vartype fault_domain: str
    :ivar kind: The kind of host. Required.
    :vartype kind: str or ~azure.mgmt.avs.models.GENERAL
    """

    kind: Literal[HostKind.GENERAL] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of host. Required."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        maintenance: Optional[Union[str, "_models.HostMaintenance"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = HostKind.GENERAL  # type: ignore


class GlobalReachConnection(ProxyResource):
    """A global reach connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.GlobalReachConnectionProperties
    """

    properties: Optional["_models.GlobalReachConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "provisioning_state",
        "address_prefix",
        "authorization_key",
        "circuit_connection_status",
        "peer_express_route_circuit",
        "express_route_id",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GlobalReachConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GlobalReachConnectionProperties(_Model):
    """The properties of a global reach connection.

    :ivar provisioning_state: The state of the  ExpressRoute Circuit Authorization provisioning.
     Known values are: "Succeeded", "Failed", "Canceled", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.GlobalReachConnectionProvisioningState
    :ivar address_prefix: The network used for global reach carved out from the original network
     block
     provided for the private cloud.
    :vartype address_prefix: str
    :ivar authorization_key: Authorization key from the peer express route used for the global
     reach
     connection.
    :vartype authorization_key: str
    :ivar circuit_connection_status: The connection status of the global reach connection. Known
     values are: "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or ~azure.mgmt.avs.models.GlobalReachConnectionStatus
    :ivar peer_express_route_circuit: Identifier of the ExpressRoute Circuit to peer with in the
     global reach
     connection.
    :vartype peer_express_route_circuit: str
    :ivar express_route_id: The ID of the Private Cloud's ExpressRoute Circuit that is
     participating in the
     global reach connection.
    :vartype express_route_id: str
    """

    provisioning_state: Optional[Union[str, "_models.GlobalReachConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the  ExpressRoute Circuit Authorization provisioning. Known values are:
     \"Succeeded\", \"Failed\", \"Canceled\", and \"Updating\"."""
    address_prefix: Optional[str] = rest_field(name="addressPrefix", visibility=["read"])
    """The network used for global reach carved out from the original network block
     provided for the private cloud."""
    authorization_key: Optional[str] = rest_field(
        name="authorizationKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """Authorization key from the peer express route used for the global reach
     connection."""
    circuit_connection_status: Optional[Union[str, "_models.GlobalReachConnectionStatus"]] = rest_field(
        name="circuitConnectionStatus", visibility=["read"]
    )
    """The connection status of the global reach connection. Known values are: \"Connected\",
     \"Connecting\", and \"Disconnected\"."""
    peer_express_route_circuit: Optional[str] = rest_field(
        name="peerExpressRouteCircuit", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifier of the ExpressRoute Circuit to peer with in the global reach
     connection."""
    express_route_id: Optional[str] = rest_field(
        name="expressRouteId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the Private Cloud's ExpressRoute Circuit that is participating in the
     global reach connection."""

    @overload
    def __init__(
        self,
        *,
        authorization_key: Optional[str] = None,
        peer_express_route_circuit: Optional[str] = None,
        express_route_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HcxEnterpriseSite(ProxyResource):
    """An HCX Enterprise Site resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.HcxEnterpriseSiteProperties
    """

    properties: Optional["_models.HcxEnterpriseSiteProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "activation_key", "status"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.HcxEnterpriseSiteProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class HcxEnterpriseSiteProperties(_Model):
    """The properties of an HCX Enterprise Site.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.HcxEnterpriseSiteProvisioningState
    :ivar activation_key: The activation key.
    :vartype activation_key: str
    :ivar status: The status of the HCX Enterprise Site. Known values are: "Available", "Consumed",
     "Deactivated", and "Deleted".
    :vartype status: str or ~azure.mgmt.avs.models.HcxEnterpriseSiteStatus
    """

    provisioning_state: Optional[Union[str, "_models.HcxEnterpriseSiteProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    activation_key: Optional[str] = rest_field(name="activationKey", visibility=["read"])
    """The activation key."""
    status: Optional[Union[str, "_models.HcxEnterpriseSiteStatus"]] = rest_field(visibility=["read"])
    """The status of the HCX Enterprise Site. Known values are: \"Available\", \"Consumed\",
     \"Deactivated\", and \"Deleted\"."""


class Host(ProxyResource):
    """A host resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.HostProperties
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    """

    properties: Optional["_models.HostProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The availability zones."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.HostProperties"] = None,
        zones: Optional[list[str]] = None,
        sku: Optional["_models.Sku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IdentitySource(_Model):
    """vCenter Single Sign On Identity Source.

    :ivar name: The name of the identity source.
    :vartype name: str
    :ivar alias: The domain's NetBIOS name.
    :vartype alias: str
    :ivar domain: The domain's DNS name.
    :vartype domain: str
    :ivar base_user_dn: The base distinguished name for users.
    :vartype base_user_dn: str
    :ivar base_group_dn: The base distinguished name for groups.
    :vartype base_group_dn: str
    :ivar primary_server: Primary server URL.
    :vartype primary_server: str
    :ivar secondary_server: Secondary server URL.
    :vartype secondary_server: str
    :ivar ssl: Protect LDAP communication using SSL certificate (LDAPS). Known values are:
     "Enabled" and "Disabled".
    :vartype ssl: str or ~azure.mgmt.avs.models.SslEnum
    :ivar username: The ID of an Active Directory user with a minimum of read-only access to Base
     DN for users and group.
    :vartype username: str
    :ivar password: The password of the Active Directory user with a minimum of read-only access to
     Base DN for users and groups.
    :vartype password: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the identity source."""
    alias: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The domain's NetBIOS name."""
    domain: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The domain's DNS name."""
    base_user_dn: Optional[str] = rest_field(
        name="baseUserDN", visibility=["read", "create", "update", "delete", "query"]
    )
    """The base distinguished name for users."""
    base_group_dn: Optional[str] = rest_field(
        name="baseGroupDN", visibility=["read", "create", "update", "delete", "query"]
    )
    """The base distinguished name for groups."""
    primary_server: Optional[str] = rest_field(
        name="primaryServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Primary server URL."""
    secondary_server: Optional[str] = rest_field(
        name="secondaryServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Secondary server URL."""
    ssl: Optional[Union[str, "_models.SslEnum"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Protect LDAP communication using SSL certificate (LDAPS). Known values are: \"Enabled\" and
     \"Disabled\"."""
    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of an Active Directory user with a minimum of read-only access to Base
     DN for users and group."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password of the Active Directory user with a minimum of read-only access to
     Base DN for users and groups."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        alias: Optional[str] = None,
        domain: Optional[str] = None,
        base_user_dn: Optional[str] = None,
        base_group_dn: Optional[str] = None,
        primary_server: Optional[str] = None,
        secondary_server: Optional[str] = None,
        ssl: Optional[Union[str, "_models.SslEnum"]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImpactedMaintenanceResource(_Model):
    """Details about a resource impacted by a failed check.

    :ivar id: The ID of the impacted resource.
    :vartype id: str
    :ivar errors: A list of errors associated with the impacted resource.
    :vartype errors: list[~azure.mgmt.avs.models.ImpactedMaintenanceResourceError]
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The ID of the impacted resource."""
    errors: Optional[list["_models.ImpactedMaintenanceResourceError"]] = rest_field(visibility=["read"])
    """A list of errors associated with the impacted resource."""


class ImpactedMaintenanceResourceError(_Model):
    """Details about an error affecting a resource.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar name: The name of the error.
    :vartype name: str
    :ivar details: Additional details about the error.
    :vartype details: str
    :ivar resolution_steps: Steps to resolve the error.
    :vartype resolution_steps: list[str]
    :ivar action_required: Indicates whether action is required by the customer.
    :vartype action_required: bool
    """

    error_code: Optional[str] = rest_field(name="errorCode", visibility=["read"])
    """The error code."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the error."""
    details: Optional[str] = rest_field(visibility=["read"])
    """Additional details about the error."""
    resolution_steps: Optional[list[str]] = rest_field(name="resolutionSteps", visibility=["read"])
    """Steps to resolve the error."""
    action_required: Optional[bool] = rest_field(name="actionRequired", visibility=["read"])
    """Indicates whether action is required by the customer."""


class IscsiPath(ProxyResource):
    """An iSCSI path resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.IscsiPathProperties
    """

    properties: Optional["_models.IscsiPathProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "network_block"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.IscsiPathProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class IscsiPathProperties(_Model):
    """The properties of an iSCSI path resource.

    :ivar provisioning_state: The state of the iSCSI path provisioning. Known values are:
     "Succeeded", "Failed", "Canceled", "Pending", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.IscsiPathProvisioningState
    :ivar network_block: CIDR Block for iSCSI path. Required.
    :vartype network_block: str
    """

    provisioning_state: Optional[Union[str, "_models.IscsiPathProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the iSCSI path provisioning. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Pending\", \"Building\", \"Deleting\", and \"Updating\"."""
    network_block: str = rest_field(name="networkBlock", visibility=["read", "create"])
    """CIDR Block for iSCSI path. Required."""

    @overload
    def __init__(
        self,
        *,
        network_block: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Label(_Model):
    """A key-value pair representing a label.

    :ivar key: The key of the label. Required.
    :vartype key: str
    :ivar value: The value of the label. Required.
    :vartype value: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key of the label. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the label. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class License(ProxyResource):
    """A license resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.LicenseProperties
    """

    properties: Optional["_models.LicenseProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.LicenseProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LicenseProperties(_Model):
    """The properties of a license.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VmwareFirewallLicenseProperties

    :ivar kind: License kind. Required. "VmwareFirewall"
    :vartype kind: str or ~azure.mgmt.avs.models.LicenseKind
    :ivar provisioning_state: The state of the license provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.LicenseProvisioningState
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """License kind. Required. \"VmwareFirewall\""""
    provisioning_state: Optional[Union[str, "_models.LicenseProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the license provisioning. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Maintenance(ProxyResource):
    """A cluster resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.MaintenanceProperties
    """

    properties: Optional["_models.MaintenanceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.MaintenanceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceFailedCheck(_Model):
    """Details about a failed maintenance check.

    :ivar name: The name of the failed check.
    :vartype name: str
    :ivar impacted_resources: A list of resources impacted by the failed check.
    :vartype impacted_resources: list[~azure.mgmt.avs.models.ImpactedMaintenanceResource]
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the failed check."""
    impacted_resources: Optional[list["_models.ImpactedMaintenanceResource"]] = rest_field(
        name="impactedResources", visibility=["read"]
    )
    """A list of resources impacted by the failed check."""


class MaintenanceManagementOperation(_Model):
    """Defines operations that can be performed on maintenance.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MaintenanceReadinessRefreshOperation, RescheduleOperation, ScheduleOperation

    :ivar kind: The kind of operation. Required. Known values are: "Schedule", "Reschedule", and
     "MaintenanceReadinessRefresh".
    :vartype kind: str or ~azure.mgmt.avs.models.MaintenanceManagementOperationKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read"])
    """The kind of operation. Required. Known values are: \"Schedule\", \"Reschedule\", and
     \"MaintenanceReadinessRefresh\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceProperties(_Model):
    """properties of a maintenance.

    :ivar component: type of maintenance. Known values are: "VCSA", "ESXI", and "NSXT".
    :vartype component: str or ~azure.mgmt.avs.models.MaintenanceType
    :ivar display_name: Display name for maintenance.
    :vartype display_name: str
    :ivar cluster_id: Cluster ID for on which maintenance will be applied. Empty if maintenance is
     at private cloud level.
    :vartype cluster_id: int
    :ivar info_link: Link to maintenance info.
    :vartype info_link: str
    :ivar impact: Impact on the resource during maintenance period.
    :vartype impact: str
    :ivar scheduled_by_microsoft: If maintenance is scheduled by Microsoft.
    :vartype scheduled_by_microsoft: bool
    :ivar state: The state of the maintenance.
    :vartype state: ~azure.mgmt.avs.models.MaintenanceState
    :ivar scheduled_start_time: Scheduled maintenance start time.
    :vartype scheduled_start_time: ~datetime.datetime
    :ivar estimated_duration_in_minutes: Estimated time maintenance will take in minutes.
    :vartype estimated_duration_in_minutes: int
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.MaintenanceProvisioningState
    :ivar operations: Operations on  maintenance.
    :vartype operations: list[~azure.mgmt.avs.models.MaintenanceManagementOperation]
    :ivar maintenance_readiness: Indicates whether the maintenance is ready to proceed.
    :vartype maintenance_readiness: ~azure.mgmt.avs.models.MaintenanceReadiness
    """

    component: Optional[Union[str, "_models.MaintenanceType"]] = rest_field(visibility=["read"])
    """type of maintenance. Known values are: \"VCSA\", \"ESXI\", and \"NSXT\"."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """Display name for maintenance."""
    cluster_id: Optional[int] = rest_field(name="clusterId", visibility=["read"])
    """Cluster ID for on which maintenance will be applied. Empty if maintenance is at private cloud
     level."""
    info_link: Optional[str] = rest_field(name="infoLink", visibility=["read"])
    """Link to maintenance info."""
    impact: Optional[str] = rest_field(visibility=["read"])
    """Impact on the resource during maintenance period."""
    scheduled_by_microsoft: Optional[bool] = rest_field(name="scheduledByMicrosoft", visibility=["read"])
    """If maintenance is scheduled by Microsoft."""
    state: Optional["_models.MaintenanceState"] = rest_field(visibility=["read"])
    """The state of the maintenance."""
    scheduled_start_time: Optional[datetime.datetime] = rest_field(
        name="scheduledStartTime", visibility=["read"], format="rfc3339"
    )
    """Scheduled maintenance start time."""
    estimated_duration_in_minutes: Optional[int] = rest_field(name="estimatedDurationInMinutes", visibility=["read"])
    """Estimated time maintenance will take in minutes."""
    provisioning_state: Optional[Union[str, "_models.MaintenanceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", and
     \"Updating\"."""
    operations: Optional[list["_models.MaintenanceManagementOperation"]] = rest_field(visibility=["read"])
    """Operations on  maintenance."""
    maintenance_readiness: Optional["_models.MaintenanceReadiness"] = rest_field(
        name="maintenanceReadiness", visibility=["read"]
    )
    """Indicates whether the maintenance is ready to proceed."""


class MaintenanceReadiness(_Model):
    """Maintenance readiness details.

    :ivar type: The type of maintenance readiness check. Required. Known values are: "Precheck" and
     "Preflight".
    :vartype type: str or ~azure.mgmt.avs.models.MaintenanceCheckType
    :ivar status: The current readiness status of maintenance. Required. Known values are: "Ready",
     "NotReady", "DataNotAvailable", and "NotApplicable".
    :vartype status: str or ~azure.mgmt.avs.models.MaintenanceReadinessStatus
    :ivar message: A summary message of the readiness check result.
    :vartype message: str
    :ivar failed_checks: A list of failed checks, if any.
    :vartype failed_checks: list[~azure.mgmt.avs.models.MaintenanceFailedCheck]
    :ivar last_updated: The timestamp of the last readiness update.
    :vartype last_updated: ~datetime.datetime
    """

    type: Union[str, "_models.MaintenanceCheckType"] = rest_field(visibility=["read"])
    """The type of maintenance readiness check. Required. Known values are: \"Precheck\" and
     \"Preflight\"."""
    status: Union[str, "_models.MaintenanceReadinessStatus"] = rest_field(visibility=["read"])
    """The current readiness status of maintenance. Required. Known values are: \"Ready\",
     \"NotReady\", \"DataNotAvailable\", and \"NotApplicable\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """A summary message of the readiness check result."""
    failed_checks: Optional[list["_models.MaintenanceFailedCheck"]] = rest_field(
        name="failedChecks", visibility=["read"]
    )
    """A list of failed checks, if any."""
    last_updated: Optional[datetime.datetime] = rest_field(name="lastUpdated", visibility=["read"], format="rfc3339")
    """The timestamp of the last readiness update."""


class MaintenanceReadinessRefreshOperation(MaintenanceManagementOperation, discriminator="MaintenanceReadinessRefresh"):
    """Refresh MaintenanceReadiness status.

    :ivar kind: The kind of operation. Required. Represents a maintenance readiness refresh
     operation
    :vartype kind: str or ~azure.mgmt.avs.models.MAINTENANCE_READINESS_REFRESH
    :ivar is_disabled: If maintenanceReadiness refresh is disabled.
    :vartype is_disabled: bool
    :ivar disabled_reason: Reason disabling refresh for maintenanceReadiness.
    :vartype disabled_reason: str
    :ivar status: Status of the operation. Known values are: "InProgress", "NotStarted", "Failed",
     and "NotApplicable".
    :vartype status: str or ~azure.mgmt.avs.models.MaintenanceReadinessRefreshOperationStatus
    :ivar refreshed_by_microsoft: Indicates if the operation was refreshed by Microsoft.
    :vartype refreshed_by_microsoft: bool
    :ivar message: Additional message about the operation.
    :vartype message: str
    """

    kind: Literal[MaintenanceManagementOperationKind.MAINTENANCE_READINESS_REFRESH] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of operation. Required. Represents a maintenance readiness refresh operation"""
    is_disabled: Optional[bool] = rest_field(name="isDisabled", visibility=["read"])
    """If maintenanceReadiness refresh is disabled."""
    disabled_reason: Optional[str] = rest_field(name="disabledReason", visibility=["read"])
    """Reason disabling refresh for maintenanceReadiness."""
    status: Optional[Union[str, "_models.MaintenanceReadinessRefreshOperationStatus"]] = rest_field(visibility=["read"])
    """Status of the operation. Known values are: \"InProgress\", \"NotStarted\", \"Failed\", and
     \"NotApplicable\"."""
    refreshed_by_microsoft: Optional[bool] = rest_field(name="refreshedByMicrosoft", visibility=["read"])
    """Indicates if the operation was refreshed by Microsoft."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Additional message about the operation."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MaintenanceManagementOperationKind.MAINTENANCE_READINESS_REFRESH  # type: ignore


class MaintenanceReschedule(_Model):
    """reschedule a maintenance.

    :ivar reschedule_time: reschedule time.
    :vartype reschedule_time: ~datetime.datetime
    :ivar message: rescheduling reason.
    :vartype message: str
    """

    reschedule_time: Optional[datetime.datetime] = rest_field(
        name="rescheduleTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """reschedule time."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """rescheduling reason."""

    @overload
    def __init__(
        self,
        *,
        reschedule_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceSchedule(_Model):
    """schedule a maintenance.

    :ivar schedule_time: schedule time.
    :vartype schedule_time: ~datetime.datetime
    :ivar message: scheduling message.
    :vartype message: str
    """

    schedule_time: Optional[datetime.datetime] = rest_field(
        name="scheduleTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """schedule time."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """scheduling message."""

    @overload
    def __init__(
        self,
        *,
        schedule_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceState(_Model):
    """state of the maintenance.

    :ivar name: Customer presentable maintenance state. Known values are: "NotScheduled",
     "Scheduled", "InProgress", "Success", "Failed", and "Canceled".
    :vartype name: str or ~azure.mgmt.avs.models.MaintenanceStateName
    :ivar message: Failure/Success info.
    :vartype message: str
    :ivar started_at: Time when current state started.
    :vartype started_at: ~datetime.datetime
    :ivar ended_at: Time when current state ended.
    :vartype ended_at: ~datetime.datetime
    """

    name: Optional[Union[str, "_models.MaintenanceStateName"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer presentable maintenance state. Known values are: \"NotScheduled\", \"Scheduled\",
     \"InProgress\", \"Success\", \"Failed\", and \"Canceled\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Failure/Success info."""
    started_at: Optional[datetime.datetime] = rest_field(
        name="startedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time when current state started."""
    ended_at: Optional[datetime.datetime] = rest_field(
        name="endedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Time when current state ended."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.MaintenanceStateName"]] = None,
        message: Optional[str] = None,
        started_at: Optional[datetime.datetime] = None,
        ended_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagementCluster(_Model):
    """The properties of a management cluster.

    :ivar cluster_size: The cluster size.
    :vartype cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :ivar hosts: The hosts.
    :vartype hosts: list[str]
    :ivar vsan_datastore_name: Name of the vsan datastore associated with the cluster.
    :vartype vsan_datastore_name: str
    """

    cluster_size: Optional[int] = rest_field(
        name="clusterSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The cluster size."""
    provisioning_state: Optional[Union[str, "_models.ClusterProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the cluster provisioning. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Cancelled\", \"Deleting\", and \"Updating\"."""
    cluster_id: Optional[int] = rest_field(name="clusterId", visibility=["read"])
    """The identity."""
    hosts: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The hosts."""
    vsan_datastore_name: Optional[str] = rest_field(
        name="vsanDatastoreName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the vsan datastore associated with the cluster."""

    @overload
    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[list[str]] = None,
        vsan_datastore_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetAppVolume(_Model):
    """An Azure NetApp Files volume from Microsoft.NetApp provider.

    :ivar id: Azure resource ID of the NetApp volume. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the NetApp volume. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.avs.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.avs.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.avs.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PlacementPolicy(ProxyResource):
    """A vSphere Distributed Resource Scheduler (DRS) placement policy.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.PlacementPolicyProperties
    """

    properties: Optional["_models.PlacementPolicyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PlacementPolicyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlacementPolicyProperties(_Model):
    """Abstract placement policy properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VmHostPlacementPolicyProperties, VmPlacementPolicyProperties

    :ivar type: Placement Policy type. Required. Known values are: "VmVm" and "VmHost".
    :vartype type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar display_name: Display name of the placement policy.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Placement Policy type. Required. Known values are: \"VmVm\" and \"VmHost\"."""
    state: Optional[Union[str, "_models.PlacementPolicyState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the placement policy is enabled or disabled. Known values are: \"Enabled\" and
     \"Disabled\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the placement policy."""
    provisioning_state: Optional[Union[str, "_models.PlacementPolicyProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PlacementPolicyUpdate(_Model):
    """An update of a DRS placement policy resource.

    :ivar properties: The properties of a placement policy resource that may be updated.
    :vartype properties: ~azure.mgmt.avs.models.PlacementPolicyUpdateProperties
    """

    properties: Optional["_models.PlacementPolicyUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a placement policy resource that may be updated."""

    __flattened_items = ["state", "vm_members", "host_members", "affinity_strength", "azure_hybrid_benefit_type"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PlacementPolicyUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PlacementPolicyUpdateProperties(_Model):
    """The properties of a placement policy resource that may be updated.

    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar vm_members: Virtual machine members list.
    :vartype vm_members: list[str]
    :ivar host_members: Host members list.
    :vartype host_members: list[str]
    :ivar affinity_strength: vm-host placement policy affinity strength (should/must). Known values
     are: "Should" and "Must".
    :vartype affinity_strength: str or ~azure.mgmt.avs.models.AffinityStrength
    :ivar azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type. Known
     values are: "SqlHost" and "None".
    :vartype azure_hybrid_benefit_type: str or ~azure.mgmt.avs.models.AzureHybridBenefitType
    """

    state: Optional[Union[str, "_models.PlacementPolicyState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the placement policy is enabled or disabled. Known values are: \"Enabled\" and
     \"Disabled\"."""
    vm_members: Optional[list[str]] = rest_field(
        name="vmMembers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Virtual machine members list."""
    host_members: Optional[list[str]] = rest_field(
        name="hostMembers", visibility=["read", "create", "update", "delete", "query"]
    )
    """Host members list."""
    affinity_strength: Optional[Union[str, "_models.AffinityStrength"]] = rest_field(
        name="affinityStrength", visibility=["read", "create", "update", "delete", "query"]
    )
    """vm-host placement policy affinity strength (should/must). Known values are: \"Should\" and
     \"Must\"."""
    azure_hybrid_benefit_type: Optional[Union[str, "_models.AzureHybridBenefitType"]] = rest_field(
        name="azureHybridBenefitType", visibility=["read", "create", "update", "delete", "query"]
    )
    """placement policy azure hybrid benefit opt-in type. Known values are: \"SqlHost\" and \"None\"."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        vm_members: Optional[list[str]] = None,
        host_members: Optional[list[str]] = None,
        affinity_strength: Optional[Union[str, "_models.AffinityStrength"]] = None,
        azure_hybrid_benefit_type: Optional[Union[str, "_models.AzureHybridBenefitType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateCloud(TrackedResource):
    """A private cloud resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.PrivateCloudProperties
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource. Required.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    """

    properties: Optional["_models.PrivateCloudProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource. Required."""
    identity: Optional["_models.PrivateCloudIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The availability zones."""

    __flattened_items = [
        "management_cluster",
        "internet",
        "identity_sources",
        "availability",
        "encryption",
        "extended_network_blocks",
        "provisioning_state",
        "circuit",
        "endpoints",
        "network_block",
        "management_network",
        "provisioning_network",
        "vmotion_network",
        "vcenter_password",
        "nsxt_password",
        "vcenter_certificate_thumbprint",
        "nsxt_certificate_thumbprint",
        "external_cloud_links",
        "secondary_circuit",
        "nsx_public_ip_quota_raised",
        "virtual_network_id",
        "dns_zone_type",
        "vcf_license",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.PrivateCloudProperties"] = None,
        identity: Optional["_models.PrivateCloudIdentity"] = None,
        zones: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateCloudIdentity(_Model):
    """Managed service identity (either system assigned, or none).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None" and "SystemAssigned".
    :vartype type: str or ~azure.mgmt.avs.models.ResourceIdentityType
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ResourceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\"
     and \"SystemAssigned\"."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ResourceIdentityType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateCloudProperties(_Model):
    """The properties of a private cloud resource.

    :ivar management_cluster: The default cluster used for management. Required.
    :vartype management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :ivar internet: Connectivity to internet is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype internet: str or ~azure.mgmt.avs.models.InternetEnum
    :ivar identity_sources: vCenter Single Sign On Identity Sources.
    :vartype identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :ivar availability: Properties describing how the cloud is distributed across availability
     zones.
    :vartype availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :ivar encryption: Customer managed key encryption, can be enabled or disabled.
    :vartype encryption: ~azure.mgmt.avs.models.Encryption
    :ivar extended_network_blocks: Array of additional networks noncontiguous with networkBlock.
     Networks must be
     unique and non-overlapping across VNet in your subscription, on-premise, and
     this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
     (A.B.C.D/X).
    :vartype extended_network_blocks: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Cancelled", "Pending", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PrivateCloudProvisioningState
    :ivar circuit: An ExpressRoute Circuit.
    :vartype circuit: ~azure.mgmt.avs.models.Circuit
    :ivar endpoints: The endpoints.
    :vartype endpoints: ~azure.mgmt.avs.models.Endpoints
    :ivar network_block: The block of addresses should be unique across VNet in your subscription
     as
     well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where
     A,B,C,D are between 0 and 255, and X is between 0 and 22. Required.
    :vartype network_block: str
    :ivar management_network: Network used to access vCenter Server and NSX-T Manager.
    :vartype management_network: str
    :ivar provisioning_network: Used for virtual machine cold migration, cloning, and snapshot
     migration.
    :vartype provisioning_network: str
    :ivar vmotion_network: Used for live migration of virtual machines.
    :vartype vmotion_network: str
    :ivar vcenter_password: Optionally, set the vCenter admin password when the private cloud is
     created.
    :vartype vcenter_password: str
    :ivar nsxt_password: Optionally, set the NSX-T Manager password when the private cloud is
     created.
    :vartype nsxt_password: str
    :ivar vcenter_certificate_thumbprint: Thumbprint of the vCenter Server SSL certificate.
    :vartype vcenter_certificate_thumbprint: str
    :ivar nsxt_certificate_thumbprint: Thumbprint of the NSX-T Manager SSL certificate.
    :vartype nsxt_certificate_thumbprint: str
    :ivar external_cloud_links: Array of cloud link IDs from other clouds that connect to this one.
    :vartype external_cloud_links: list[str]
    :ivar secondary_circuit: A secondary expressRoute circuit from a separate AZ. Only present in a
     stretched private cloud.
    :vartype secondary_circuit: ~azure.mgmt.avs.models.Circuit
    :ivar nsx_public_ip_quota_raised: Flag to indicate whether the private cloud has the quota for
     provisioned NSX
     Public IP count raised from 64 to 1024. Known values are: "Enabled" and "Disabled".
    :vartype nsx_public_ip_quota_raised: str or ~azure.mgmt.avs.models.NsxPublicIpQuotaRaisedEnum
    :ivar virtual_network_id: Azure resource ID of the virtual network.
    :vartype virtual_network_id: str
    :ivar dns_zone_type: The type of DNS zone to use. Known values are: "Public" and "Private".
    :vartype dns_zone_type: str or ~azure.mgmt.avs.models.DnsZoneType
    :ivar vcf_license: The private cloud license.
    :vartype vcf_license: ~azure.mgmt.avs.models.VcfLicense
    """

    management_cluster: "_models.ManagementCluster" = rest_field(
        name="managementCluster", visibility=["read", "create", "update", "delete", "query"]
    )
    """The default cluster used for management. Required."""
    internet: Optional[Union[str, "_models.InternetEnum"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Connectivity to internet is enabled or disabled. Known values are: \"Enabled\" and
     \"Disabled\"."""
    identity_sources: Optional[list["_models.IdentitySource"]] = rest_field(
        name="identitySources", visibility=["read", "create", "update", "delete", "query"]
    )
    """vCenter Single Sign On Identity Sources."""
    availability: Optional["_models.AvailabilityProperties"] = rest_field(visibility=["read", "create"])
    """Properties describing how the cloud is distributed across availability zones."""
    encryption: Optional["_models.Encryption"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Customer managed key encryption, can be enabled or disabled."""
    extended_network_blocks: Optional[list[str]] = rest_field(
        name="extendedNetworkBlocks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of additional networks noncontiguous with networkBlock. Networks must be
     unique and non-overlapping across VNet in your subscription, on-premise, and
     this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
     (A.B.C.D/X)."""
    provisioning_state: Optional[Union[str, "_models.PrivateCloudProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Cancelled\", \"Pending\", \"Building\", \"Deleting\", and \"Updating\"."""
    circuit: Optional["_models.Circuit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An ExpressRoute Circuit."""
    endpoints: Optional["_models.Endpoints"] = rest_field(visibility=["read"])
    """The endpoints."""
    network_block: str = rest_field(name="networkBlock", visibility=["read", "create", "update", "delete", "query"])
    """The block of addresses should be unique across VNet in your subscription as
     well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where
     A,B,C,D are between 0 and 255, and X is between 0 and 22. Required."""
    management_network: Optional[str] = rest_field(name="managementNetwork", visibility=["read"])
    """Network used to access vCenter Server and NSX-T Manager."""
    provisioning_network: Optional[str] = rest_field(name="provisioningNetwork", visibility=["read"])
    """Used for virtual machine cold migration, cloning, and snapshot migration."""
    vmotion_network: Optional[str] = rest_field(name="vmotionNetwork", visibility=["read"])
    """Used for live migration of virtual machines."""
    vcenter_password: Optional[str] = rest_field(
        name="vcenterPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optionally, set the vCenter admin password when the private cloud is created."""
    nsxt_password: Optional[str] = rest_field(
        name="nsxtPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optionally, set the NSX-T Manager password when the private cloud is created."""
    vcenter_certificate_thumbprint: Optional[str] = rest_field(name="vcenterCertificateThumbprint", visibility=["read"])
    """Thumbprint of the vCenter Server SSL certificate."""
    nsxt_certificate_thumbprint: Optional[str] = rest_field(name="nsxtCertificateThumbprint", visibility=["read"])
    """Thumbprint of the NSX-T Manager SSL certificate."""
    external_cloud_links: Optional[list[str]] = rest_field(name="externalCloudLinks", visibility=["read"])
    """Array of cloud link IDs from other clouds that connect to this one."""
    secondary_circuit: Optional["_models.Circuit"] = rest_field(
        name="secondaryCircuit", visibility=["read", "create", "update", "delete", "query"]
    )
    """A secondary expressRoute circuit from a separate AZ. Only present in a
     stretched private cloud."""
    nsx_public_ip_quota_raised: Optional[Union[str, "_models.NsxPublicIpQuotaRaisedEnum"]] = rest_field(
        name="nsxPublicIpQuotaRaised", visibility=["read"]
    )
    """Flag to indicate whether the private cloud has the quota for provisioned NSX
     Public IP count raised from 64 to 1024. Known values are: \"Enabled\" and \"Disabled\"."""
    virtual_network_id: Optional[str] = rest_field(name="virtualNetworkId", visibility=["read", "create"])
    """Azure resource ID of the virtual network."""
    dns_zone_type: Optional[Union[str, "_models.DnsZoneType"]] = rest_field(
        name="dnsZoneType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of DNS zone to use. Known values are: \"Public\" and \"Private\"."""
    vcf_license: Optional["_models.VcfLicense"] = rest_field(
        name="vcfLicense", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private cloud license."""

    @overload
    def __init__(
        self,
        *,
        management_cluster: "_models.ManagementCluster",
        network_block: str,
        internet: Optional[Union[str, "_models.InternetEnum"]] = None,
        identity_sources: Optional[list["_models.IdentitySource"]] = None,
        availability: Optional["_models.AvailabilityProperties"] = None,
        encryption: Optional["_models.Encryption"] = None,
        extended_network_blocks: Optional[list[str]] = None,
        circuit: Optional["_models.Circuit"] = None,
        vcenter_password: Optional[str] = None,
        nsxt_password: Optional[str] = None,
        secondary_circuit: Optional["_models.Circuit"] = None,
        virtual_network_id: Optional[str] = None,
        dns_zone_type: Optional[Union[str, "_models.DnsZoneType"]] = None,
        vcf_license: Optional["_models.VcfLicense"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateCloudUpdate(_Model):
    """An update to a private cloud resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
    :ivar properties: The updatable properties of a private cloud resource.
    :vartype properties: ~azure.mgmt.avs.models.PrivateCloudUpdateProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""
    identity: Optional["_models.PrivateCloudIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    properties: Optional["_models.PrivateCloudUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The updatable properties of a private cloud resource."""

    __flattened_items = [
        "management_cluster",
        "internet",
        "identity_sources",
        "availability",
        "encryption",
        "extended_network_blocks",
        "dns_zone_type",
    ]

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.PrivateCloudIdentity"] = None,
        properties: Optional["_models.PrivateCloudUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateCloudUpdateProperties(_Model):
    """The properties of a private cloud resource that may be updated.

    :ivar management_cluster: The default cluster used for management.
    :vartype management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :ivar internet: Connectivity to internet is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype internet: str or ~azure.mgmt.avs.models.InternetEnum
    :ivar identity_sources: vCenter Single Sign On Identity Sources.
    :vartype identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :ivar availability: Properties describing how the cloud is distributed across availability
     zones.
    :vartype availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :ivar encryption: Customer managed key encryption, can be enabled or disabled.
    :vartype encryption: ~azure.mgmt.avs.models.Encryption
    :ivar extended_network_blocks: Array of additional networks noncontiguous with networkBlock.
     Networks must be
     unique and non-overlapping across VNet in your subscription, on-premise, and
     this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
     (A.B.C.D/X).
    :vartype extended_network_blocks: list[str]
    :ivar dns_zone_type: The type of DNS zone to use. Known values are: "Public" and "Private".
    :vartype dns_zone_type: str or ~azure.mgmt.avs.models.DnsZoneType
    """

    management_cluster: Optional["_models.ManagementCluster"] = rest_field(
        name="managementCluster", visibility=["read", "create", "update", "delete", "query"]
    )
    """The default cluster used for management."""
    internet: Optional[Union[str, "_models.InternetEnum"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Connectivity to internet is enabled or disabled. Known values are: \"Enabled\" and
     \"Disabled\"."""
    identity_sources: Optional[list["_models.IdentitySource"]] = rest_field(
        name="identitySources", visibility=["read", "create", "update", "delete", "query"]
    )
    """vCenter Single Sign On Identity Sources."""
    availability: Optional["_models.AvailabilityProperties"] = rest_field(visibility=["read", "create"])
    """Properties describing how the cloud is distributed across availability zones."""
    encryption: Optional["_models.Encryption"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Customer managed key encryption, can be enabled or disabled."""
    extended_network_blocks: Optional[list[str]] = rest_field(
        name="extendedNetworkBlocks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of additional networks noncontiguous with networkBlock. Networks must be
     unique and non-overlapping across VNet in your subscription, on-premise, and
     this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
     (A.B.C.D/X)."""
    dns_zone_type: Optional[Union[str, "_models.DnsZoneType"]] = rest_field(
        name="dnsZoneType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of DNS zone to use. Known values are: \"Public\" and \"Private\"."""

    @overload
    def __init__(
        self,
        *,
        management_cluster: Optional["_models.ManagementCluster"] = None,
        internet: Optional[Union[str, "_models.InternetEnum"]] = None,
        identity_sources: Optional[list["_models.IdentitySource"]] = None,
        availability: Optional["_models.AvailabilityProperties"] = None,
        encryption: Optional["_models.Encryption"] = None,
        extended_network_blocks: Optional[list[str]] = None,
        dns_zone_type: Optional[Union[str, "_models.DnsZoneType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProvisionedNetwork(ProxyResource):
    """A provisioned network resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.ProvisionedNetworkProperties
    """

    properties: Optional["_models.ProvisionedNetworkProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ProvisionedNetworkProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProvisionedNetworkProperties(_Model):
    """The properties of a provisioned network.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ProvisionedNetworkProvisioningState
    :ivar address_prefix: The address prefixes of the provisioned network in CIDR notation.
    :vartype address_prefix: str
    :ivar network_type: The type of network provisioned. Known values are: "esxManagement",
     "esxReplication", "hcxManagement", "hcxUplink", "vcenterManagement", "vmotion", and "vsan".
    :vartype network_type: str or ~azure.mgmt.avs.models.ProvisionedNetworkTypes
    """

    provisioning_state: Optional[Union[str, "_models.ProvisionedNetworkProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    address_prefix: Optional[str] = rest_field(name="addressPrefix", visibility=["read"])
    """The address prefixes of the provisioned network in CIDR notation."""
    network_type: Optional[Union[str, "_models.ProvisionedNetworkTypes"]] = rest_field(
        name="networkType", visibility=["read"]
    )
    """The type of network provisioned. Known values are: \"esxManagement\", \"esxReplication\",
     \"hcxManagement\", \"hcxUplink\", \"vcenterManagement\", \"vmotion\", and \"vsan\"."""


class ScriptExecutionParameter(_Model):
    """The arguments passed in to the execution.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    PSCredentialExecutionParameter, ScriptSecureStringExecutionParameter,
    ScriptStringExecutionParameter

    :ivar type: script execution parameter type. Required. Known values are: "Value",
     "SecureValue", and "Credential".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :ivar name: The parameter name. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """script execution parameter type. Required. Known values are: \"Value\", \"SecureValue\", and
     \"Credential\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The parameter name. Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PSCredentialExecutionParameter(ScriptExecutionParameter, discriminator="Credential"):
    """a powershell credential object.

    :ivar name: The parameter name. Required.
    :vartype name: str
    :ivar username: username for login.
    :vartype username: str
    :ivar password: password for login.
    :vartype password: str
    :ivar type: The type of execution parameter. Required.
    :vartype type: str or ~azure.mgmt.avs.models.CREDENTIAL
    """

    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """username for login."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """password for login."""
    type: Literal[ScriptExecutionParameterType.CREDENTIAL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of execution parameter. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        username: Optional[str] = None,
        password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ScriptExecutionParameterType.CREDENTIAL  # type: ignore


class PureStoragePolicy(ProxyResource):
    """An instance describing a Pure Storage Policy Based Management policy.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.PureStoragePolicyProperties
    """

    properties: Optional["_models.PureStoragePolicyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PureStoragePolicyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PureStoragePolicyProperties(_Model):
    """Properties of a Pure Storage Policy Based Management policy.

    :ivar storage_policy_definition: Definition of a Pure Storage Policy Based Management policy.
     Required.
    :vartype storage_policy_definition: str
    :ivar storage_pool_id: Azure resource ID of the Pure Storage Pool associated with the storage
     policy. Required.
    :vartype storage_pool_id: str
    :ivar provisioning_state: The state of the Pure Storage Policy Based Management policy
     provisioning. Known values are: "Succeeded", "Failed", "Canceled", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PureStoragePolicyProvisioningState
    """

    storage_policy_definition: str = rest_field(
        name="storagePolicyDefinition", visibility=["read", "create", "update", "delete", "query"]
    )
    """Definition of a Pure Storage Policy Based Management policy. Required."""
    storage_pool_id: str = rest_field(name="storagePoolId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the Pure Storage Pool associated with the storage policy. Required."""
    provisioning_state: Optional[Union[str, "_models.PureStoragePolicyProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the Pure Storage Policy Based Management policy provisioning. Known values are:
     \"Succeeded\", \"Failed\", \"Canceled\", \"Deleting\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        storage_policy_definition: str,
        storage_pool_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PureStorageVolume(_Model):
    """A Pure Storage volume from PureStorage.Block provider.

    :ivar storage_pool_id: Azure resource ID of the Pure Storage Pool. Required.
    :vartype storage_pool_id: str
    :ivar size_gb: Volume size to be used to create a Virtual Volumes (vVols) datastore. Required.
    :vartype size_gb: int
    """

    storage_pool_id: str = rest_field(name="storagePoolId", visibility=["read", "create", "update", "delete", "query"])
    """Azure resource ID of the Pure Storage Pool. Required."""
    size_gb: int = rest_field(name="sizeGb", visibility=["read", "create", "update", "delete", "query"])
    """Volume size to be used to create a Virtual Volumes (vVols) datastore. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_pool_id: str,
        size_gb: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Quota(_Model):
    """Subscription quotas.

    :ivar hosts_remaining: Remaining hosts quota by sku type.
    :vartype hosts_remaining: dict[str, int]
    :ivar quota_enabled: Host quota is active for current subscription. Known values are: "Enabled"
     and "Disabled".
    :vartype quota_enabled: str or ~azure.mgmt.avs.models.QuotaEnabled
    """

    hosts_remaining: Optional[dict[str, int]] = rest_field(name="hostsRemaining", visibility=["read"])
    """Remaining hosts quota by sku type."""
    quota_enabled: Optional[Union[str, "_models.QuotaEnabled"]] = rest_field(name="quotaEnabled", visibility=["read"])
    """Host quota is active for current subscription. Known values are: \"Enabled\" and \"Disabled\"."""


class RescheduleOperation(MaintenanceManagementOperation, discriminator="Reschedule"):
    """Constraints for rescheduling maintenance.

    :ivar kind: The kind of operation. Required. Represents a rescheduling operation
    :vartype kind: str or ~azure.mgmt.avs.models.RESCHEDULE
    :ivar is_disabled: If rescheduling is disabled.
    :vartype is_disabled: bool
    :ivar disabled_reason: Reason for reschedule disabled.
    :vartype disabled_reason: str
    :ivar constraints: Constraints for rescheduling maintenance.
    :vartype constraints: list[~azure.mgmt.avs.models.RescheduleOperationConstraint]
    """

    kind: Literal[MaintenanceManagementOperationKind.RESCHEDULE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of operation. Required. Represents a rescheduling operation"""
    is_disabled: Optional[bool] = rest_field(name="isDisabled", visibility=["read"])
    """If rescheduling is disabled."""
    disabled_reason: Optional[str] = rest_field(name="disabledReason", visibility=["read"])
    """Reason for reschedule disabled."""
    constraints: Optional[list["_models.RescheduleOperationConstraint"]] = rest_field(visibility=["read"])
    """Constraints for rescheduling maintenance."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MaintenanceManagementOperationKind.RESCHEDULE  # type: ignore


class ResourceSku(_Model):
    """A SKU for a resource.

    :ivar resource_type: The type of resource the SKU applies to. Required. Known values are:
     "privateClouds" and "privateClouds/clusters".
    :vartype resource_type: str or ~azure.mgmt.avs.models.ResourceSkuResourceType
    :ivar name: The name of the SKU. Required.
    :vartype name: str
    :ivar tier: The tier of virtual machines in a scale set.
    :vartype tier: str
    :ivar size: The size of the SKU.
    :vartype size: str
    :ivar family: The family of the SKU.
    :vartype family: str
    :ivar locations: The set of locations that the SKU is available. Required.
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available. Required.
    :vartype location_info: list[~azure.mgmt.avs.models.ResourceSkuLocationInfo]
    :ivar capabilities: Name value pairs to describe the capability.
    :vartype capabilities: list[~azure.mgmt.avs.models.ResourceSkuCapabilities]
    :ivar restrictions: The restrictions of the SKU. Required.
    :vartype restrictions: list[~azure.mgmt.avs.models.ResourceSkuRestrictions]
    """

    resource_type: Union[str, "_models.ResourceSkuResourceType"] = rest_field(
        name="resourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of resource the SKU applies to. Required. Known values are: \"privateClouds\" and
     \"privateClouds/clusters\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU. Required."""
    tier: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tier of virtual machines in a scale set."""
    size: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The size of the SKU."""
    family: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The family of the SKU."""
    locations: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The set of locations that the SKU is available. Required."""
    location_info: list["_models.ResourceSkuLocationInfo"] = rest_field(
        name="locationInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of locations and availability zones in those locations where the SKU is available.
     Required."""
    capabilities: Optional[list["_models.ResourceSkuCapabilities"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Name value pairs to describe the capability."""
    restrictions: list["_models.ResourceSkuRestrictions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The restrictions of the SKU. Required."""

    @overload
    def __init__(
        self,
        *,
        resource_type: Union[str, "_models.ResourceSkuResourceType"],
        name: str,
        locations: list[str],
        location_info: list["_models.ResourceSkuLocationInfo"],
        restrictions: list["_models.ResourceSkuRestrictions"],
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capabilities: Optional[list["_models.ResourceSkuCapabilities"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSkuCapabilities(_Model):
    """Describes The SKU capabilities object.

    :ivar name: The name of the SKU capability. Required.
    :vartype name: str
    :ivar value: The value of the SKU capability. Required.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU capability. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the SKU capability. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSkuLocationInfo(_Model):
    """Describes an available Compute SKU Location Information.

    :ivar location: Location of the SKU. Required.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported. Required.
    :vartype zones: list[str]
    :ivar zone_details: Gets details of capabilities available to a SKU in specific zones.
     Required.
    :vartype zone_details: list[~azure.mgmt.avs.models.ResourceSkuZoneDetails]
    """

    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Location of the SKU. Required."""
    zones: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of availability zones where the SKU is supported. Required."""
    zone_details: list["_models.ResourceSkuZoneDetails"] = rest_field(
        name="zoneDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gets details of capabilities available to a SKU in specific zones. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        zones: list[str],
        zone_details: list["_models.ResourceSkuZoneDetails"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSkuRestrictionInfo(_Model):
    """Describes an available Compute SKU Restriction Information.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    locations: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Locations where the SKU is restricted."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of availability zones where the SKU is restricted."""

    @overload
    def __init__(
        self,
        *,
        locations: Optional[list[str]] = None,
        zones: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSkuRestrictions(_Model):
    """The restrictions of the SKU.

    :ivar type: the type of restrictions. Known values are: "Location" and "Zone".
    :vartype type: str or ~azure.mgmt.avs.models.ResourceSkuRestrictionsType
    :ivar values_property: The value of restrictions. If the restriction type is set to location.
     This would be different locations where the SKU is restricted. Required.
    :vartype values_property: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
     Required.
    :vartype restriction_info: ~azure.mgmt.avs.models.ResourceSkuRestrictionInfo
    :ivar reason_code: the reason for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or ~azure.mgmt.avs.models.ResourceSkuRestrictionsReasonCode
    """

    type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """the type of restrictions. Known values are: \"Location\" and \"Zone\"."""
    values_property: list[str] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The value of restrictions. If the restriction type is set to location. This would be different
     locations where the SKU is restricted. Required."""
    restriction_info: "_models.ResourceSkuRestrictionInfo" = rest_field(
        name="restrictionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The information about the restriction where the SKU cannot be used. Required."""
    reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = rest_field(
        name="reasonCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """the reason for restriction. Known values are: \"QuotaId\" and \"NotAvailableForSubscription\"."""

    @overload
    def __init__(
        self,
        *,
        values_property: list[str],
        restriction_info: "_models.ResourceSkuRestrictionInfo",
        type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None,
        reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceSkuZoneDetails(_Model):
    """Describes The zonal capabilities of a SKU.

    :ivar name: Gets the set of zones that the SKU is available in with the specified capabilities.
     Required.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones. Required.
    :vartype capabilities: list[~azure.mgmt.avs.models.ResourceSkuCapabilities]
    """

    name: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Gets the set of zones that the SKU is available in with the specified capabilities. Required."""
    capabilities: list["_models.ResourceSkuCapabilities"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of capabilities that are available for the SKU in the specified list of zones. Required."""

    @overload
    def __init__(
        self,
        *,
        name: list[str],
        capabilities: list["_models.ResourceSkuCapabilities"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduleOperation(MaintenanceManagementOperation, discriminator="Schedule"):
    """Scheduling window constraint.

    :ivar kind: The kind of operation. Required. Represents a scheduling operation
    :vartype kind: str or ~azure.mgmt.avs.models.SCHEDULE
    :ivar is_disabled: If scheduling is disabled.
    :vartype is_disabled: bool
    :ivar disabled_reason: Reason for schedule disabled.
    :vartype disabled_reason: str
    :ivar constraints: Constraints for scheduling maintenance.
    :vartype constraints: list[~azure.mgmt.avs.models.ScheduleOperationConstraint]
    """

    kind: Literal[MaintenanceManagementOperationKind.SCHEDULE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of operation. Required. Represents a scheduling operation"""
    is_disabled: Optional[bool] = rest_field(name="isDisabled", visibility=["read"])
    """If scheduling is disabled."""
    disabled_reason: Optional[str] = rest_field(name="disabledReason", visibility=["read"])
    """Reason for schedule disabled."""
    constraints: Optional[list["_models.ScheduleOperationConstraint"]] = rest_field(visibility=["read"])
    """Constraints for scheduling maintenance."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MaintenanceManagementOperationKind.SCHEDULE  # type: ignore


class SchedulingWindow(ScheduleOperationConstraint, discriminator="SchedulingWindow"):
    """Time window in which Customer has option to schedule maintenance.

    :ivar kind: The kind of constraint. Required. Time window in which Customer has option to
     schedule maintenance
    :vartype kind: str or ~azure.mgmt.avs.models.SCHEDULING_WINDOW
    :ivar starts_at: Start date time. Required.
    :vartype starts_at: ~datetime.datetime
    :ivar ends_at: End date Time. Required.
    :vartype ends_at: ~datetime.datetime
    """

    kind: Literal[ScheduleOperationConstraintKind.SCHEDULING_WINDOW] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of constraint. Required. Time window in which Customer has option to schedule
     maintenance"""
    starts_at: datetime.datetime = rest_field(name="startsAt", visibility=["read"], format="rfc3339")
    """Start date time. Required."""
    ends_at: datetime.datetime = rest_field(name="endsAt", visibility=["read"], format="rfc3339")
    """End date Time. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ScheduleOperationConstraintKind.SCHEDULING_WINDOW  # type: ignore


class ScriptCmdlet(ProxyResource):
    """A cmdlet available for script execution.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.ScriptCmdletProperties
    """

    properties: Optional["_models.ScriptCmdletProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "description", "timeout", "audience", "parameters"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ScriptCmdletProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ScriptCmdletProperties(_Model):
    """Properties of a pre-canned script.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptCmdletProvisioningState
    :ivar description: Description of the scripts functionality.
    :vartype description: str
    :ivar timeout: Recommended time limit for execution.
    :vartype timeout: str
    :ivar audience: Specifies whether a script cmdlet is intended to be invoked only through
     automation or visible to customers. Known values are: "Automation" and "Any".
    :vartype audience: str or ~azure.mgmt.avs.models.ScriptCmdletAudience
    :ivar parameters: Parameters the script will accept.
    :vartype parameters: list[~azure.mgmt.avs.models.ScriptParameter]
    """

    provisioning_state: Optional[Union[str, "_models.ScriptCmdletProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description of the scripts functionality."""
    timeout: Optional[str] = rest_field(visibility=["read"])
    """Recommended time limit for execution."""
    audience: Optional[Union[str, "_models.ScriptCmdletAudience"]] = rest_field(visibility=["read"])
    """Specifies whether a script cmdlet is intended to be invoked only through automation or visible
     to customers. Known values are: \"Automation\" and \"Any\"."""
    parameters: Optional[list["_models.ScriptParameter"]] = rest_field(visibility=["read"])
    """Parameters the script will accept."""


class ScriptExecution(ProxyResource):
    """An instance of a script executed by a user - custom or AVS.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.ScriptExecutionProperties
    """

    properties: Optional["_models.ScriptExecutionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "script_cmdlet_id",
        "parameters",
        "hidden_parameters",
        "failure_reason",
        "timeout",
        "retention",
        "submitted_at",
        "started_at",
        "finished_at",
        "provisioning_state",
        "output",
        "named_outputs",
        "information",
        "warnings",
        "errors",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ScriptExecutionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ScriptExecutionProperties(_Model):
    """Properties of a user-invoked script.

    :ivar script_cmdlet_id: A reference to the script cmdlet resource if user is running a AVS
     script.
    :vartype script_cmdlet_id: str
    :ivar parameters: Parameters the script will accept.
    :vartype parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :ivar hidden_parameters: Parameters that will be hidden/not visible to ARM, such as passwords
     and
     credentials.
    :vartype hidden_parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :ivar failure_reason: Error message if the script was able to run, but if the script itself had
     errors or powershell threw an exception.
    :vartype failure_reason: str
    :ivar timeout: Time limit for execution. Required.
    :vartype timeout: str
    :ivar retention: Time to live for the resource. If not provided, will be available for 60 days.
    :vartype retention: str
    :ivar submitted_at: Time the script execution was submitted.
    :vartype submitted_at: ~datetime.datetime
    :ivar started_at: Time the script execution was started.
    :vartype started_at: ~datetime.datetime
    :ivar finished_at: Time the script execution was finished.
    :vartype finished_at: ~datetime.datetime
    :ivar provisioning_state: The state of the script execution resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Pending", "Running", "Cancelling", "Cancelled", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptExecutionProvisioningState
    :ivar output: Standard output stream from the powershell execution.
    :vartype output: list[str]
    :ivar named_outputs: User-defined dictionary.
    :vartype named_outputs: dict[str, any]
    :ivar information: Standard information out stream from the powershell execution.
    :vartype information: list[str]
    :ivar warnings: Standard warning out stream from the powershell execution.
    :vartype warnings: list[str]
    :ivar errors: Standard error output stream from the powershell execution.
    :vartype errors: list[str]
    """

    script_cmdlet_id: Optional[str] = rest_field(
        name="scriptCmdletId", visibility=["read", "create", "update", "delete", "query"]
    )
    """A reference to the script cmdlet resource if user is running a AVS script."""
    parameters: Optional[list["_models.ScriptExecutionParameter"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters the script will accept."""
    hidden_parameters: Optional[list["_models.ScriptExecutionParameter"]] = rest_field(
        name="hiddenParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters that will be hidden/not visible to ARM, such as passwords and
     credentials."""
    failure_reason: Optional[str] = rest_field(
        name="failureReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """Error message if the script was able to run, but if the script itself had
     errors or powershell threw an exception."""
    timeout: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Time limit for execution. Required."""
    retention: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Time to live for the resource. If not provided, will be available for 60 days."""
    submitted_at: Optional[datetime.datetime] = rest_field(name="submittedAt", visibility=["read"], format="rfc3339")
    """Time the script execution was submitted."""
    started_at: Optional[datetime.datetime] = rest_field(name="startedAt", visibility=["read"], format="rfc3339")
    """Time the script execution was started."""
    finished_at: Optional[datetime.datetime] = rest_field(name="finishedAt", visibility=["read"], format="rfc3339")
    """Time the script execution was finished."""
    provisioning_state: Optional[Union[str, "_models.ScriptExecutionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the script execution resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Pending\", \"Running\", \"Cancelling\", \"Cancelled\", and \"Deleting\"."""
    output: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Standard output stream from the powershell execution."""
    named_outputs: Optional[dict[str, Any]] = rest_field(
        name="namedOutputs", visibility=["read", "create", "update", "delete", "query"]
    )
    """User-defined dictionary."""
    information: Optional[list[str]] = rest_field(visibility=["read"])
    """Standard information out stream from the powershell execution."""
    warnings: Optional[list[str]] = rest_field(visibility=["read"])
    """Standard warning out stream from the powershell execution."""
    errors: Optional[list[str]] = rest_field(visibility=["read"])
    """Standard error output stream from the powershell execution."""

    @overload
    def __init__(
        self,
        *,
        timeout: str,
        script_cmdlet_id: Optional[str] = None,
        parameters: Optional[list["_models.ScriptExecutionParameter"]] = None,
        hidden_parameters: Optional[list["_models.ScriptExecutionParameter"]] = None,
        failure_reason: Optional[str] = None,
        retention: Optional[str] = None,
        output: Optional[list[str]] = None,
        named_outputs: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScriptPackage(ProxyResource):
    """Script Package resources available for execution.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.ScriptPackageProperties
    """

    properties: Optional["_models.ScriptPackageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "description", "version", "company", "uri"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ScriptPackageProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ScriptPackageProperties(_Model):
    """Properties of a Script Package subresource.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptPackageProvisioningState
    :ivar description: User friendly description of the package.
    :vartype description: str
    :ivar version: Module version.
    :vartype version: str
    :ivar company: Company that created and supports the package.
    :vartype company: str
    :ivar uri: Link to support by the package vendor.
    :vartype uri: str
    """

    provisioning_state: Optional[Union[str, "_models.ScriptPackageProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """User friendly description of the package."""
    version: Optional[str] = rest_field(visibility=["read"])
    """Module version."""
    company: Optional[str] = rest_field(visibility=["read"])
    """Company that created and supports the package."""
    uri: Optional[str] = rest_field(visibility=["read"])
    """Link to support by the package vendor."""


class ScriptParameter(_Model):
    """An parameter that the script will accept.

    :ivar type: The type of parameter the script is expecting. psCredential is a
     PSCredentialObject. Known values are: "String", "SecureString", "Credential", "Int", "Bool",
     and "Float".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptParameterTypes
    :ivar name: The parameter name that the script will expect a parameter value for.
    :vartype name: str
    :ivar description: User friendly description of the parameter.
    :vartype description: str
    :ivar visibility: Should this parameter be visible to arm and passed in the parameters argument
     when executing. Known values are: "Visible" and "Hidden".
    :vartype visibility: str or ~azure.mgmt.avs.models.VisibilityParameterEnum
    :ivar optional: Is this parameter required or optional. Known values are: "Optional" and
     "Required".
    :vartype optional: str or ~azure.mgmt.avs.models.OptionalParamEnum
    """

    type: Optional[Union[str, "_models.ScriptParameterTypes"]] = rest_field(visibility=["read"])
    """The type of parameter the script is expecting. psCredential is a
     PSCredentialObject. Known values are: \"String\", \"SecureString\", \"Credential\", \"Int\",
     \"Bool\", and \"Float\"."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The parameter name that the script will expect a parameter value for."""
    description: Optional[str] = rest_field(visibility=["read"])
    """User friendly description of the parameter."""
    visibility: Optional[Union[str, "_models.VisibilityParameterEnum"]] = rest_field(visibility=["read"])
    """Should this parameter be visible to arm and passed in the parameters argument
     when executing. Known values are: \"Visible\" and \"Hidden\"."""
    optional: Optional[Union[str, "_models.OptionalParamEnum"]] = rest_field(visibility=["read"])
    """Is this parameter required or optional. Known values are: \"Optional\" and \"Required\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScriptSecureStringExecutionParameter(ScriptExecutionParameter, discriminator="SecureValue"):
    """a plain text value execution parameter.

    :ivar name: The parameter name. Required.
    :vartype name: str
    :ivar secure_value: A secure value for the passed parameter, not to be stored in logs.
    :vartype secure_value: str
    :ivar type: The type of execution parameter. Required.
    :vartype type: str or ~azure.mgmt.avs.models.SECURE_VALUE
    """

    secure_value: Optional[str] = rest_field(
        name="secureValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """A secure value for the passed parameter, not to be stored in logs."""
    type: Literal[ScriptExecutionParameterType.SECURE_VALUE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of execution parameter. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        secure_value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ScriptExecutionParameterType.SECURE_VALUE  # type: ignore


class ScriptStringExecutionParameter(ScriptExecutionParameter, discriminator="Value"):
    """a plain text value execution parameter.

    :ivar name: The parameter name. Required.
    :vartype name: str
    :ivar value: The value for the passed parameter.
    :vartype value: str
    :ivar type: The type of execution parameter. Required.
    :vartype type: str or ~azure.mgmt.avs.models.VALUE
    """

    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value for the passed parameter."""
    type: Literal[ScriptExecutionParameterType.VALUE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of execution parameter. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ScriptExecutionParameterType.VALUE  # type: ignore


class Sku(_Model):
    """The resource model definition representing SKU.

    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.avs.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU. Ex - P3. It is typically a letter+number code. Required."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """This field is required to be implemented by the Resource Provider if the service has more than
     one tier, but is not required on a PUT. Known values are: \"Free\", \"Basic\", \"Standard\",
     and \"Premium\"."""
    size: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU size. When the name field is the combination of tier and some other value, this would
     be the standalone code."""
    family: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If the service has different generations of hardware, for the same SKU, then that can be
     captured here."""
    capacity: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If the SKU supports scale out/in then the capacity integer should be included. If scale out/in
     is not possible for the resource this may be omitted."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SpecializedHostProperties(HostProperties, discriminator="Specialized"):
    """The properties of a specialized host.

    :ivar provisioning_state: The state of the host provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.HostProvisioningState
    :ivar display_name: Display name of the host in VMware vCenter.
    :vartype display_name: str
    :ivar mo_ref_id: vCenter managed object reference ID of the host.
    :vartype mo_ref_id: str
    :ivar fqdn: Fully qualified domain name of the host.
    :vartype fqdn: str
    :ivar maintenance: If provided, the host is in maintenance. The value is the reason for
     maintenance. Known values are: "Replacement" and "Upgrade".
    :vartype maintenance: str or ~azure.mgmt.avs.models.HostMaintenance
    :ivar fault_domain:
    :vartype fault_domain: str
    :ivar kind: The kind of host is specialized. Required.
    :vartype kind: str or ~azure.mgmt.avs.models.SPECIALIZED
    """

    kind: Literal[HostKind.SPECIALIZED] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of host is specialized. Required."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        maintenance: Optional[Union[str, "_models.HostMaintenance"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = HostKind.SPECIALIZED  # type: ignore


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.avs.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.avs.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Trial(_Model):
    """Subscription trial availability.

    :ivar status: Trial status. Known values are: "TrialAvailable", "TrialUsed", and
     "TrialDisabled".
    :vartype status: str or ~azure.mgmt.avs.models.TrialStatus
    :ivar available_hosts: Number of trial hosts available.
    :vartype available_hosts: int
    """

    status: Optional[Union[str, "_models.TrialStatus"]] = rest_field(visibility=["read"])
    """Trial status. Known values are: \"TrialAvailable\", \"TrialUsed\", and \"TrialDisabled\"."""
    available_hosts: Optional[int] = rest_field(name="availableHosts", visibility=["read"])
    """Number of trial hosts available."""


class VcfLicense(_Model):
    """A VMware Cloud Foundation license.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Vcf5License

    :ivar kind: License kind. Required. "vcf5"
    :vartype kind: str or ~azure.mgmt.avs.models.VcfLicenseKind
    :ivar provisioning_state: The state of the license provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.LicenseProvisioningState
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """License kind. Required. \"vcf5\""""
    provisioning_state: Optional[Union[str, "_models.LicenseProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The state of the license provisioning. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Vcf5License(VcfLicense, discriminator="vcf5"):
    """A VMware Cloud Foundation (VCF) 5.0 license.

    :ivar provisioning_state: The state of the license provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.LicenseProvisioningState
    :ivar kind: License kind. Required. A VMware Cloud Foundation (VCF) 5.0 license
    :vartype kind: str or ~azure.mgmt.avs.models.VCF5
    :ivar license_key: License key.
    :vartype license_key: str
    :ivar cores: Number of cores included in the license. Required.
    :vartype cores: int
    :ivar end_date: UTC datetime when the license expires. Required.
    :vartype end_date: ~datetime.datetime
    :ivar broadcom_site_id: The Broadcom site ID associated with the license.
    :vartype broadcom_site_id: str
    :ivar broadcom_contract_number: The Broadcom contract number associated with the license.
    :vartype broadcom_contract_number: str
    :ivar labels: Additional labels passed through for license reporting.
    :vartype labels: list[~azure.mgmt.avs.models.Label]
    """

    kind: Literal[VcfLicenseKind.VCF5] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """License kind. Required. A VMware Cloud Foundation (VCF) 5.0 license"""
    license_key: Optional[str] = rest_field(
        name="licenseKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """License key."""
    cores: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cores included in the license. Required."""
    end_date: datetime.datetime = rest_field(
        name="endDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """UTC datetime when the license expires. Required."""
    broadcom_site_id: Optional[str] = rest_field(
        name="broadcomSiteId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Broadcom site ID associated with the license."""
    broadcom_contract_number: Optional[str] = rest_field(
        name="broadcomContractNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Broadcom contract number associated with the license."""
    labels: Optional[list["_models.Label"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional labels passed through for license reporting."""

    @overload
    def __init__(
        self,
        *,
        cores: int,
        end_date: datetime.datetime,
        license_key: Optional[str] = None,
        broadcom_site_id: Optional[str] = None,
        broadcom_contract_number: Optional[str] = None,
        labels: Optional[list["_models.Label"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VcfLicenseKind.VCF5  # type: ignore


class VirtualMachine(ProxyResource):
    """Virtual Machine.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.VirtualMachineProperties
    """

    properties: Optional["_models.VirtualMachineProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "display_name", "mo_ref_id", "folder_path", "restrict_movement"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualMachineProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VirtualMachineProperties(_Model):
    """Virtual Machine Properties.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.VirtualMachineProvisioningState
    :ivar display_name: Display name of the VM.
    :vartype display_name: str
    :ivar mo_ref_id: vCenter managed object reference ID of the virtual machine.
    :vartype mo_ref_id: str
    :ivar folder_path: Path to virtual machine's folder starting from datacenter virtual machine
     folder.
    :vartype folder_path: str
    :ivar restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
     (disabled). Known values are: "Enabled" and "Disabled".
    :vartype restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
    """

    provisioning_state: Optional[Union[str, "_models.VirtualMachineProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """Display name of the VM."""
    mo_ref_id: Optional[str] = rest_field(name="moRefId", visibility=["read"])
    """vCenter managed object reference ID of the virtual machine."""
    folder_path: Optional[str] = rest_field(name="folderPath", visibility=["read"])
    """Path to virtual machine's folder starting from datacenter virtual machine folder."""
    restrict_movement: Optional[Union[str, "_models.VirtualMachineRestrictMovementState"]] = rest_field(
        name="restrictMovement", visibility=["read"]
    )
    """Whether VM DRS-driven movement is restricted (enabled) or not (disabled). Known values are:
     \"Enabled\" and \"Disabled\"."""


class VirtualMachineRestrictMovement(_Model):
    """Set VM DRS-driven movement to restricted (enabled) or not (disabled).

    :ivar restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
     (disabled). Known values are: "Enabled" and "Disabled".
    :vartype restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
    """

    restrict_movement: Optional[Union[str, "_models.VirtualMachineRestrictMovementState"]] = rest_field(
        name="restrictMovement", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether VM DRS-driven movement is restricted (enabled) or not (disabled). Known values are:
     \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        restrict_movement: Optional[Union[str, "_models.VirtualMachineRestrictMovementState"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VmHostPlacementPolicyProperties(PlacementPolicyProperties, discriminator="VmHost"):
    """VM-Host placement policy properties.

    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar display_name: Display name of the placement policy.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    :ivar vm_members: Virtual machine members list. Required.
    :vartype vm_members: list[str]
    :ivar host_members: Host members list. Required.
    :vartype host_members: list[str]
    :ivar affinity_type: placement policy affinity type. Required. Known values are: "Affinity" and
     "AntiAffinity".
    :vartype affinity_type: str or ~azure.mgmt.avs.models.AffinityType
    :ivar affinity_strength: vm-host placement policy affinity strength (should/must). Known values
     are: "Should" and "Must".
    :vartype affinity_strength: str or ~azure.mgmt.avs.models.AffinityStrength
    :ivar azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type. Known
     values are: "SqlHost" and "None".
    :vartype azure_hybrid_benefit_type: str or ~azure.mgmt.avs.models.AzureHybridBenefitType
    :ivar type: placement policy type. Required.
    :vartype type: str or ~azure.mgmt.avs.models.VM_HOST
    """

    vm_members: list[str] = rest_field(name="vmMembers", visibility=["read", "create", "update", "delete", "query"])
    """Virtual machine members list. Required."""
    host_members: list[str] = rest_field(name="hostMembers", visibility=["read", "create", "update", "delete", "query"])
    """Host members list. Required."""
    affinity_type: Union[str, "_models.AffinityType"] = rest_field(
        name="affinityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """placement policy affinity type. Required. Known values are: \"Affinity\" and \"AntiAffinity\"."""
    affinity_strength: Optional[Union[str, "_models.AffinityStrength"]] = rest_field(
        name="affinityStrength", visibility=["read", "create", "update", "delete", "query"]
    )
    """vm-host placement policy affinity strength (should/must). Known values are: \"Should\" and
     \"Must\"."""
    azure_hybrid_benefit_type: Optional[Union[str, "_models.AzureHybridBenefitType"]] = rest_field(
        name="azureHybridBenefitType", visibility=["read", "create", "update", "delete", "query"]
    )
    """placement policy azure hybrid benefit opt-in type. Known values are: \"SqlHost\" and \"None\"."""
    type: Literal[PlacementPolicyType.VM_HOST] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """placement policy type. Required."""

    @overload
    def __init__(
        self,
        *,
        vm_members: list[str],
        host_members: list[str],
        affinity_type: Union[str, "_models.AffinityType"],
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        affinity_strength: Optional[Union[str, "_models.AffinityStrength"]] = None,
        azure_hybrid_benefit_type: Optional[Union[str, "_models.AzureHybridBenefitType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = PlacementPolicyType.VM_HOST  # type: ignore


class VmPlacementPolicyProperties(PlacementPolicyProperties, discriminator="VmVm"):
    """VM-VM placement policy properties.

    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar display_name: Display name of the placement policy.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    :ivar vm_members: Virtual machine members list. Required.
    :vartype vm_members: list[str]
    :ivar affinity_type: placement policy affinity type. Required. Known values are: "Affinity" and
     "AntiAffinity".
    :vartype affinity_type: str or ~azure.mgmt.avs.models.AffinityType
    :ivar type: placement policy type. Required.
    :vartype type: str or ~azure.mgmt.avs.models.VM_VM
    """

    vm_members: list[str] = rest_field(name="vmMembers", visibility=["read", "create", "update", "delete", "query"])
    """Virtual machine members list. Required."""
    affinity_type: Union[str, "_models.AffinityType"] = rest_field(
        name="affinityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """placement policy affinity type. Required. Known values are: \"Affinity\" and \"AntiAffinity\"."""
    type: Literal[PlacementPolicyType.VM_VM] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """placement policy type. Required."""

    @overload
    def __init__(
        self,
        *,
        vm_members: list[str],
        affinity_type: Union[str, "_models.AffinityType"],
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = PlacementPolicyType.VM_VM  # type: ignore


class VmwareFirewallLicenseProperties(LicenseProperties, discriminator="VmwareFirewall"):
    """The properties of a VMware Firewall license.

    :ivar provisioning_state: The state of the license provisioning. Known values are: "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.LicenseProvisioningState
    :ivar kind: License kind. Required.
    :vartype kind: str or ~azure.mgmt.avs.models.VMWARE_FIREWALL
    :ivar license_key: License key.
    :vartype license_key: str
    :ivar cores: Number of cores included in the license, measured per hour. Required.
    :vartype cores: int
    :ivar end_date: UTC datetime when the license expires. Required.
    :vartype end_date: ~datetime.datetime
    :ivar broadcom_site_id: The Broadcom site ID associated with the license.
    :vartype broadcom_site_id: str
    :ivar broadcom_contract_number: The Broadcom contract number associated with the license.
    :vartype broadcom_contract_number: str
    :ivar labels: Additional labels passed through for license reporting.
    :vartype labels: list[~azure.mgmt.avs.models.Label]
    """

    kind: Literal[LicenseKind.VMWARE_FIREWALL] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """License kind. Required."""
    license_key: Optional[str] = rest_field(
        name="licenseKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """License key."""
    cores: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cores included in the license, measured per hour. Required."""
    end_date: datetime.datetime = rest_field(
        name="endDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """UTC datetime when the license expires. Required."""
    broadcom_site_id: Optional[str] = rest_field(
        name="broadcomSiteId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Broadcom site ID associated with the license."""
    broadcom_contract_number: Optional[str] = rest_field(
        name="broadcomContractNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Broadcom contract number associated with the license."""
    labels: Optional[list["_models.Label"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional labels passed through for license reporting."""

    @overload
    def __init__(
        self,
        *,
        cores: int,
        end_date: datetime.datetime,
        license_key: Optional[str] = None,
        broadcom_site_id: Optional[str] = None,
        broadcom_contract_number: Optional[str] = None,
        labels: Optional[list["_models.Label"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = LicenseKind.VMWARE_FIREWALL  # type: ignore


class WorkloadNetwork(ProxyResource):
    """Workload Network.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkProperties
    """

    properties: Optional["_models.WorkloadNetworkProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkDhcp(ProxyResource):
    """NSX DHCP.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkDhcpEntity
    """

    properties: Optional["_models.WorkloadNetworkDhcpEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkDhcpEntity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkDhcpEntity(_Model):
    """Base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to
    inherit from.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WorkloadNetworkDhcpRelay, WorkloadNetworkDhcpServer

    :ivar dhcp_type: Type of DHCP: SERVER or RELAY. Required. Known values are: "SERVER" and
     "RELAY".
    :vartype dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    __mapping__: dict[str, _Model] = {}
    dhcp_type: str = rest_discriminator(name="dhcpType", visibility=["read", "create", "update", "delete", "query"])
    """Type of DHCP: SERVER or RELAY. Required. Known values are: \"SERVER\" and \"RELAY\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the DHCP entity."""
    segments: Optional[list[str]] = rest_field(visibility=["read"])
    """NSX Segments consuming DHCP."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkDhcpProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """NSX revision number."""

    @overload
    def __init__(
        self,
        *,
        dhcp_type: str,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkDhcpRelay(WorkloadNetworkDhcpEntity, discriminator="RELAY"):
    """NSX DHCP Relay.

    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    :ivar server_addresses: DHCP Relay Addresses. Max 3.
    :vartype server_addresses: list[str]
    :ivar dhcp_type: Type of DHCP: SERVER or RELAY. Required.
    :vartype dhcp_type: str or ~azure.mgmt.avs.models.RELAY
    """

    server_addresses: Optional[list[str]] = rest_field(
        name="serverAddresses", visibility=["read", "create", "update", "delete", "query"]
    )
    """DHCP Relay Addresses. Max 3."""
    dhcp_type: Literal[DhcpTypeEnum.RELAY] = rest_discriminator(name="dhcpType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of DHCP: SERVER or RELAY. Required."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        server_addresses: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.dhcp_type = DhcpTypeEnum.RELAY  # type: ignore


class WorkloadNetworkDhcpServer(WorkloadNetworkDhcpEntity, discriminator="SERVER"):
    """NSX DHCP Server.

    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    :ivar server_address: DHCP Server Address.
    :vartype server_address: str
    :ivar lease_time: DHCP Server Lease Time.
    :vartype lease_time: int
    :ivar dhcp_type: Type of DHCP: SERVER or RELAY. Required.
    :vartype dhcp_type: str or ~azure.mgmt.avs.models.SERVER
    """

    server_address: Optional[str] = rest_field(
        name="serverAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """DHCP Server Address."""
    lease_time: Optional[int] = rest_field(name="leaseTime", visibility=["read", "create", "update", "delete", "query"])
    """DHCP Server Lease Time."""
    dhcp_type: Literal[DhcpTypeEnum.SERVER] = rest_discriminator(name="dhcpType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of DHCP: SERVER or RELAY. Required."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        server_address: Optional[str] = None,
        lease_time: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.dhcp_type = DhcpTypeEnum.SERVER  # type: ignore


class WorkloadNetworkDnsService(ProxyResource):
    """NSX DNS Service.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkDnsServiceProperties
    """

    properties: Optional["_models.WorkloadNetworkDnsServiceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "display_name",
        "dns_service_ip",
        "default_dns_zone",
        "fqdn_zones",
        "log_level",
        "status",
        "provisioning_state",
        "revision",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkDnsServiceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkDnsServiceProperties(_Model):
    """NSX DNS Service Properties.

    :ivar display_name: Display name of the DNS Service.
    :vartype display_name: str
    :ivar dns_service_ip: DNS service IP of the DNS Service.
    :vartype dns_service_ip: str
    :ivar default_dns_zone: Default DNS zone of the DNS Service.
    :vartype default_dns_zone: str
    :ivar fqdn_zones: FQDN zones of the DNS Service.
    :vartype fqdn_zones: list[str]
    :ivar log_level: DNS Service log level. Known values are: "DEBUG", "INFO", "WARNING", "ERROR",
     and "FATAL".
    :vartype log_level: str or ~azure.mgmt.avs.models.DnsServiceLogLevelEnum
    :ivar status: DNS Service status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.DnsServiceStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsServiceProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the DNS Service."""
    dns_service_ip: Optional[str] = rest_field(
        name="dnsServiceIp", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS service IP of the DNS Service."""
    default_dns_zone: Optional[str] = rest_field(
        name="defaultDnsZone", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default DNS zone of the DNS Service."""
    fqdn_zones: Optional[list[str]] = rest_field(
        name="fqdnZones", visibility=["read", "create", "update", "delete", "query"]
    )
    """FQDN zones of the DNS Service."""
    log_level: Optional[Union[str, "_models.DnsServiceLogLevelEnum"]] = rest_field(
        name="logLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS Service log level. Known values are: \"DEBUG\", \"INFO\", \"WARNING\", \"ERROR\", and
     \"FATAL\"."""
    status: Optional[Union[str, "_models.DnsServiceStatusEnum"]] = rest_field(visibility=["read"])
    """DNS Service status. Known values are: \"SUCCESS\" and \"FAILURE\"."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkDnsServiceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """NSX revision number."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        default_dns_zone: Optional[str] = None,
        fqdn_zones: Optional[list[str]] = None,
        log_level: Optional[Union[str, "_models.DnsServiceLogLevelEnum"]] = None,
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkDnsZone(ProxyResource):
    """NSX DNS Zone.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkDnsZoneProperties
    """

    properties: Optional["_models.WorkloadNetworkDnsZoneProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "display_name",
        "domain",
        "dns_server_ips",
        "source_ip",
        "dns_services",
        "provisioning_state",
        "revision",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkDnsZoneProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkDnsZoneProperties(_Model):
    """NSX DNS Zone Properties.

    :ivar display_name: Display name of the DNS Zone.
    :vartype display_name: str
    :ivar domain: Domain names of the DNS Zone.
    :vartype domain: list[str]
    :ivar dns_server_ips: DNS Server IP array of the DNS Zone.
    :vartype dns_server_ips: list[str]
    :ivar source_ip: Source IP of the DNS Zone.
    :vartype source_ip: str
    :ivar dns_services: Number of DNS Services using the DNS zone.
    :vartype dns_services: int
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsZoneProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the DNS Zone."""
    domain: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Domain names of the DNS Zone."""
    dns_server_ips: Optional[list[str]] = rest_field(
        name="dnsServerIps", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS Server IP array of the DNS Zone."""
    source_ip: Optional[str] = rest_field(name="sourceIp", visibility=["read", "create", "update", "delete", "query"])
    """Source IP of the DNS Zone."""
    dns_services: Optional[int] = rest_field(
        name="dnsServices", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of DNS Services using the DNS zone."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkDnsZoneProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """NSX revision number."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        domain: Optional[list[str]] = None,
        dns_server_ips: Optional[list[str]] = None,
        source_ip: Optional[str] = None,
        dns_services: Optional[int] = None,
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkGateway(ProxyResource):
    """NSX Gateway.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkGatewayProperties
    """

    properties: Optional["_models.WorkloadNetworkGatewayProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "display_name", "path"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkGatewayProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkGatewayProperties(_Model):
    """Properties of a NSX Gateway.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkProvisioningState
    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar path: NSX Gateway Path.
    :vartype path: str
    """

    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Building\", \"Deleting\", and \"Updating\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the DHCP entity."""
    path: Optional[str] = rest_field(visibility=["read"])
    """NSX Gateway Path."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkPortMirroring(ProxyResource):
    """NSX Port Mirroring.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkPortMirroringProperties
    """

    properties: Optional["_models.WorkloadNetworkPortMirroringProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "display_name",
        "direction",
        "source",
        "destination",
        "status",
        "provisioning_state",
        "revision",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkPortMirroringProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkPortMirroringProperties(_Model):
    """NSX Port Mirroring Properties.

    :ivar display_name: Display name of the port mirroring profile.
    :vartype display_name: str
    :ivar direction: Direction of port mirroring profile. Known values are: "INGRESS", "EGRESS",
     and "BIDIRECTIONAL".
    :vartype direction: str or ~azure.mgmt.avs.models.PortMirroringDirectionEnum
    :ivar source: Source VM Group.
    :vartype source: str
    :ivar destination: Destination VM Group.
    :vartype destination: str
    :ivar status: Port Mirroring Status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.PortMirroringStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPortMirroringProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the port mirroring profile."""
    direction: Optional[Union[str, "_models.PortMirroringDirectionEnum"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Direction of port mirroring profile. Known values are: \"INGRESS\", \"EGRESS\", and
     \"BIDIRECTIONAL\"."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source VM Group."""
    destination: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Destination VM Group."""
    status: Optional[Union[str, "_models.PortMirroringStatusEnum"]] = rest_field(visibility=["read"])
    """Port Mirroring Status. Known values are: \"SUCCESS\" and \"FAILURE\"."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkPortMirroringProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """NSX revision number."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        direction: Optional[Union[str, "_models.PortMirroringDirectionEnum"]] = None,
        source: Optional[str] = None,
        destination: Optional[str] = None,
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkProperties(_Model):
    """The properties of a workload network.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkProvisioningState
    """

    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Building\", \"Deleting\", and \"Updating\"."""


class WorkloadNetworkPublicIP(ProxyResource):
    """NSX Public IP Block.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkPublicIPProperties
    """

    properties: Optional["_models.WorkloadNetworkPublicIPProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["display_name", "number_of_public_i_ps", "public_ip_block", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkPublicIPProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkPublicIPProperties(_Model):
    """NSX Public IP Block Properties.

    :ivar display_name: Display name of the Public IP Block.
    :vartype display_name: str
    :ivar number_of_public_i_ps: Number of Public IPs requested.
    :vartype number_of_public_i_ps: int
    :ivar public_ip_block: CIDR Block of the Public IP Block.
    :vartype public_ip_block: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPublicIPProvisioningState
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the Public IP Block."""
    number_of_public_i_ps: Optional[int] = rest_field(
        name="numberOfPublicIPs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of Public IPs requested."""
    public_ip_block: Optional[str] = rest_field(name="publicIPBlock", visibility=["read"])
    """CIDR Block of the Public IP Block."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkPublicIPProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        number_of_public_i_ps: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkSegment(ProxyResource):
    """NSX Segment.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkSegmentProperties
    """

    properties: Optional["_models.WorkloadNetworkSegmentProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "display_name",
        "connected_gateway",
        "subnet",
        "port_vif",
        "status",
        "provisioning_state",
        "revision",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkSegmentProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkSegmentPortVif(_Model):
    """Ports and any VIF attached to segment.

    :ivar port_name: Name of port or VIF attached to segment.
    :vartype port_name: str
    """

    port_name: Optional[str] = rest_field(name="portName", visibility=["read", "create", "update", "delete", "query"])
    """Name of port or VIF attached to segment."""

    @overload
    def __init__(
        self,
        *,
        port_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkSegmentProperties(_Model):
    """NSX Segment Properties.

    :ivar display_name: Display name of the segment.
    :vartype display_name: str
    :ivar connected_gateway: Gateway which to connect segment to.
    :vartype connected_gateway: str
    :ivar subnet: Subnet which to connect segment to.
    :vartype subnet: ~azure.mgmt.avs.models.WorkloadNetworkSegmentSubnet
    :ivar port_vif: Port Vif which segment is associated with.
    :vartype port_vif: list[~azure.mgmt.avs.models.WorkloadNetworkSegmentPortVif]
    :ivar status: Segment status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.SegmentStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkSegmentProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the segment."""
    connected_gateway: Optional[str] = rest_field(
        name="connectedGateway", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gateway which to connect segment to."""
    subnet: Optional["_models.WorkloadNetworkSegmentSubnet"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subnet which to connect segment to."""
    port_vif: Optional[list["_models.WorkloadNetworkSegmentPortVif"]] = rest_field(name="portVif", visibility=["read"])
    """Port Vif which segment is associated with."""
    status: Optional[Union[str, "_models.SegmentStatusEnum"]] = rest_field(visibility=["read"])
    """Segment status. Known values are: \"SUCCESS\" and \"FAILURE\"."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkSegmentProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """NSX revision number."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        connected_gateway: Optional[str] = None,
        subnet: Optional["_models.WorkloadNetworkSegmentSubnet"] = None,
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkSegmentSubnet(_Model):
    """Subnet configuration for segment.

    :ivar dhcp_ranges: DHCP Range assigned for subnet.
    :vartype dhcp_ranges: list[str]
    :ivar gateway_address: Gateway address.
    :vartype gateway_address: str
    """

    dhcp_ranges: Optional[list[str]] = rest_field(
        name="dhcpRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """DHCP Range assigned for subnet."""
    gateway_address: Optional[str] = rest_field(
        name="gatewayAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Gateway address."""

    @overload
    def __init__(
        self,
        *,
        dhcp_ranges: Optional[list[str]] = None,
        gateway_address: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkVirtualMachine(ProxyResource):
    """NSX Virtual Machine.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkVirtualMachineProperties
    """

    properties: Optional["_models.WorkloadNetworkVirtualMachineProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["provisioning_state", "display_name", "vm_type"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkVirtualMachineProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkVirtualMachineProperties(_Model):
    """NSX Virtual Machine Properties.

    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkProvisioningState
    :ivar display_name: Display name of the VM.
    :vartype display_name: str
    :ivar vm_type: Virtual machine type. Known values are: "REGULAR", "EDGE", and "SERVICE".
    :vartype vm_type: str or ~azure.mgmt.avs.models.VMTypeEnum
    """

    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Building\", \"Deleting\", and \"Updating\"."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the VM."""
    vm_type: Optional[Union[str, "_models.VMTypeEnum"]] = rest_field(name="vmType", visibility=["read"])
    """Virtual machine type. Known values are: \"REGULAR\", \"EDGE\", and \"SERVICE\"."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadNetworkVMGroup(ProxyResource):
    """NSX VM Group.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkVMGroupProperties
    """

    properties: Optional["_models.WorkloadNetworkVMGroupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["display_name", "members", "status", "provisioning_state", "revision"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadNetworkVMGroupProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkloadNetworkVMGroupProperties(_Model):
    """NSX VM Group Properties.

    :ivar display_name: Display name of the VM group.
    :vartype display_name: str
    :ivar members: Virtual machine members of this group.
    :vartype members: list[str]
    :ivar status: VM Group status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.VMGroupStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkVMGroupProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name of the VM group."""
    members: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Virtual machine members of this group."""
    status: Optional[Union[str, "_models.VMGroupStatusEnum"]] = rest_field(visibility=["read"])
    """VM Group status. Known values are: \"SUCCESS\" and \"FAILURE\"."""
    provisioning_state: Optional[Union[str, "_models.WorkloadNetworkVMGroupProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Building\", \"Deleting\", and \"Updating\"."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """NSX revision number."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        members: Optional[list[str]] = None,
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
