# Developer Documentation

This folder contains documentation for developers of SDKs: internal teams at Microsoft, or advanced contributors.

Overview of the documents:
- [Developer Set-Up](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/dev_setup.md) : How to create a development environment for this repo
- [Release](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/release.md) : How to release a package when ready
- [Packaging](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/packaging.md) : How to organize packaging information for packages under `azure`
- [Testing](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/tests.md): How to write unit and functional tests for a library
- [Docstrings](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/docstring.md): How to document an SDK (API View) and our documentation at [MS Docs][ms_docs] and the [azure.github.io][azure_github_io] site.
- [Type Hints and Type Checking](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/static_type_checking.md) / [Cheatsheet](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/static_type_checking_cheat_sheet.md): How to add type hints to your library code and run type checking.

The [mgmt](https://github.com/Azure/azure-sdk-for-python/blob/main/doc/dev/mgmt) folder contains information specific to management packages (i.e. packages prefixed by `azure-mgmt`)

<!-- links -->
[ms_docs]: https://docs.microsoft.com/python/api/overview/azure/appconfiguration-readme?view=azure-python
[azure_github_io]: https://azure.github.io/azure-sdk-for-python/
