---
title: Hapticmedia Blog
date: 2019-10-01
description: 'Showcase: "A simple, but powerful, multilingual blog."'
siteURL: https://hapticmedia.fr/blog/en/
byline: "[Cyril Bonnet](https://github.com/monsieurnebo), Web Developer"
---

Our goal was to create a simple, effective and multilingual blog on [3D technology](https://hapticmedia.fr/blog/en/3d-technology/) that could be managed by a non-technical profile.

## Why Hugo?

Hugo addresses all these needs, coupled with [Forestry.io](https://forestry.io/) for its administration via a "turnkey" interface. We have attached particular importance to SEO, and therefore to the creation of an advanced taxonomy system. Thus, each author and tag has a dedicated page, listing the related posts.

## What we liked

- The **multilingual** content support, especially simple to setup.
- The **multiple environments** support (develop, staging, test, production, ...).
- Although a hard start with the Go language, the power of the **Hugo's templating**.
- The **partial layouts**, including the `internals` (e.g. social meta tags).
- The **build time**, unbeatable ⚡️⚡️⚡️.

## Tools & workflow

- We used the same design as **[our website](https://hapticmedia.fr/en/)**, recreated as a Hugo HTML template.
- **[Hugo](https://gohugo.io)** for the static website generator.
- **[CircleCI](https://circleci.com)** for continuous integration & deployment.
- **[AWS](https://aws.amazon.com/)** for web hosting.
- **[Forestry.io](https://forestry.io)** for the content management.

**All of these tools allow our editor to manage the blog's content without having to worry about its technical aspect, which is managed by the developers.**
