"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StdPointAttachRectifier = void 0;
const Ot = require("@ot-builder/ot");
const Rectify = require("@ot-builder/rectify");
class StdPointAttachRectifier {
    constructor(manner = Rectify
        .PointAttachmentRectifyManner.TrustAttachment, error = 1 / 16) {
        this.manner = manner;
        this.error = error;
    }
    acceptOffset(actual, desired) {
        const xSame = Ot.Var.Ops.equal(actual.x || 0, desired.x || 0, this.error);
        const ySame = Ot.Var.Ops.equal(actual.y || 0, desired.y || 0, this.error);
        return { x: xSame, y: ySame };
    }
}
exports.StdPointAttachRectifier = StdPointAttachRectifier;
//# sourceMappingURL=point-rectifier.js.map