#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Spooky's Jump Scare Mansion
# send your bug reports to contact@dotslashplay.it
###

script_version=20240521.2

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='spookys-jump-scare-mansion'
GAME_NAME='Spookyʼs Jump Scare Mansion'

ARCHIVE_BASE_0_NAME='SPOOKY.1.zip'
ARCHIVE_BASE_0_MD5='250f389a217169e89fd7ee4794a9831d'
ARCHIVE_BASE_0_SIZE='330000'
ARCHIVE_BASE_0_VERSION='3.0.1-indiedb'
ARCHIVE_BASE_0_URL='https://www.indiedb.com/games/spookys-house-of-jump-scares/downloads/spookys-house-of-jump-scares-30'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
SPOOKY.exe
SurfaceFix.dll
*.ini'
CONTENT_GAME_DATA_FILES='
DATA'
CONTENT_DOC_DATA_FILES='
ReadMe.txt'

USER_PERSISTENT_FILES='
*.ini'

## Install required winetricks verb for game audio to play.
WINE_WINETRICKS_VERBS='directmusic'

APP_MAIN_EXE='SPOOKY.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
application/x-id3'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
