/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.List;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0, false);
    private final NativeQuery nativeQuery;
    private final boolean useEStringSyntax;

    V2Query(String query, boolean withParameters, ProtocolConnection pconn) {
        this.useEStringSyntax = pconn.getServerVersionNum() >= 80100;
        boolean stdStrings = pconn.getStandardConformingStrings();
        List<NativeQuery> queries = Parser.parseJdbcSql(query, stdStrings, withParameters, false);
        assert (queries.size() <= 1) : "Exactly one query expected in V2. " + queries.size() + " queries given.";
        this.nativeQuery = queries.isEmpty() ? new NativeQuery("") : queries.get(0);
    }

    public ParameterList createParameterList() {
        if (this.nativeQuery.bindPositions.length == 0) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.nativeQuery.bindPositions.length, this.useEStringSyntax);
    }

    public String toString(ParameterList parameters) {
        return this.nativeQuery.toString(parameters);
    }

    public void close() {
    }

    NativeQuery getNativeQuery() {
        return this.nativeQuery;
    }

    public boolean isStatementDescribed() {
        return false;
    }

    public boolean isEmpty() {
        return this.nativeQuery.nativeSql.isEmpty();
    }
}

