/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.ha;

import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ha.ReplicationConnection;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.ha.MultiHostConnectionProxy;
import com.mysql.cj.jdbc.ha.MultiHostMySQLConnection;
import com.mysql.cj.jdbc.ha.ReplicationConnectionProxy;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ReplicationMySQLConnection
extends MultiHostMySQLConnection
implements ReplicationConnection {
    public ReplicationMySQLConnection(MultiHostConnectionProxy proxy) {
        super(proxy);
    }

    @Override
    public ReplicationConnectionProxy getThisAsProxy() {
        return (ReplicationConnectionProxy)super.getThisAsProxy();
    }

    @Override
    public synchronized JdbcConnection getCurrentConnection() {
        return this.getThisAsProxy().getCurrentConnection();
    }

    @Override
    public long getConnectionGroupId() {
        return this.getThisAsProxy().getConnectionGroupId();
    }

    @Override
    public synchronized JdbcConnection getMasterConnection() {
        return this.getThisAsProxy().getMasterConnection();
    }

    @Override
    public void promoteSlaveToMaster(String host) throws SQLException {
        try {
            this.getThisAsProxy().promoteSlaveToMaster(host);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void removeMasterHost(String host) throws SQLException {
        try {
            this.getThisAsProxy().removeMasterHost(host);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void removeMasterHost(String host, boolean waitUntilNotInUse) throws SQLException {
        try {
            this.getThisAsProxy().removeMasterHost(host, waitUntilNotInUse);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isHostMaster(String host) {
        return this.getThisAsProxy().isHostMaster(host);
    }

    @Override
    public synchronized JdbcConnection getSlavesConnection() {
        return this.getThisAsProxy().getSlavesConnection();
    }

    @Override
    public void addSlaveHost(String host) throws SQLException {
        try {
            this.getThisAsProxy().addSlaveHost(host);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void removeSlave(String host) throws SQLException {
        try {
            this.getThisAsProxy().removeSlave(host);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void removeSlave(String host, boolean closeGently) throws SQLException {
        try {
            this.getThisAsProxy().removeSlave(host, closeGently);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isHostSlave(String host) {
        return this.getThisAsProxy().isHostSlave(host);
    }

    @Override
    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        try {
            this.getThisAsProxy().setReadOnly(readOnlyFlag);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.getThisAsProxy().isReadOnly();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void ping() throws SQLException {
        try {
            block7: {
                block6: {
                    try {
                        this.getThisAsProxy().masterConnection.ping();
                    }
                    catch (SQLException e2) {
                        if (!this.isMasterConnection()) break block6;
                        throw e2;
                    }
                }
                try {
                    this.getThisAsProxy().slavesConnection.ping();
                }
                catch (SQLException e3) {
                    if (this.isMasterConnection()) break block7;
                    throw e3;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void changeUser(String userName, String newPassword) throws SQLException {
        try {
            this.getThisAsProxy().masterConnection.changeUser(userName, newPassword);
            this.getThisAsProxy().slavesConnection.changeUser(userName, newPassword);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public synchronized void setStatementComment(String comment) {
        this.getThisAsProxy().masterConnection.setStatementComment(comment);
        this.getThisAsProxy().slavesConnection.setStatementComment(comment);
    }

    @Override
    public boolean hasSameProperties(JdbcConnection c2) {
        return this.getThisAsProxy().masterConnection.hasSameProperties(c2) && this.getThisAsProxy().slavesConnection.hasSameProperties(c2);
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getThisAsProxy().masterConnection.getProperties());
        props.putAll((Map<?, ?>)this.getThisAsProxy().slavesConnection.getProperties());
        return props;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.getThisAsProxy().doAbort(executor);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void abortInternal() throws SQLException {
        try {
            this.getThisAsProxy().doAbortInternal();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setProxy(JdbcConnection proxy) {
        this.getThisAsProxy().setProxy(proxy);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException(Messages.getString("Common.UnableToUnwrap", new Object[]{iface.toString()}), "S1009", this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    @Deprecated
    public synchronized void clearHasTriedMaster() {
        this.getThisAsProxy().masterConnection.clearHasTriedMaster();
        this.getThisAsProxy().slavesConnection.clearHasTriedMaster();
    }
}

