# apt-get

> Debian and Ubuntu package management utility.
> Search for packages using `apt-cache`.
> It is recommended to use `apt` when used interactively in Ubuntu versions 16.04 and later.
> More information: <https://manned.org/apt-get.8>.

- Update the list of available packages and versions (it's recommended to run this before other `apt-get` commands):

`sudo apt-get update`

- Install a package, or update it to the latest available version:

`sudo apt-get install {{package}}`

- Remove a package:

`sudo apt-get remove {{package}}`

- Remove a package and its configuration files:

`sudo apt-get purge {{package}}`

- Upgrade all installed packages to their newest available versions:

`sudo apt-get upgrade`

- Clean the local repository - removing package files (`.deb`) from interrupted downloads that can no longer be downloaded:

`sudo apt-get autoclean`

- Remove all packages that are no longer needed:

`sudo apt-get autoremove`

- Upgrade installed packages (like `upgrade`), but remove obsolete packages and install additional packages to meet new dependencies:

`sudo apt-get dist-upgrade`
