# go

> Управляйте исходным кодом Go.
> Некоторые подкоманды, такие как `build`, имеют собственную документацию по использованию.
> Больше информации: <https://pkg.go.dev/cmd/go>.

- Скачать и установить пакет, указанный по его пути импорта:

`go get {{путь/к/пакету}}`

- Скомпилировать и запустить исходный файл (он должен содержать пакет `main`):

`go run {{файл}}.go`

- Скомпилировать исходный файл в исполняемый файл с указанным именем:

`go build -o {{исполняемый_файл}} {{файл}}.go`

- Скомпилировать пакет, находящийся в текущем каталоге:

`go build`

- Выполнить все тесты для текущего пакета (файлы должны иметь окончание `_test.go`):

`go test`

- Скомпилировать и установить текущий пакет:

`go install`

- Инициализировать новый модуль в текущем каталоге:

`go mod init {{имя_модуля}}`
