# k6

> 엔지니어링 팀을 위한 오픈 소스 부하 테스트 도구 및 SaaS.
> 더 많은 정보: <https://grafana.com/docs/k6/latest/using-k6/k6-options/reference/>.

- 로컬에서 부하 테스트 실행:

`k6 run {{스크립트.js}}`

- 주어진 가상 사용자 수와 지속 시간으로 로컬에서 부하 테스트 실행:

`k6 run --vus {{10}} --duration {{30s}} {{스크립트.js}}`

- 주어진 환경 변수를 사용하여 로컬에서 부하 테스트 실행:

`k6 run -e {{HOSTNAME=example.com}} {{스크립트.js}}`

- InfluxDB를 사용하여 결과를 저장하며 로컬에서 부하 테스트 실행:

`k6 run --out influxdb={{http://localhost:8086/k6db}} {{스크립트.js}}`

- 응답 본문을 버리면서 (상당히 빠르게) 로컬에서 부하 테스트 실행:

`k6 run --discard-response-bodies {{스크립트.js}}`

- 기본 JavaScript 호환 모드를 사용하여 (상당히 빠르게) 로컬에서 부하 테스트 실행:

`k6 run --compatibility-mode=base {{스크립트.js}}`

- 비밀 토큰을 사용하여 클라우드 서비스에 로그인:

`k6 login cloud --token {{비밀}}`

- 클라우드 인프라에서 부하 테스트 실행:

`k6 cloud {{스크립트.js}}`
