# ssh

> 安全 Shell 是一种用于安全登录远程系统的协议。
> 它可用于在远程服务器上记录或执行命令。
> 更多信息：<https://man.openbsd.org/ssh>.

- 连接到远程服务器：

`ssh {{用户名}}@{{远程主机地址}}`

- 使用特定身份（私钥）连接到远程服务器：

`ssh -i {{路径/到/私钥文件}} {{用户名}}@{{远程主机地址}}`

- 使用指定端口号连接到远程服务器：

`ssh {{用户名}}@{{远程主机地址}} -p {{端口号}}`

- 在具有伪终端分配的远程服务器上运行命令，允许与远程命令进行交互：

`ssh {{用户名}}@{{远程主机地址}} -t {{命令}} {{命令参数}}`

- SSH 隧道：动态端口转发（`localhost:1080` 上的 SOCKS 代理）：

`ssh -D {{1080}} {{用户名}}@{{远程主机地址}}`

- SSH 隧道：转发特定端口（`localhost:9999` 到 `example.org:80`）以及禁用伪终端分配和远程命令的执行：

`ssh -L {{9999}}:{{example.org}}:{{80}} -N -T {{用户名}}@{{远程主机地址}}`

- SSH 转发：通过跳转主机连接到远程服务器（可以指定多个跳转，以逗号分隔）：

`ssh -J {{用户名}}@{{跳转主机地址}} {{用户名}}@{{远程主机地址}}`

- 关闭挂起的会话：

`<回车键><~><.>`
