# iverilog

> வெரிலாக் HDL (IEEE-1364) குறியீட்டை உருவகப்படுத்துதலுக்காக இயங்கக்கூடிய நிரல்களாக முன்செயலாக்கி தொகுக்கிறது.
> மேலும் விவரத்திற்கு: <https://github.com/steveicarus/iverilog>.

- ஒரு மூல கோப்பை இயங்கக்கூடியதாக தொகுக்கவும்:

`iverilog {{மூலம்.v/பாதை}} -o {{செயல்படுத்தக்கூடியதின்/பாதை}}`

- அனைத்து எச்சரிக்கைகளையும் காண்பிக்கும் போது ஒரு மூலக் கோப்பை இயங்கக்கூடியதாக தொகுக்கவும்:

`iverilog {{மூலம்.v/பாதை}} -Wall -o {{செயல்படுத்தக்கூடியதின்/பாதை}}`

- VVP இயக்க நேரத்தைப் பயன்படுத்தி வெளிப்படையாக தொகுத்து இயக்கவும்:

`iverilog -o {{செயல்படுத்தக்கூடியதின்/பாதை}} -tvvp {{மூலம்.v/பாதை}}`

- வேறொரு பாதையிலிருந்து வெரிலாக் நூலகக் கோப்புகளைப் பயன்படுத்தி தொகுக்கவும்:

`iverilog {{மூலம்.v/பாதை}} -o {{செயல்படுத்தக்கூடியதின்/பாதை}} -I{{நூலகம்_கோப்பகம்/பாதை}}`

- தொகுக்காமல் வெரிலாக் குறியீட்டை முன்கூட்டியே செயலாக்கவும்:

`iverilog -E {{மூலம்.v/பாதை}}`
