# declare

> 변수를 선언하고 속성을 부여.
> 더 많은 정보: <https://www.gnu.org/software/bash/manual/bash.html#index-declare>.

- 지정된 값을 사용하여 문자열 변수를 선언:

`declare {{변수}}="{{값}}"`

- 지정된 값을 가진 정수 변수를 선언:

`declare -i {{변수}}="{{값}}"`

- 지정된 값을 사용하여 배열 변수를 선언:

`declare -a {{변수}}=({{항목_a 항목_b 항목_c}})`

- 지정된 값을 사용하여 연관 배열 변수를 선언:

`declare -A {{변수}}=({{[키_a]=항목_a [키_b]=항목_b [키_c]=항목_c}})`

- 지정된 값을 사용해 읽기 전용 문자열 변수를 선언:

`declare -r {{변수}}="{{값}}"`

- 지정된 값을 사용해 함수 내에서 전역 변수를 선언:

`declare -g {{변수}}="{{값}}"`
