# cp

> ファイルやディレクトリをコピーします。
> もっと詳しく: <https://www.gnu.org/software/coreutils/manual/html_node/cp-invocation.html>。

- ファイルを別の場所にコピー:

`cp {{コピー元ファイルへのパス}} {{コピー先ファイルへのパス}}`

- ファイル名を維持したまま、ファイルを別のディレクトリにコピーする:

`cp {{コピー元ファイルへのパス}} {{コピー先ディレクトリへのパス}}`

- ディレクトリの内容を別の場所に再帰的にコピーする（コピー先が存在する場合は、その中にディレクトリがコピーされる):

`cp -R {{コピー元ディレクトリへのパス}} {{コピー先ディレクトリへのパス}}`

- 詳細モードでディレクトリを再帰的にコピーする（コピーされたファイルが表示される）:

`cp -vR {{コピー元ディレクトリへのパス}} {{コピー先ディレクトリへのパス}}`

- 対話形式でテキストファイルを別の場所にコピーする（上書きする前にユーザーに確認する）:

`cp -i {{*.txt}} {{コピー先ディレクトリへのパス}}`

- コピーする前にシンボリックリンクをたどる:

`cp -L {{link}} {{コピー先ディレクトリへのパス}}`
