package Spidy::Group;

use Spidy::List;
@ISA = qw( Spidy::List );
use Spidy::GraphicsBuilder;

use File::Basename;
use strict;

sub autoload_members {
    return {
        'id'                       => 'scalar',
        'depth'                    => 'scalar',
        'title'                    => 'scalar;xml=tag',
        'short_title'              => 'scalar;xml=tag',
        'name'                     => 'scalar;xml=attr',
        'output_image_path'        => 'scalar;xml=tag',
        'output_image_type'        => 'scalar;xml=tag',
        'output_image_path_type'   => 'scalar;xml=attr<output_image_path>',
        'output_html'              => 'scalar',
        'image_url'                => 'scalar;xml=attr',
        'input_image_path'         => 'scalar;xml=tag',
        'input_image_path_type'    => 'scalar;xml=attr<input_image_path>',
        'images_only'              => 'scalar',
        'file_path'                => 'scalar;xml=tag',
        'file_path_type'           => 'scalar;xml=attr<file_path>',
        'html_path'                => 'scalar;xml=attr',
        'base_url'                 => 'scalar;xml=attr',
        'width'                    => 'scalar',
        'height'                   => 'scalar',
        'size'                     => 'scalar;xml=attr',
        'column_count'             => 'scalar;xml=attr',
        'comment'                  => 'object=Spidy::Comment',
        'count'                    => 'scalar;',
        'pos'                      => 'scalar',
        'isolate'                  => 'scalar;xml=attr',
        'parent_path'              => 'scalar',
        'parent'                   => 'object=Spidy::Group',
        'parent_title'             => 'scalar',
        'left_group_output_html'   => 'scalar',
        'left_group_output_image'  => 'scalar',
        'left_group_html_path'     => 'scalar',
        'left_group_image_url'     => 'scalar',
        'right_group_output_html'  => 'scalar',
        'right_group_output_image' => 'scalar',
        'right_group_html_path'    => 'scalar',
        'right_group_image_url'    => 'scalar',
        'links'                    => 'array;object=Spidy::Link',
        'copyright'                => 'scalar;xml=tag',
        'groups'                   => 'array;object=Spidy::Group',
        'images'                   => 'array;object=Spidy::Image',
        'output_images'            => 'array',
        'ancestors'                => 'array',
        'bg_color'                 => 'scalar;xml=attr',
        'fg_color'                 => 'scalar;xml=attr',
        'vlink_color'              => 'scalar;xml=attr',
        'link_color'               => 'scalar;xml=attr',
        'rating'                   => 'scalar;xml=attr',
        # just for cgi mode
        'script_name'              => 'scalar',
        'bundle_download'          => 'scalar;xml=attr',
        'bundle_size'              => 'scalar',
        'bundle_name'              => 'scalar',
        'vars'                     => 'hash',
        
        'template'                 => "scalar;xml=attr",
        'template_path'            => "scalar;xml=attr",
    };
}

sub default {
  return {
    'bundle_download' => 0,
    'input_file_path' => '.',
    'template_path' => dirname($INC{'Spidy.pm'})."/Spidy/Templates",
    'output_html' => 'index.html',
    'rating' => 'GENERAL',
    'file_path' => '.',
    'html_path' => '.',
    'output_image_path' => './images',
    'file_path_type' => 'relative',
    'output_image_path_type' => 'fixed',
    'input_image_path_type' => 'fixed',
    'image_template_file' => 'image.tmpl',
    'group_template_file' => 'group.tmpl',
    'bg_color' => '000000',
    'fg_color' => 'FFFFFF',
    'vlink_color' => '7E26CE',
    'link_color' => '4A4AFF',
    'size' => 24,
    'image_url' => 'images',
  };
}

sub is_default {
  my $self = shift;
  my $var  = shift;
    
  if( $var eq 'template' ) {
    if( $self->isa("Spidy::Image") ) {
      return $self->{'template'} eq $self->default()->{'image_template_file'} 
        ? 1
        : 0;
    } else {
      return $self->{'template'} eq $self->default()->{'group_template_file'} 
        ? 1
        : 0;
    }
  } elsif ( $var =~ /^(?:
    bundle_download        |
    template_path          |
    rating                 |
    size                   |
    file_path_type         |
    input_image_path       |
    output_image_path_type |
    input_image_path_type  |
    bg_color               |
    fg_color               |
    vlink_color            |
    link_color
    )$/x ) {
    if( $self->{$var} ne $self->default()->{$var} ) {
      if( $self->{'parent'} && $self->{$var} eq $self->{'parent'}->{$var} ) {
        return 1;
      }
      return 0;
    } else {
      return 1;
    }
  } elsif ( $var eq 'html_path' || $var eq 'file_path' ) {
    if( $self->{'parent'} ) {
      if( $self->{'file_path_type'} eq 'relative' ) {
        my $html_path = $self->{$var};
        my $name = $self->escape( $self->{'name'} );
        $html_path =~ s/\/$name$//g;
          return $html_path eq $self->{'parent'}->{$var} ? 1 : 0;
      } else {
        return $self->{$var} eq $self->{'parent'}->{$var} ? 1 : 0;
      }
    } else {
      return $self->{$var} eq $self->default()->{$var} ? 1 : 0
    }
  } elsif ( $var eq 'image_url' || $var eq 'output_image_path' ) {
    if( $self->{'parent'} ) {
      if( $self->{'output_image_path_type'} eq 'relative' ) {
        my $image_url = $self->{$var};
        my $name = $self->escape( $self->{'name'} );
        $image_url =~ s/\/$name$//g;
        return $image_url eq $self->{'parent'}->{$var} ? 1 : 0;
      } else {
        return $self->{$var} eq $self->{'parent'}->{$var} ? 1 : 0;
      }
    } else {
      return $self->{$var} eq $self->default()->{$var} ? 1 : 0
    }
  }
  #elsif( $var eq 'input_image_path' ) {
  #}
}
  

sub DESTROY {
  my $self = shift;
 
  #
  # get rid of circular references by deleteing the parent
  # reference when I am killed.
  #
  if( $self->{'parent'} ) {
    delete $self->{'parent'};
  }
}

# lexically scope $gb 
{
  my $gb;
  
  sub get_bg_color {
    my $self = shift;
    $gb = new Spidy::GraphicsBuilder unless $gb;
    return $gb->get_rgb($self->{'bg_color'});
  }

  sub get_fg_color {
    my $self = shift;
    $gb = new Spidy::GraphicsBuilder unless $gb;
    return $gb->get_rgb($self->{'fg_color'});
  }

  sub get_vlink_color {
    my $self = shift;
    $gb = new Spidy::GraphicsBuilder unless $gb;
    return $gb->get_rgb($self->{'vlink_color'});
  }

  sub get_link_color {
    my $self = shift;
    $gb = new Spidy::GraphicsBuilder unless $gb;
    return $gb->get_rgb($self->{'link_color'});
  }
}

sub set_defaults { 
  my $self = shift;
  my %defaults;
  if( ref($_[0]) ) {
    %defaults = %{$_[0]};
  } else {
    %defaults = @_;
  }
  
  for my $key ( keys %defaults ) {
    $self->{$key} = $defaults{$key}
      unless defined $self->{$key};
  }
  
  #
  # Data here is for html file generation
  # of image generation.  Also html data
  # that is recursive in nature (directory paths)
  # is set here for efficiency's sake.
  # 
  #

  if( my $parent = $self->{'parent'} ) {
    $self->{'output_image_path_type'}
      = $parent->{'output_image_path_type'}
      unless $self->{'output_image_path_type'};

    $self->{'output_image_path'}
      = $self->{'output_image_path_type'} eq 'relative'
        ? "$parent->{'output_image_path'}/$self->{'name'}"
        : $parent->{'output_image_path'}
      unless $self->{'output_image_path'};

    $self->{'output_image_type'}
      = $parent->{'output_image_type'}
      unless $self->{'output_image_type'};

    $self->{'input_image_path_type'}
      = $parent->{'input_image_path_type'}
      unless $self->{'input_image_path_type'};
      
    $self->{'input_image_path'}
      = $self->{'input_image_path_type'} eq 'relative'
        ? "$parent->{'input_image_path'}/$self->{'name'}"
        : $parent->{'input_image_path'}
      unless $self->{'input_image_path'};

    $self->{'file_path_type'}
      = $parent->{'file_path_type'}
      unless $self->{'file_path_type'};

    $self->{'file_path'}
      = $self->{'file_path_type'} eq 'relative'
        ? "$parent->{'file_path'}/$self->{'name'}"
        : $parent->{'file_path'}
      unless $self->{'file_path'};

    $self->{'html_path'}
      = $self->{'file_path_type'} eq 'relative'
        ? "$parent->{'html_path'}/".$self->escape($self->{'name'})
        : $parent->{'html_path'}
      unless $self->{'html_path'};
      
    unless( $self->{'top_html_path'} ) {
      my $depth = 1;
      my $parent = $self->{'parent'};
      $self->{'top_html_path'} = $self->{'base_url'}
        if $self->{'base_url'};
        
      unless( $self->{'top_html_path'} ) {
        $depth++ and $parent = $parent->{'parent'} while $parent;
        $self->{'top_html_path'} 
          = join("/", ("..")x($depth-1))
          || '.';
      }
    }
    $self->{'image_url'}
      = $self->{'output_image_path_type'} eq 'relative'
        ? "$parent->{'image_url'}/".$self->escape($self->{'name'})
        : $parent->{'image_url'}
      unless $self->{'image_url'};

    if( $self->{'image_url'} =~ /^(?:https?|file):/ && !$parent->{'top_image_path'}) {
      $self->{'top_image_path'} = $self->{'image_url'};
      $self->{'image_url'} = '.';
    } elsif( $parent->{'top_image_path'} =~ /^(?:https?|file):/ ) {
      $self->{'top_image_path'} = $parent->{'top_image_path'};
    } else {
      $self->{'top_image_path'} = $self->{'top_html_path'};
    }
    
    $self->{'top_image_path'} = $parent->{'top_image_path'} || '.'
      unless $self->{'top_image_path'};
    

    if( exists $parent->{'vars'} ) {
      while( my( $var, $val ) = each %{$parent->{'vars'}} ) {
        $self->{'vars'}->{$var} = $val;
      }
    }
    
    for my $prefix ( qw( bg fg link vlink ) ) {
      if( exists $parent->{"${prefix}_color"} ) {
        $self->{"${prefix}_color"} = $parent->{"${prefix}_color"}
          unless $self->{"${prefix}_color"};
      }
    }
  } else {
    
    $self->{'name'} = "" unless defined $self->{'name'};
    if( $self->{'base_url'} =~ /^(?:https?|file):/ ) {
      $self->{'top_html_path'} = $self->{'base_url'};
    } else {
      $self->{'top_html_path'} = '.'
        unless $self->{'top_html_path'};
    }

    $self->{'image_url'} = '.'
      unless $self->{'image_url'};
      
    if( $self->{'image_url'} =~ /^(?:https?|file):/ ) {
      $self->{'top_image_path'} = $self->{'image_url'};
      $self->{'image_url'} = '.';
    } else {
      $self->{'top_image_path'} = $self->{'top_html_path'}
        unless $self->{'top_image_path'};
    }

    $self->{'top_image_path'} = '.'
      unless $self->{'top_image_path'};

  }
  return;
}  

sub escape {
  my $self = shift;
  my $uri = shift;
  $uri =~ s|([^a-zA-Z0-9_/.-])|uc sprintf("%%%02x",ord($1))|eg;
  return $uri;
}

sub set_param_data { 
  my $self = shift;
  my $p = shift;
  my $size = shift;
  my $caller = shift || $self;
  
  if( $p eq 'title' ) {
    return $self->{$p} || "Group ".$self->pos();
  } elsif( $p eq 'short_title' ) {
    return $self->{$p} || $self->{'title'} || "Group ".$self->pos();
  } elsif( $p eq 'href' ) {
    return "$caller->{'top_html_path'}/$self->{'html_path'}/$size->{'name'}_$self->{'output_html'}";
  } elsif( $p eq 'src' ) {
    my $i = $self->first_image();
    my $thumb = $size->first();
    my $output_image = $i->get_output_image($thumb);
    if( $thumb->{'padded'} ) {
      return "$caller->{'top_image_path'}/$i->{'image_url'}/$thumb->{'name'}/".$caller->set_param_data('bg_color', $size, $caller)."/$output_image";
    } else {
      return "$caller->{'top_image_path'}/$i->{'image_url'}/$thumb->{'name'}/$output_image";
    }
  } elsif( $p eq 'width' || $p eq 'max_width' ) {
    my $first = $size->first();
    return $size->first()->{'max_width'};
  } elsif( $p eq 'height' || $p eq 'max_height' ) {
    return $size->first()->{'max_height'};
  } elsif( $p eq 'comment' ) {
    return $self->{$p}->{'text'} if $self->{$p};
    my $c = $self->{'parent'}->lookup($p)
      if $self->{'parent'};
    return unless $c;
    return $c->{'text'} if $c->{'default'};
  } elsif( $p eq 'count' ) {
    if( $self->{'groups'} ) {
      my $cur = $self->{'groups'};
      my $cnt = 0;
      while( $cur ) {
        $cnt += $cur->set_param_data('count', $size, $caller );
        $cur = $cur->{'next'};
      }
      return $cnt;
    } elsif( $self->{'images'} ) {
      return $self->{'images'}->count();
    }
    return $self->count();
  } elsif( $p eq 'parent_href' ) {
    return $self->{'parent_path'} if $self->{'parent_path'};
    return $self->{'parent'}->set_param_data( 'href', $size, $caller )
      if $self->{'parent'};
    return;
  } elsif( $p eq 'left_group_href' ) {
    my $prev = $self->previous_group();
    return $prev->set_param_data( 'href', $size, $caller )
      if $prev;
    return;
  } elsif( $p eq 'left_group_src' ) {
    my $prev = $self->previous_group();
    return unless $prev;
    my $first = $prev->first_image();
    return $first->set_param_data( 'src', $size->first(), $caller )
      if $first;
    return;
  } elsif( $p eq 'right_group_href' ) {
    my $next = $self->next_group();
    return $next->set_param_data( 'href', $size, $caller )
      if $next;
    return;
  } elsif( $p eq 'right_group_src' ) {
    my $next = $self->next_group();
    return unless $next;
    my $first = $next->first_image();
    return $first->set_param_data( 'src', $size->first(), $caller )
      if $first;
    return;
  } elsif( $p eq 'links' ) {
    return $self->{$p} if $self->{$p};
    my $l = $self->{'parent'}->lookup($p)
      if $self->{'parent'};
    return $l || [];
  } elsif( $p eq 'copyright' ) {
    return $self->{$p} if $self->{$p};
    my $c = $self->{'parent'}->lookup($p)
      if $self->{'parent'};
    return $c;
  } elsif ( $p eq 'column_count' ) {
    return $self->lookup( 'column_count' ) || 8;
  } elsif ( $p eq 'show_title' ) {
    return $self->isa("Spidy::Image") ? 0 : 1;
  } elsif ( $p eq 'newline' ) {
    return $self->pos() % $caller->set_param_data('column_count') == 0 ? 1 : 0;
  } elsif( $p eq 'groups' ) {
    my $column_count = $self->set_param_data('column_count', $size, $caller);

    my $hb = Spidy::HtmlBuilder->new();
    my @names = $hb->get_template($caller)->query( loop => $p );
    
    my @children = $self->children();
    
    my @data;
    for my $child ( @children ) {
      my %data;
      for my $param ( @names ) {
        $data{$param} = $child->set_param_data($param, $size, $caller);
      }
      push @data, \%data;
    }
    if( @data % $column_count != 0 && @data > $column_count ) {
      for( my $i = $column_count - @data % $column_count; $i > 0; $i-- ) {
        push @data, { 'empty' => 1 };
      }
    }
    return \@data;
  } elsif( $p eq 'ancestors' ) {
    my @data;
    my $parent = $self->{'parent'};
    while( $parent ) {
      unshift @data, {
        'href' => $parent->set_param_data( 'href', $size, $caller ),
        'short_title' => $parent->set_param_data( 'short_title', $size, $caller ),
      };
      $parent = $parent->{'parent'};
    }
    return \@data;
  } elsif( $p eq 'bg_color' ) {
    return $self->get_bg_color();
  } elsif( $p eq 'fg_color' ) {
    return $self->get_fg_color();
  } elsif( $p eq 'vlink_color' ) {
    return $self->get_vlink_color();
  } elsif( $p eq 'link_color' ) {
    return $self->get_link_color();
  } elsif( $p eq 'rating' ) {
    return $self->{$p} || "GENERAL";
  } elsif ( $p eq 'originals' ) {
    return 1 if $self->{'bundle_download'} && $self->{'bundle_size'};
  } elsif ( $p eq 'compressed_href' ) {
    return "$caller->{'top_html_path'}/$self->{'html_path'}/$self->{'bundle_name'}";
  } elsif ( $p eq 'originals_size' ) {
    return $self->{'bundle_size'};
  } else {
    return $self->{$p};
  }
}

sub template_file {
  my $self = shift;
  return $self->{'template'} || $self->default->{'group_template_file'};
}

#
# if we are dealing with a custom size, then change the image output name to 
# reflect the the image that we are dealing with.  For custom images
# the name will look like:
# <image name>_<width>x<height>_<quality>.jpg
#
#

sub get_output_image {
  my $self = shift;
  my $size = shift;
  return unless $size;
  return $self->{'input_image'} if $size->{'name'} eq 'original' && $size->{'symlink'};
  if( $size->{'custom'} ) {
    my $output_image = $self->{'output_image'};
    $output_image =~ s/([.][^.]+)$/_$size->{'max_width'}x$size->{'max_height'}_$size->{'quality'}$1/;
    return $output_image;
  }
  return $self->{'output_image'};
}
 
sub get_output_mouse_over {
  my $self = shift;
  my $size = shift;
  return unless $size;
  return $self->{'mouse_over'} if $size->{'name'} eq 'original';
  if( $size->{'custom'} ) {
    my $output_mouse_over = $self->{'output_mouse_over'};
    $output_mouse_over =~ s/([.][^.]+)$/_$size->{'max_width'}x$size->{'max_height'}_$size->{'quality'}$1/;
    return $output_mouse_over;
  }
  return $self->{'output_mouse_over'};
}

#
# $_[0] = self
# $_[1] = param name
#
sub lookup {
  return $_[0]->{$_[1]} if defined $_[0]->{$_[1]};
  return $_[0]->{'parent'}->lookup($_[1])
    if $_[0]->{'parent'};
  return;
}

sub first_image {
  my $self = shift;
  return $self if $self->isa("Spidy::Image");
  return $self->{'images'} if $self->{'images'};
  my $cur = $self->{'groups'};
  # dig down until the current object does not have a 'groups' member ... 
  # it can only have images at this point.
  $cur = $cur->{'groups'} while( $cur && $cur->{'groups'} );
  while( $cur ) {
    return $cur->{'images'} if $cur->{'images'};
    $cur = $cur->{'next'};
  }
  return;
}

sub last_image {
  my $self = shift;
  return $self if $self->isa("Spidy::Image");
  return $self->{'images'}->last() if $self->{'images'};
  my $cur = $self->{'groups'};
  while( $cur ) {
    return $cur->{'images'}->last() if $cur->{'images'};
    $cur = $cur->{'next'};
  }
  return;
}

sub previous_group {
  my $self = shift;
  
  my $is_group = 1 if $self->{'previous'} 
    && ! $self->{'previous'}->isa("Spidy::Image");
      
  # return the previous if the previous exists
  # and it has children (ie it is a group, not image).
  return $self->{'previous'} 
    if $self->{'previous'}
      && $is_group;
      
  return unless $self->{'parent'};
  my $cur = $self->{'parent'};
  my $depth = 1;
  while( $cur && !$cur->{'previous'} ) {
    $depth++;
    $cur = $cur->{'parent'};
  }
  
  my $prev = $cur->{'previous'};
  while( $prev && $prev->{'groups'} && $depth ) {
    $depth--;
    $prev = $prev->{'groups'}->last();
  }
  
  return $prev;
}  
  
sub next_group {
  my $self = shift;

  my $is_group = 1 if $self->{'next'} 
    && ! $self->{'next'}->isa("Spidy::Image");
      
  # return the next if the next exists
  # and it has children (ie it is a group, not image).
  return $self->{'next'} if $self->{'next'}
      && $is_group;
      
  my $cur = $self->{'parent'};
  my $depth = 1;
  while( $cur && !$cur->{'next'} ) {
    $depth++;
    $cur = $cur->{'parent'};
   }
  
  my $next = $cur->{'next'};
  while( $next && $next->{'groups'} && $depth ) {
    $depth--;
    $next = $next->{'groups'};
  }
  return $next;
}  

sub isolated {
  my $self = shift;
  return 1 if $self->{'isolate'};
  my ( $cur1, $cur2 ) = @_;
  my $isolate = 0;
  while( $cur1 && $cur2 ) {
    last if $cur1->{'id'} eq $cur2->{'id'};
    if( $cur1->{isolate} || $cur2->{isolate} ) {
      $isolate++;
      last;
    }
    ($cur1, $cur2) = ( $cur1->{'parent'}, $cur2->{'parent'} );
  }
  return $isolate;
}

# returns a list if a list is wanted, otherwise it returns
# the head pointer to the linked list
sub children {
  my $self = shift;
  my $children = $self->{'groups'} || $self->{'images'};
  if( $children ) {
    return wantarray ? $children->list() : $children;
  }
  return wantarray ? () : undef;
}

1;    

