package Spidy::Database::Structure;

sub new {
  return bless _table_struct(), $_[0];
}

sub get_tables {
  my $self = shift;
  unless( ref( $self->[0] ) eq 'Spidy::Database::Table' ) {
    require Spidy::Database::Table;
    bless $_, "Spidy::Database::Table" foreach @$self;
  }
  return wantarray ? @$self : $self;
}

sub get_table {
  my $self = shift;
  my $name = shift;
  for my $table (@$self) {
    if( $table->{'name'} eq $name ) {
      require Spidy::Database::Table;
      bless $table, "Spidy::Database::Table" 
        unless ref($table) eq 'Spidy::Database::Table';
      return $table;
    }
  }
  return;
}

sub _table_struct {
  return [ {
      name => 'colors',
      cols => [ {
          name => 'color_id',
          type => 'int',
          value => 'auto',
        }, {
          name => 'bg_color',
          type => 'varchar',
          size => 20,
        }, {
          name => 'fg_color',
          type => 'varchar',
          size => 20
        }, {
          name => 'vlink_color',
          type => 'varchar',
          size => 20,
        }, {
          name => 'link_color',
          type => 'varchar',
          size => 20,
        }
      ],
      keys => [ {
          type => 'primary',
          cols => "color_id",
        }, {
          type => 'unique',
          cols => [ 'bg_color', 'fg_color', 'vlink_color', 'link_color' ],
        }
      ]
    }, {
      name => 'images',
      cols => [ {
          name => 'image_id',
          type => 'int',
          value => 'auto',
#         }, {
#           name => 'output_image',
#           type => 'varchar',
#           size => 255,
#           null => 1,
#         }, {
#           name => 'output_html',
#           type => 'varchar',
#           size => 255,
#           null => 1,
#         }, {
#           name => 'output_image_path',
#           type => 'varchar',
#           size => 255,
#           null => 1,
        }, {
          name => 'input_image',
          type => 'varchar',
          size => 255,
          null => 1,
        }, {
          name => 'input_image_path',
          type => 'varchar',
          size => 255,
          null => 1,
        }
#         }, {
#           name => 'image_url',
#           type => 'varchar',
#           size => 255,
#           null => 1,
#         }, {
#           name => 'image',
#           type => 'varchar',
#           size => 255,
#         }
      ],
      keys => [ {
          type => 'primary',
          cols => 'image_id',
        }
      ],
    }, {
      name => 'groups',
      cols => [ {
          name => 'group_id',
          type => 'int',
          value => 'auto',
        }, {
          name => 'title', 
          type => 'varchar', 
          size => 255,
          null => 1,
        }, {
          name => 'short_title', 
          type => 'varchar', 
          size => 255,
          null => 1,
        }, {
          name => 'copyright', 
          type => 'varchar', 
          size => 255,
          null => 1,
        }, {
          name => 'name',
          type => 'varchar',
          size => 255,
          null => 0,
          default => '',
        }, { 
          name => 'path',
          type => 'varchar',
          size => 255
        }, {
#           name => 'html_path',
#           type => 'varchar',
#           size => 255,
#         }, {
#           name => 'file_path',
#           type => 'varchar',
#           size => 255,
#         }, {
          name => 'bundle_download',
          type => 'bool',
          null => 1,
        }, {
          name => 'bundle_size',
          type => 'int',
          null => 1,
        }, {
          name => 'bundle_href',
          type => 'varchar',
          size => 255,
          null => 1,
        }, {
#           name => 'left_isolate',
#           type => 'bool',
#           null => 1,
#         }, {
#           name => 'right_isolate',
#           type => 'bool',
#           null => 1,
#         }, {
          name => 'column_count',
          type => 'int',
          null => 1,
        }, {
          name => 'rating',
          type => 'varchar',
          size => 30,
          null => 1,
        }, {
          name => 'xml_id',
          type => 'int',
          null => 1,
        }, {
          name => 'comment_id',
          type => 'int',
          null => 1,
        }, {
          name => 'image_id',
          type => 'int',
        }, {
          name => 'color_id',
          type => 'int',
        }, {
          name => 'type',
          type => 'varchar',
          size => '50',
        }
      ],
      keys => [ {
          type => 'primary',
          cols => 'group_id',
        }, {
          type => 'foreign',
          cols => 'image_id',
          ref_table => 'images',
          ref_column => 'image_id',
        }
      ]
    }, {
      name => 'sizes',
      cols => [ {
          name => 'size_id',
          type => 'int',
          value => 'auto'
        }, {
          name => 'name',
          type => 'varchar',
          size => 50
        }, {
          name => 'max_height',
          type => 'int',
          null => 1,
        }, {
          name => 'max_width',
          type => 'int',
          null => 1,
        }, {
          name => 'quality',
          type => 'int',
          null => 1,
        }, {
          name => 'padded',
          type => 'bool',
          null => 1,
        }, {
          name => 'pad_color',
          type => 'varchar',
          null => 1,
          size => 20
        }, {
          name => 'custom',
          type => 'bool',
          null => 1
        }
      ],
      keys => [ {
          type => 'primary',
          cols => 'size_id',
        }, {
          type => 'unique',
          cols => 'name',
        }
      ]
    }, {
      name => 'group_sizes',
      cols => [ {
          name => 'group_id',
          type => 'int',
        }, {
          name => 'size_id',
          type => 'int',
        }, {
          name => 'color_id',
          type => 'int',
        }, {
          name => 'width',
          type => 'int'
        }, {
          name => 'height',
          type => 'int'
        }, {
          name => 'src', 
          type => 'varchar',
          size => 255
        }
      ],
      keys => [ {
          type => 'primary',
          cols => ['group_id', 'size_id', 'color_id'],
        }, {
          type => 'foreign',
          cols => 'group_id',
          ref_table => 'groups',
          ref_column => 'group_id',
        }, {
          type => 'foreign',
          cols => 'size_id',
          ref_table => 'sizes',
          ref_column => 'size_id',
        }, {
          type => 'foreign',
          cols => 'color_id',
          ref_table => 'colors',
          ref_column => 'color_id',
        }
      ],
#     }, {
#       name => 'subgroups',
#       cols => [ {
#           name => 'group_id',
#           type => 'int',
#         }, {
#           name => 'subgroup_id',
#           type => 'int',
#         }, {
#           name => 'pos',
#           type => 'int',
#           null => 1,
#         }
#       ],
#       keys => [ {
#           type => 'primary', 
#           cols => ['group_id', 'subgroup_id'],
#         }, {
#           type => 'foreign',
#           cols => 'group_id',
#           ref_table => 'groups',
#           ref_column => 'group_id',
#         }, {
#           type => 'foreign',
#           cols => 'subgroup_id',
#           ref_table => 'groups',
#           ref_column => 'group_id',
#         }
#       ],
    }, {
      name => 'hierarchy',
      cols => [ {
          name => 'group_id',
          type => 'int',
        }, {
          name => 'elder_id',
          type => 'int',
        }, {
          name => 'left_id',
          type => 'int',
          null => 1,
        }, {
          name => 'right_id',
          type => 'int',
          null => 1,
        }, {
          name => 'generation',
          type => 'int',
        }, {
          name => 'pos',
          type => 'int',
        }
      ],
      keys => [ {
          type => 'primary',
          cols => ['group_id', 'elder_id'],
        }, {
          type => 'foreign',
          cols => 'group_id',
          ref_table => 'groups',
          ref_column => 'group_id',
        }, {
          type => 'foreign',
          cols => 'elder_id',
          ref_table => 'groups',
          ref_column => 'group_id',
        }, {
          type => 'foreign',
          cols => 'left_id',
          ref_table => 'groups',
          ref_column => 'group_id',
        }, {
          type => 'foreign',
          cols => 'right_id',
          ref_table => 'groups',
          ref_column => 'group_id',
        }
      ],
    }, {
      name => 'links',
      cols => [ {
          name => 'link_id',
          type => 'int',
          value => 'auto'
        }, {
          name => 'text',
          type => 'varchar',
          null => 1,
          size => 255
        }
      ],
      keys => [ {
          type => 'primary',
          cols => 'link_id',
        }
      ]
    }, {
      name => 'group_links',
      cols => [ {
          name => 'group_id',
          type => 'int',
        }, {
          name => 'link_id',
          type => 'int',
        }
      ],
      keys => [ {
          type => 'primary',
          cols => ['group_id', 'link_id'],
        }, {
          type => 'foreign',
          cols => 'group_id',
          ref_table => 'groups',
          ref_column => 'group_id',
        }, {
          type => 'foreign',
          cols => 'link_id',
          ref_table => 'links',
          ref_column => 'link_id',
        }
      ],
    }, {
      name => 'comments',
      cols => [ {
          name => 'comment_id',
          type => 'int',
          value => 'auto'
        }, {
          name => 'text',
          type => 'text',
          null => 1,
        }
      ],
      keys => [ {
          type => 'primary',
          cols => 'comment_id',
        }
      ],
    }
  ];
}

1;
