package Spidy::Database::Pg;

use Spidy::Database;
@ISA = qw( Spidy::Database );

use Spidy::Database::Structure;

use DBD::Pg;
use strict;

sub get_dbh {
  my $self = shift;
  return $self->{'dbh'} 
    if $self->{'dbh'} && $self->{'dbh'}->ping;
  my @opts;
  push @opts, "dbname=$self->{'database'}" if $self->{'database'};
  push @opts, "host=$self->{'server'}"     if $self->{'server'};
  push @opts, "port=$self->{'port'}"       if $self->{'port'};
  my $opts = join ";", @opts;
  $self->{'dbh'} = DBI->connect( 
    "dbi:Pg:$opts", 
    $self->{'user'},
    $self->{'password'}
  ) or die "Login Failed: $DBI::errstr";
  return $self->{'dbh'};
}

sub drop {
  my $self = shift;
  my $db = new Spidy::Database::Structure;
  my @seq;
  for my $table ($db->get_tables()) {
    for my $col ($table->get_cols()) {
      push @seq, "seq_".$col->{'name'} if $col->{'value'} eq 'auto';
    }
  }
  $self->query("DROP SEQUENCE $_") for @seq;
  $self->SUPER::drop();
}

sub format_column_type {
  my $self = shift;
  my $col = shift;
  return "INTEGER"  if $col->{'type'} eq 'int';
  return $self->SUPER::format_column_type($col);
}

sub format_column_value {
  my $self = shift;
  my $col = shift;
  if( $col->{'value'} eq 'auto' ) {
    return (
      "CREATE SEQUENCE seq_".$col->{'name'},
      $self->format_null_value($col) . " DEFAULT nextval('seq_".$col->{'name'}."')",
      undef
    );
  } else {
    return $self->SUPER::format_column_value($col);
  }
}

#
# no values for sequence rows
#
sub filter_insert_cols { 
  my $self = shift;
  return grep { 
    $_->{'value'} ne 'auto'
  } @_;
}

sub format_value {
  my $self = shift;
  my $col  = shift;
  my $data = shift;
  
  if( $col->{'type'} eq "bool" ) {
    return $data ? "true" : "false";
  }
  return $self->SUPER::format_value($col, $data);
}

1;
