# Ruby-SDL2 : Yet another SDL2 wrapper for Ruby
#
# * https://github.com/vaiorabbit/sdl2-bindings
#
# [NOTICE] This is an automatically generated file.

require 'ffi'

module SDL
  extend FFI::Library
  # Define/Macro

  ICONV_ERROR = 4294967295
  ICONV_E2BIG = 4294967294
  ICONV_EILSEQ = 4294967293
  ICONV_EINVAL = 4294967292

  # Enum

  FALSE = 0
  TRUE = 1

  # Typedef

  typedef :int, :SDL_bool
  typedef :char, :Sint8
  typedef :uchar, :Uint8
  typedef :short, :Sint16
  typedef :ushort, :Uint16
  typedef :int, :Sint32
  typedef :uint, :Uint32
  typedef :long_long, :Sint64
  typedef :ulong_long, :Uint64
  callback :SDL_malloc_func, [:ulong], :pointer
  callback :SDL_calloc_func, [:ulong, :ulong], :pointer
  callback :SDL_realloc_func, [:pointer, :ulong], :pointer
  callback :SDL_free_func, [:pointer], :void
  typedef :pointer, :SDL_iconv_t

  # Struct


  # Function

  def self.setup_stdinc_symbols(output_error = false)
    symbols = [
      :SDL_malloc,
      :SDL_calloc,
      :SDL_realloc,
      :SDL_free,
      :SDL_GetOriginalMemoryFunctions,
      :SDL_GetMemoryFunctions,
      :SDL_SetMemoryFunctions,
      :SDL_GetNumAllocations,
      :SDL_getenv,
      :SDL_setenv,
      :SDL_qsort,
      :SDL_bsearch,
      :SDL_abs,
      :SDL_isalpha,
      :SDL_isalnum,
      :SDL_isblank,
      :SDL_iscntrl,
      :SDL_isdigit,
      :SDL_isxdigit,
      :SDL_ispunct,
      :SDL_isspace,
      :SDL_isupper,
      :SDL_islower,
      :SDL_isprint,
      :SDL_isgraph,
      :SDL_toupper,
      :SDL_tolower,
      :SDL_crc16,
      :SDL_crc32,
      :SDL_memset,
      :SDL_memcpy,
      :SDL_memmove,
      :SDL_memcmp,
      :SDL_wcslen,
      :SDL_wcslcpy,
      :SDL_wcslcat,
      :SDL_wcsdup,
      :SDL_wcsstr,
      :SDL_wcscmp,
      :SDL_wcsncmp,
      :SDL_wcscasecmp,
      :SDL_wcsncasecmp,
      :SDL_strlen,
      :SDL_strlcpy,
      :SDL_utf8strlcpy,
      :SDL_strlcat,
      :SDL_strdup,
      :SDL_strrev,
      :SDL_strupr,
      :SDL_strlwr,
      :SDL_strchr,
      :SDL_strrchr,
      :SDL_strstr,
      :SDL_strcasestr,
      :SDL_strtokr,
      :SDL_utf8strlen,
      :SDL_utf8strnlen,
      :SDL_itoa,
      :SDL_uitoa,
      :SDL_ltoa,
      :SDL_ultoa,
      :SDL_lltoa,
      :SDL_ulltoa,
      :SDL_atoi,
      :SDL_atof,
      :SDL_strtol,
      :SDL_strtoul,
      :SDL_strtoll,
      :SDL_strtoull,
      :SDL_strtod,
      :SDL_strcmp,
      :SDL_strncmp,
      :SDL_strcasecmp,
      :SDL_strncasecmp,
      :SDL_sscanf,
      :SDL_vsscanf,
      :SDL_snprintf,
      :SDL_vsnprintf,
      :SDL_asprintf,
      :SDL_vasprintf,
      :SDL_acos,
      :SDL_acosf,
      :SDL_asin,
      :SDL_asinf,
      :SDL_atan,
      :SDL_atanf,
      :SDL_atan2,
      :SDL_atan2f,
      :SDL_ceil,
      :SDL_ceilf,
      :SDL_copysign,
      :SDL_copysignf,
      :SDL_cos,
      :SDL_cosf,
      :SDL_exp,
      :SDL_expf,
      :SDL_fabs,
      :SDL_fabsf,
      :SDL_floor,
      :SDL_floorf,
      :SDL_trunc,
      :SDL_truncf,
      :SDL_fmod,
      :SDL_fmodf,
      :SDL_log,
      :SDL_logf,
      :SDL_log10,
      :SDL_log10f,
      :SDL_pow,
      :SDL_powf,
      :SDL_round,
      :SDL_roundf,
      :SDL_lround,
      :SDL_lroundf,
      :SDL_scalbn,
      :SDL_scalbnf,
      :SDL_sin,
      :SDL_sinf,
      :SDL_sqrt,
      :SDL_sqrtf,
      :SDL_tan,
      :SDL_tanf,
      :SDL_iconv_open,
      :SDL_iconv_close,
      :SDL_iconv,
      :SDL_iconv_string,
    ]
    apis = {
      :SDL_malloc => :malloc,
      :SDL_calloc => :calloc,
      :SDL_realloc => :realloc,
      :SDL_free => :free,
      :SDL_GetOriginalMemoryFunctions => :GetOriginalMemoryFunctions,
      :SDL_GetMemoryFunctions => :GetMemoryFunctions,
      :SDL_SetMemoryFunctions => :SetMemoryFunctions,
      :SDL_GetNumAllocations => :GetNumAllocations,
      :SDL_getenv => :getenv,
      :SDL_setenv => :setenv,
      :SDL_qsort => :qsort,
      :SDL_bsearch => :bsearch,
      :SDL_abs => :abs,
      :SDL_isalpha => :isalpha,
      :SDL_isalnum => :isalnum,
      :SDL_isblank => :isblank,
      :SDL_iscntrl => :iscntrl,
      :SDL_isdigit => :isdigit,
      :SDL_isxdigit => :isxdigit,
      :SDL_ispunct => :ispunct,
      :SDL_isspace => :isspace,
      :SDL_isupper => :isupper,
      :SDL_islower => :islower,
      :SDL_isprint => :isprint,
      :SDL_isgraph => :isgraph,
      :SDL_toupper => :toupper,
      :SDL_tolower => :tolower,
      :SDL_crc16 => :crc16,
      :SDL_crc32 => :crc32,
      :SDL_memset => :memset,
      :SDL_memcpy => :memcpy,
      :SDL_memmove => :memmove,
      :SDL_memcmp => :memcmp,
      :SDL_wcslen => :wcslen,
      :SDL_wcslcpy => :wcslcpy,
      :SDL_wcslcat => :wcslcat,
      :SDL_wcsdup => :wcsdup,
      :SDL_wcsstr => :wcsstr,
      :SDL_wcscmp => :wcscmp,
      :SDL_wcsncmp => :wcsncmp,
      :SDL_wcscasecmp => :wcscasecmp,
      :SDL_wcsncasecmp => :wcsncasecmp,
      :SDL_strlen => :strlen,
      :SDL_strlcpy => :strlcpy,
      :SDL_utf8strlcpy => :utf8strlcpy,
      :SDL_strlcat => :strlcat,
      :SDL_strdup => :strdup,
      :SDL_strrev => :strrev,
      :SDL_strupr => :strupr,
      :SDL_strlwr => :strlwr,
      :SDL_strchr => :strchr,
      :SDL_strrchr => :strrchr,
      :SDL_strstr => :strstr,
      :SDL_strcasestr => :strcasestr,
      :SDL_strtokr => :strtokr,
      :SDL_utf8strlen => :utf8strlen,
      :SDL_utf8strnlen => :utf8strnlen,
      :SDL_itoa => :itoa,
      :SDL_uitoa => :uitoa,
      :SDL_ltoa => :ltoa,
      :SDL_ultoa => :ultoa,
      :SDL_lltoa => :lltoa,
      :SDL_ulltoa => :ulltoa,
      :SDL_atoi => :atoi,
      :SDL_atof => :atof,
      :SDL_strtol => :strtol,
      :SDL_strtoul => :strtoul,
      :SDL_strtoll => :strtoll,
      :SDL_strtoull => :strtoull,
      :SDL_strtod => :strtod,
      :SDL_strcmp => :strcmp,
      :SDL_strncmp => :strncmp,
      :SDL_strcasecmp => :strcasecmp,
      :SDL_strncasecmp => :strncasecmp,
      :SDL_sscanf => :sscanf,
      :SDL_vsscanf => :vsscanf,
      :SDL_snprintf => :snprintf,
      :SDL_vsnprintf => :vsnprintf,
      :SDL_asprintf => :asprintf,
      :SDL_vasprintf => :vasprintf,
      :SDL_acos => :acos,
      :SDL_acosf => :acosf,
      :SDL_asin => :asin,
      :SDL_asinf => :asinf,
      :SDL_atan => :atan,
      :SDL_atanf => :atanf,
      :SDL_atan2 => :atan2,
      :SDL_atan2f => :atan2f,
      :SDL_ceil => :ceil,
      :SDL_ceilf => :ceilf,
      :SDL_copysign => :copysign,
      :SDL_copysignf => :copysignf,
      :SDL_cos => :cos,
      :SDL_cosf => :cosf,
      :SDL_exp => :exp,
      :SDL_expf => :expf,
      :SDL_fabs => :fabs,
      :SDL_fabsf => :fabsf,
      :SDL_floor => :floor,
      :SDL_floorf => :floorf,
      :SDL_trunc => :trunc,
      :SDL_truncf => :truncf,
      :SDL_fmod => :fmod,
      :SDL_fmodf => :fmodf,
      :SDL_log => :log,
      :SDL_logf => :logf,
      :SDL_log10 => :log10,
      :SDL_log10f => :log10f,
      :SDL_pow => :pow,
      :SDL_powf => :powf,
      :SDL_round => :round,
      :SDL_roundf => :roundf,
      :SDL_lround => :lround,
      :SDL_lroundf => :lroundf,
      :SDL_scalbn => :scalbn,
      :SDL_scalbnf => :scalbnf,
      :SDL_sin => :sin,
      :SDL_sinf => :sinf,
      :SDL_sqrt => :sqrt,
      :SDL_sqrtf => :sqrtf,
      :SDL_tan => :tan,
      :SDL_tanf => :tanf,
      :SDL_iconv_open => :iconv_open,
      :SDL_iconv_close => :iconv_close,
      :SDL_iconv => :iconv,
      :SDL_iconv_string => :iconv_string,
    }
    args = {
      :SDL_malloc => [:ulong],
      :SDL_calloc => [:ulong, :ulong],
      :SDL_realloc => [:pointer, :ulong],
      :SDL_free => [:pointer],
      :SDL_GetOriginalMemoryFunctions => [:pointer, :pointer, :pointer, :pointer],
      :SDL_GetMemoryFunctions => [:pointer, :pointer, :pointer, :pointer],
      :SDL_SetMemoryFunctions => [:SDL_malloc_func, :SDL_calloc_func, :SDL_realloc_func, :SDL_free_func],
      :SDL_GetNumAllocations => [],
      :SDL_getenv => [:pointer],
      :SDL_setenv => [:pointer, :pointer, :int],
      :SDL_qsort => [:pointer, :ulong, :ulong, :pointer],
      :SDL_bsearch => [:pointer, :pointer, :ulong, :ulong, :pointer],
      :SDL_abs => [:int],
      :SDL_isalpha => [:int],
      :SDL_isalnum => [:int],
      :SDL_isblank => [:int],
      :SDL_iscntrl => [:int],
      :SDL_isdigit => [:int],
      :SDL_isxdigit => [:int],
      :SDL_ispunct => [:int],
      :SDL_isspace => [:int],
      :SDL_isupper => [:int],
      :SDL_islower => [:int],
      :SDL_isprint => [:int],
      :SDL_isgraph => [:int],
      :SDL_toupper => [:int],
      :SDL_tolower => [:int],
      :SDL_crc16 => [:ushort, :pointer, :ulong],
      :SDL_crc32 => [:uint, :pointer, :ulong],
      :SDL_memset => [:pointer, :int, :ulong],
      :SDL_memcpy => [:pointer, :pointer, :ulong],
      :SDL_memmove => [:pointer, :pointer, :ulong],
      :SDL_memcmp => [:pointer, :pointer, :ulong],
      :SDL_wcslen => [:pointer],
      :SDL_wcslcpy => [:pointer, :pointer, :ulong],
      :SDL_wcslcat => [:pointer, :pointer, :ulong],
      :SDL_wcsdup => [:pointer],
      :SDL_wcsstr => [:pointer, :pointer],
      :SDL_wcscmp => [:pointer, :pointer],
      :SDL_wcsncmp => [:pointer, :pointer, :ulong],
      :SDL_wcscasecmp => [:pointer, :pointer],
      :SDL_wcsncasecmp => [:pointer, :pointer, :ulong],
      :SDL_strlen => [:pointer],
      :SDL_strlcpy => [:pointer, :pointer, :ulong],
      :SDL_utf8strlcpy => [:pointer, :pointer, :ulong],
      :SDL_strlcat => [:pointer, :pointer, :ulong],
      :SDL_strdup => [:pointer],
      :SDL_strrev => [:pointer],
      :SDL_strupr => [:pointer],
      :SDL_strlwr => [:pointer],
      :SDL_strchr => [:pointer, :int],
      :SDL_strrchr => [:pointer, :int],
      :SDL_strstr => [:pointer, :pointer],
      :SDL_strcasestr => [:pointer, :pointer],
      :SDL_strtokr => [:pointer, :pointer, :pointer],
      :SDL_utf8strlen => [:pointer],
      :SDL_utf8strnlen => [:pointer, :ulong],
      :SDL_itoa => [:int, :pointer, :int],
      :SDL_uitoa => [:uint, :pointer, :int],
      :SDL_ltoa => [:long, :pointer, :int],
      :SDL_ultoa => [:ulong, :pointer, :int],
      :SDL_lltoa => [:long_long, :pointer, :int],
      :SDL_ulltoa => [:ulong_long, :pointer, :int],
      :SDL_atoi => [:pointer],
      :SDL_atof => [:pointer],
      :SDL_strtol => [:pointer, :pointer, :int],
      :SDL_strtoul => [:pointer, :pointer, :int],
      :SDL_strtoll => [:pointer, :pointer, :int],
      :SDL_strtoull => [:pointer, :pointer, :int],
      :SDL_strtod => [:pointer, :pointer],
      :SDL_strcmp => [:pointer, :pointer],
      :SDL_strncmp => [:pointer, :pointer, :ulong],
      :SDL_strcasecmp => [:pointer, :pointer],
      :SDL_strncasecmp => [:pointer, :pointer, :ulong],
      :SDL_sscanf => [:pointer, :pointer],
      :SDL_vsscanf => [:pointer, :pointer, :pointer],
      :SDL_snprintf => [:pointer, :ulong, :pointer],
      :SDL_vsnprintf => [:pointer, :ulong, :pointer, :pointer],
      :SDL_asprintf => [:pointer, :pointer],
      :SDL_vasprintf => [:pointer, :pointer, :pointer],
      :SDL_acos => [:double],
      :SDL_acosf => [:float],
      :SDL_asin => [:double],
      :SDL_asinf => [:float],
      :SDL_atan => [:double],
      :SDL_atanf => [:float],
      :SDL_atan2 => [:double, :double],
      :SDL_atan2f => [:float, :float],
      :SDL_ceil => [:double],
      :SDL_ceilf => [:float],
      :SDL_copysign => [:double, :double],
      :SDL_copysignf => [:float, :float],
      :SDL_cos => [:double],
      :SDL_cosf => [:float],
      :SDL_exp => [:double],
      :SDL_expf => [:float],
      :SDL_fabs => [:double],
      :SDL_fabsf => [:float],
      :SDL_floor => [:double],
      :SDL_floorf => [:float],
      :SDL_trunc => [:double],
      :SDL_truncf => [:float],
      :SDL_fmod => [:double, :double],
      :SDL_fmodf => [:float, :float],
      :SDL_log => [:double],
      :SDL_logf => [:float],
      :SDL_log10 => [:double],
      :SDL_log10f => [:float],
      :SDL_pow => [:double, :double],
      :SDL_powf => [:float, :float],
      :SDL_round => [:double],
      :SDL_roundf => [:float],
      :SDL_lround => [:double],
      :SDL_lroundf => [:float],
      :SDL_scalbn => [:double, :int],
      :SDL_scalbnf => [:float, :int],
      :SDL_sin => [:double],
      :SDL_sinf => [:float],
      :SDL_sqrt => [:double],
      :SDL_sqrtf => [:float],
      :SDL_tan => [:double],
      :SDL_tanf => [:float],
      :SDL_iconv_open => [:pointer, :pointer],
      :SDL_iconv_close => [:pointer],
      :SDL_iconv => [:pointer, :pointer, :pointer, :pointer, :pointer],
      :SDL_iconv_string => [:pointer, :pointer, :pointer, :ulong],
    }
    retvals = {
      :SDL_malloc => :pointer,
      :SDL_calloc => :pointer,
      :SDL_realloc => :pointer,
      :SDL_free => :void,
      :SDL_GetOriginalMemoryFunctions => :void,
      :SDL_GetMemoryFunctions => :void,
      :SDL_SetMemoryFunctions => :int,
      :SDL_GetNumAllocations => :int,
      :SDL_getenv => :pointer,
      :SDL_setenv => :int,
      :SDL_qsort => :void,
      :SDL_bsearch => :pointer,
      :SDL_abs => :int,
      :SDL_isalpha => :int,
      :SDL_isalnum => :int,
      :SDL_isblank => :int,
      :SDL_iscntrl => :int,
      :SDL_isdigit => :int,
      :SDL_isxdigit => :int,
      :SDL_ispunct => :int,
      :SDL_isspace => :int,
      :SDL_isupper => :int,
      :SDL_islower => :int,
      :SDL_isprint => :int,
      :SDL_isgraph => :int,
      :SDL_toupper => :int,
      :SDL_tolower => :int,
      :SDL_crc16 => :ushort,
      :SDL_crc32 => :uint,
      :SDL_memset => :pointer,
      :SDL_memcpy => :pointer,
      :SDL_memmove => :pointer,
      :SDL_memcmp => :int,
      :SDL_wcslen => :ulong,
      :SDL_wcslcpy => :ulong,
      :SDL_wcslcat => :ulong,
      :SDL_wcsdup => :pointer,
      :SDL_wcsstr => :pointer,
      :SDL_wcscmp => :int,
      :SDL_wcsncmp => :int,
      :SDL_wcscasecmp => :int,
      :SDL_wcsncasecmp => :int,
      :SDL_strlen => :ulong,
      :SDL_strlcpy => :ulong,
      :SDL_utf8strlcpy => :ulong,
      :SDL_strlcat => :ulong,
      :SDL_strdup => :pointer,
      :SDL_strrev => :pointer,
      :SDL_strupr => :pointer,
      :SDL_strlwr => :pointer,
      :SDL_strchr => :pointer,
      :SDL_strrchr => :pointer,
      :SDL_strstr => :pointer,
      :SDL_strcasestr => :pointer,
      :SDL_strtokr => :pointer,
      :SDL_utf8strlen => :ulong,
      :SDL_utf8strnlen => :ulong,
      :SDL_itoa => :pointer,
      :SDL_uitoa => :pointer,
      :SDL_ltoa => :pointer,
      :SDL_ultoa => :pointer,
      :SDL_lltoa => :pointer,
      :SDL_ulltoa => :pointer,
      :SDL_atoi => :int,
      :SDL_atof => :double,
      :SDL_strtol => :long,
      :SDL_strtoul => :ulong,
      :SDL_strtoll => :long_long,
      :SDL_strtoull => :ulong_long,
      :SDL_strtod => :double,
      :SDL_strcmp => :int,
      :SDL_strncmp => :int,
      :SDL_strcasecmp => :int,
      :SDL_strncasecmp => :int,
      :SDL_sscanf => :int,
      :SDL_vsscanf => :int,
      :SDL_snprintf => :int,
      :SDL_vsnprintf => :int,
      :SDL_asprintf => :int,
      :SDL_vasprintf => :int,
      :SDL_acos => :double,
      :SDL_acosf => :float,
      :SDL_asin => :double,
      :SDL_asinf => :float,
      :SDL_atan => :double,
      :SDL_atanf => :float,
      :SDL_atan2 => :double,
      :SDL_atan2f => :float,
      :SDL_ceil => :double,
      :SDL_ceilf => :float,
      :SDL_copysign => :double,
      :SDL_copysignf => :float,
      :SDL_cos => :double,
      :SDL_cosf => :float,
      :SDL_exp => :double,
      :SDL_expf => :float,
      :SDL_fabs => :double,
      :SDL_fabsf => :float,
      :SDL_floor => :double,
      :SDL_floorf => :float,
      :SDL_trunc => :double,
      :SDL_truncf => :float,
      :SDL_fmod => :double,
      :SDL_fmodf => :float,
      :SDL_log => :double,
      :SDL_logf => :float,
      :SDL_log10 => :double,
      :SDL_log10f => :float,
      :SDL_pow => :double,
      :SDL_powf => :float,
      :SDL_round => :double,
      :SDL_roundf => :float,
      :SDL_lround => :long,
      :SDL_lroundf => :long,
      :SDL_scalbn => :double,
      :SDL_scalbnf => :float,
      :SDL_sin => :double,
      :SDL_sinf => :float,
      :SDL_sqrt => :double,
      :SDL_sqrtf => :float,
      :SDL_tan => :double,
      :SDL_tanf => :float,
      :SDL_iconv_open => :pointer,
      :SDL_iconv_close => :int,
      :SDL_iconv => :ulong,
      :SDL_iconv_string => :pointer,
    }
    symbols.each do |sym|
      begin
        attach_function apis[sym], sym, args[sym], retvals[sym]
      rescue FFI::NotFoundError => error
        $stderr.puts("[Warning] Failed to import #{sym} (#{error}).") if output_error
      end
    end
  end

end

