
#line 1 "../gen/tmpl/lib.c"
/*
  gsl_const.c
  Ruby/Numo::GSL - GSL wrapper for Ruby/Numo::NArray

  created on: 2017-03-11
  Copyright (C) 2017 Masahiro Tanaka
*/

#include <ruby.h>
#include <assert.h>
#include "numo/narray.h"
#include "numo/template.h"
#include "../numo_gsl.h"
#line 15 "../gen/tmpl/lib.c"
#include <gsl/gsl_const.h>

#line 18 "../gen/tmpl/lib.c"
static VALUE mGSL;



#line 1 "../gen/tmpl/module.c"
/*
  module definition: Numo::GSL::Const
*/

#line 6 "../gen/tmpl/module.c"
static VALUE mConst;


























































































































































































































































































































































































































#line 28 "../gen/tmpl/lib.c"
void
Init_const(void)
{
    VALUE mN;
    mN = rb_define_module("Numo");
    mGSL = rb_define_module_under(mN, "GSL");

    


#line 1 "../gen/tmpl/init_module.c"

    /*
      Document-module: Numo::GSL::Const
      
    */
    {
    
    mConst = rb_define_module_under(mGSL, "Const");
    
    
    /**/
    rb_define_const(mConst,"CGSM_ACRE",DBL2NUM(GSL_CONST_CGSM_ACRE));
    /**/
    rb_define_const(mConst,"CGSM_ANGSTROM",DBL2NUM(GSL_CONST_CGSM_ANGSTROM));
    /**/
    rb_define_const(mConst,"CGSM_ASTRONOMICAL_UNIT",DBL2NUM(GSL_CONST_CGSM_ASTRONOMICAL_UNIT));
    /**/
    rb_define_const(mConst,"CGSM_BAR",DBL2NUM(GSL_CONST_CGSM_BAR));
    /**/
    rb_define_const(mConst,"CGSM_BARN",DBL2NUM(GSL_CONST_CGSM_BARN));
    /**/
    rb_define_const(mConst,"CGSM_BOHR_MAGNETON",DBL2NUM(GSL_CONST_CGSM_BOHR_MAGNETON));
    /**/
    rb_define_const(mConst,"CGSM_BOHR_RADIUS",DBL2NUM(GSL_CONST_CGSM_BOHR_RADIUS));
    /**/
    rb_define_const(mConst,"CGSM_BOLTZMANN",DBL2NUM(GSL_CONST_CGSM_BOLTZMANN));
    /**/
    rb_define_const(mConst,"CGSM_BTU",DBL2NUM(GSL_CONST_CGSM_BTU));
    /**/
    rb_define_const(mConst,"CGSM_CALORIE",DBL2NUM(GSL_CONST_CGSM_CALORIE));
    /**/
    rb_define_const(mConst,"CGSM_CANADIAN_GALLON",DBL2NUM(GSL_CONST_CGSM_CANADIAN_GALLON));
    /**/
    rb_define_const(mConst,"CGSM_CARAT",DBL2NUM(GSL_CONST_CGSM_CARAT));
    /**/
    rb_define_const(mConst,"CGSM_CUP",DBL2NUM(GSL_CONST_CGSM_CUP));
    /**/
    rb_define_const(mConst,"CGSM_CURIE",DBL2NUM(GSL_CONST_CGSM_CURIE));
    /**/
    rb_define_const(mConst,"CGSM_DAY",DBL2NUM(GSL_CONST_CGSM_DAY));
    /**/
    rb_define_const(mConst,"CGSM_DYNE",DBL2NUM(GSL_CONST_CGSM_DYNE));
    /**/
    rb_define_const(mConst,"CGSM_ELECTRON_CHARGE",DBL2NUM(GSL_CONST_CGSM_ELECTRON_CHARGE));
    /**/
    rb_define_const(mConst,"CGSM_ELECTRON_MAGNETIC_MOMENT",DBL2NUM(GSL_CONST_CGSM_ELECTRON_MAGNETIC_MOMENT));
    /**/
    rb_define_const(mConst,"CGSM_ELECTRON_VOLT",DBL2NUM(GSL_CONST_CGSM_ELECTRON_VOLT));
    /**/
    rb_define_const(mConst,"CGSM_ERG",DBL2NUM(GSL_CONST_CGSM_ERG));
    /**/
    rb_define_const(mConst,"CGSM_FARADAY",DBL2NUM(GSL_CONST_CGSM_FARADAY));
    /**/
    rb_define_const(mConst,"CGSM_FATHOM",DBL2NUM(GSL_CONST_CGSM_FATHOM));
    /**/
    rb_define_const(mConst,"CGSM_FLUID_OUNCE",DBL2NUM(GSL_CONST_CGSM_FLUID_OUNCE));
    /**/
    rb_define_const(mConst,"CGSM_FOOT",DBL2NUM(GSL_CONST_CGSM_FOOT));
    /**/
    rb_define_const(mConst,"CGSM_FOOTCANDLE",DBL2NUM(GSL_CONST_CGSM_FOOTCANDLE));
    /**/
    rb_define_const(mConst,"CGSM_FOOTLAMBERT",DBL2NUM(GSL_CONST_CGSM_FOOTLAMBERT));
    /**/
    rb_define_const(mConst,"CGSM_GRAM_FORCE",DBL2NUM(GSL_CONST_CGSM_GRAM_FORCE));
    /**/
    rb_define_const(mConst,"CGSM_GRAVITATIONAL_CONSTANT",DBL2NUM(GSL_CONST_CGSM_GRAVITATIONAL_CONSTANT));
    /**/
    rb_define_const(mConst,"CGSM_GRAV_ACCEL",DBL2NUM(GSL_CONST_CGSM_GRAV_ACCEL));
    /**/
    rb_define_const(mConst,"CGSM_HECTARE",DBL2NUM(GSL_CONST_CGSM_HECTARE));
    /**/
    rb_define_const(mConst,"CGSM_HORSEPOWER",DBL2NUM(GSL_CONST_CGSM_HORSEPOWER));
    /**/
    rb_define_const(mConst,"CGSM_HOUR",DBL2NUM(GSL_CONST_CGSM_HOUR));
    /**/
    rb_define_const(mConst,"CGSM_INCH",DBL2NUM(GSL_CONST_CGSM_INCH));
    /**/
    rb_define_const(mConst,"CGSM_INCH_OF_MERCURY",DBL2NUM(GSL_CONST_CGSM_INCH_OF_MERCURY));
    /**/
    rb_define_const(mConst,"CGSM_INCH_OF_WATER",DBL2NUM(GSL_CONST_CGSM_INCH_OF_WATER));
    /**/
    rb_define_const(mConst,"CGSM_JOULE",DBL2NUM(GSL_CONST_CGSM_JOULE));
    /**/
    rb_define_const(mConst,"CGSM_KILOMETERS_PER_HOUR",DBL2NUM(GSL_CONST_CGSM_KILOMETERS_PER_HOUR));
    /**/
    rb_define_const(mConst,"CGSM_KILOPOUND_FORCE",DBL2NUM(GSL_CONST_CGSM_KILOPOUND_FORCE));
    /**/
    rb_define_const(mConst,"CGSM_KNOT",DBL2NUM(GSL_CONST_CGSM_KNOT));
    /**/
    rb_define_const(mConst,"CGSM_LAMBERT",DBL2NUM(GSL_CONST_CGSM_LAMBERT));
    /**/
    rb_define_const(mConst,"CGSM_LIGHT_YEAR",DBL2NUM(GSL_CONST_CGSM_LIGHT_YEAR));
    /**/
    rb_define_const(mConst,"CGSM_LITER",DBL2NUM(GSL_CONST_CGSM_LITER));
    /**/
    rb_define_const(mConst,"CGSM_LUMEN",DBL2NUM(GSL_CONST_CGSM_LUMEN));
    /**/
    rb_define_const(mConst,"CGSM_LUX",DBL2NUM(GSL_CONST_CGSM_LUX));
    /**/
    rb_define_const(mConst,"CGSM_MASS_ELECTRON",DBL2NUM(GSL_CONST_CGSM_MASS_ELECTRON));
    /**/
    rb_define_const(mConst,"CGSM_MASS_MUON",DBL2NUM(GSL_CONST_CGSM_MASS_MUON));
    /**/
    rb_define_const(mConst,"CGSM_MASS_NEUTRON",DBL2NUM(GSL_CONST_CGSM_MASS_NEUTRON));
    /**/
    rb_define_const(mConst,"CGSM_MASS_PROTON",DBL2NUM(GSL_CONST_CGSM_MASS_PROTON));
    /**/
    rb_define_const(mConst,"CGSM_METER_OF_MERCURY",DBL2NUM(GSL_CONST_CGSM_METER_OF_MERCURY));
    /**/
    rb_define_const(mConst,"CGSM_METRIC_TON",DBL2NUM(GSL_CONST_CGSM_METRIC_TON));
    /**/
    rb_define_const(mConst,"CGSM_MICRON",DBL2NUM(GSL_CONST_CGSM_MICRON));
    /**/
    rb_define_const(mConst,"CGSM_MIL",DBL2NUM(GSL_CONST_CGSM_MIL));
    /**/
    rb_define_const(mConst,"CGSM_MILE",DBL2NUM(GSL_CONST_CGSM_MILE));
    /**/
    rb_define_const(mConst,"CGSM_MILES_PER_HOUR",DBL2NUM(GSL_CONST_CGSM_MILES_PER_HOUR));
    /**/
    rb_define_const(mConst,"CGSM_MINUTE",DBL2NUM(GSL_CONST_CGSM_MINUTE));
    /**/
    rb_define_const(mConst,"CGSM_MOLAR_GAS",DBL2NUM(GSL_CONST_CGSM_MOLAR_GAS));
    /**/
    rb_define_const(mConst,"CGSM_NAUTICAL_MILE",DBL2NUM(GSL_CONST_CGSM_NAUTICAL_MILE));
    /**/
    rb_define_const(mConst,"CGSM_NEWTON",DBL2NUM(GSL_CONST_CGSM_NEWTON));
    /**/
    rb_define_const(mConst,"CGSM_NUCLEAR_MAGNETON",DBL2NUM(GSL_CONST_CGSM_NUCLEAR_MAGNETON));
    /**/
    rb_define_const(mConst,"CGSM_OUNCE_MASS",DBL2NUM(GSL_CONST_CGSM_OUNCE_MASS));
    /**/
    rb_define_const(mConst,"CGSM_PARSEC",DBL2NUM(GSL_CONST_CGSM_PARSEC));
    /**/
    rb_define_const(mConst,"CGSM_PHOT",DBL2NUM(GSL_CONST_CGSM_PHOT));
    /**/
    rb_define_const(mConst,"CGSM_PINT",DBL2NUM(GSL_CONST_CGSM_PINT));
    /**/
    rb_define_const(mConst,"CGSM_PLANCKS_CONSTANT_H",DBL2NUM(GSL_CONST_CGSM_PLANCKS_CONSTANT_H));
    /**/
    rb_define_const(mConst,"CGSM_PLANCKS_CONSTANT_HBAR",DBL2NUM(GSL_CONST_CGSM_PLANCKS_CONSTANT_HBAR));
    /**/
    rb_define_const(mConst,"CGSM_POINT",DBL2NUM(GSL_CONST_CGSM_POINT));
    /**/
    rb_define_const(mConst,"CGSM_POISE",DBL2NUM(GSL_CONST_CGSM_POISE));
    /**/
    rb_define_const(mConst,"CGSM_POUNDAL",DBL2NUM(GSL_CONST_CGSM_POUNDAL));
    /**/
    rb_define_const(mConst,"CGSM_POUND_FORCE",DBL2NUM(GSL_CONST_CGSM_POUND_FORCE));
    /**/
    rb_define_const(mConst,"CGSM_POUND_MASS",DBL2NUM(GSL_CONST_CGSM_POUND_MASS));
    /**/
    rb_define_const(mConst,"CGSM_PROTON_MAGNETIC_MOMENT",DBL2NUM(GSL_CONST_CGSM_PROTON_MAGNETIC_MOMENT));
    /**/
    rb_define_const(mConst,"CGSM_PSI",DBL2NUM(GSL_CONST_CGSM_PSI));
    /**/
    rb_define_const(mConst,"CGSM_QUART",DBL2NUM(GSL_CONST_CGSM_QUART));
    /**/
    rb_define_const(mConst,"CGSM_RAD",DBL2NUM(GSL_CONST_CGSM_RAD));
    /**/
    rb_define_const(mConst,"CGSM_ROENTGEN",DBL2NUM(GSL_CONST_CGSM_ROENTGEN));
    /**/
    rb_define_const(mConst,"CGSM_RYDBERG",DBL2NUM(GSL_CONST_CGSM_RYDBERG));
    /**/
    rb_define_const(mConst,"CGSM_SOLAR_MASS",DBL2NUM(GSL_CONST_CGSM_SOLAR_MASS));
    /**/
    rb_define_const(mConst,"CGSM_SPEED_OF_LIGHT",DBL2NUM(GSL_CONST_CGSM_SPEED_OF_LIGHT));
    /**/
    rb_define_const(mConst,"CGSM_STANDARD_GAS_VOLUME",DBL2NUM(GSL_CONST_CGSM_STANDARD_GAS_VOLUME));
    /**/
    rb_define_const(mConst,"CGSM_STD_ATMOSPHERE",DBL2NUM(GSL_CONST_CGSM_STD_ATMOSPHERE));
    /**/
    rb_define_const(mConst,"CGSM_STEFAN_BOLTZMANN_CONSTANT",DBL2NUM(GSL_CONST_CGSM_STEFAN_BOLTZMANN_CONSTANT));
    /**/
    rb_define_const(mConst,"CGSM_STILB",DBL2NUM(GSL_CONST_CGSM_STILB));
    /**/
    rb_define_const(mConst,"CGSM_STOKES",DBL2NUM(GSL_CONST_CGSM_STOKES));
    /**/
    rb_define_const(mConst,"CGSM_TABLESPOON",DBL2NUM(GSL_CONST_CGSM_TABLESPOON));
    /**/
    rb_define_const(mConst,"CGSM_TEASPOON",DBL2NUM(GSL_CONST_CGSM_TEASPOON));
    /**/
    rb_define_const(mConst,"CGSM_TEXPOINT",DBL2NUM(GSL_CONST_CGSM_TEXPOINT));
    /**/
    rb_define_const(mConst,"CGSM_THERM",DBL2NUM(GSL_CONST_CGSM_THERM));
    /**/
    rb_define_const(mConst,"CGSM_THOMSON_CROSS_SECTION",DBL2NUM(GSL_CONST_CGSM_THOMSON_CROSS_SECTION));
    /**/
    rb_define_const(mConst,"CGSM_TON",DBL2NUM(GSL_CONST_CGSM_TON));
    /**/
    rb_define_const(mConst,"CGSM_TORR",DBL2NUM(GSL_CONST_CGSM_TORR));
    /**/
    rb_define_const(mConst,"CGSM_TROY_OUNCE",DBL2NUM(GSL_CONST_CGSM_TROY_OUNCE));
    /**/
    rb_define_const(mConst,"CGSM_UK_GALLON",DBL2NUM(GSL_CONST_CGSM_UK_GALLON));
    /**/
    rb_define_const(mConst,"CGSM_UK_TON",DBL2NUM(GSL_CONST_CGSM_UK_TON));
    /**/
    rb_define_const(mConst,"CGSM_UNIFIED_ATOMIC_MASS",DBL2NUM(GSL_CONST_CGSM_UNIFIED_ATOMIC_MASS));
    /**/
    rb_define_const(mConst,"CGSM_US_GALLON",DBL2NUM(GSL_CONST_CGSM_US_GALLON));
    /**/
    rb_define_const(mConst,"CGSM_WEEK",DBL2NUM(GSL_CONST_CGSM_WEEK));
    /**/
    rb_define_const(mConst,"CGSM_YARD",DBL2NUM(GSL_CONST_CGSM_YARD));
    /**/
    rb_define_const(mConst,"CGS_ACRE",DBL2NUM(GSL_CONST_CGS_ACRE));
    /**/
    rb_define_const(mConst,"CGS_ANGSTROM",DBL2NUM(GSL_CONST_CGS_ANGSTROM));
    /**/
    rb_define_const(mConst,"CGS_ASTRONOMICAL_UNIT",DBL2NUM(GSL_CONST_CGS_ASTRONOMICAL_UNIT));
    /**/
    rb_define_const(mConst,"CGS_BAR",DBL2NUM(GSL_CONST_CGS_BAR));
    /**/
    rb_define_const(mConst,"CGS_BARN",DBL2NUM(GSL_CONST_CGS_BARN));
    /**/
    rb_define_const(mConst,"CGS_BOHR_RADIUS",DBL2NUM(GSL_CONST_CGS_BOHR_RADIUS));
    /**/
    rb_define_const(mConst,"CGS_BOLTZMANN",DBL2NUM(GSL_CONST_CGS_BOLTZMANN));
    /**/
    rb_define_const(mConst,"CGS_BTU",DBL2NUM(GSL_CONST_CGS_BTU));
    /**/
    rb_define_const(mConst,"CGS_CALORIE",DBL2NUM(GSL_CONST_CGS_CALORIE));
    /**/
    rb_define_const(mConst,"CGS_CANADIAN_GALLON",DBL2NUM(GSL_CONST_CGS_CANADIAN_GALLON));
    /**/
    rb_define_const(mConst,"CGS_CARAT",DBL2NUM(GSL_CONST_CGS_CARAT));
    /**/
    rb_define_const(mConst,"CGS_CUP",DBL2NUM(GSL_CONST_CGS_CUP));
    /**/
    rb_define_const(mConst,"CGS_CURIE",DBL2NUM(GSL_CONST_CGS_CURIE));
    /**/
    rb_define_const(mConst,"CGS_DAY",DBL2NUM(GSL_CONST_CGS_DAY));
    /**/
    rb_define_const(mConst,"CGS_DYNE",DBL2NUM(GSL_CONST_CGS_DYNE));
    /**/
    rb_define_const(mConst,"CGS_ELECTRON_VOLT",DBL2NUM(GSL_CONST_CGS_ELECTRON_VOLT));
    /**/
    rb_define_const(mConst,"CGS_ERG",DBL2NUM(GSL_CONST_CGS_ERG));
    /**/
    rb_define_const(mConst,"CGS_FATHOM",DBL2NUM(GSL_CONST_CGS_FATHOM));
    /**/
    rb_define_const(mConst,"CGS_FLUID_OUNCE",DBL2NUM(GSL_CONST_CGS_FLUID_OUNCE));
    /**/
    rb_define_const(mConst,"CGS_FOOT",DBL2NUM(GSL_CONST_CGS_FOOT));
    /**/
    rb_define_const(mConst,"CGS_FOOTCANDLE",DBL2NUM(GSL_CONST_CGS_FOOTCANDLE));
    /**/
    rb_define_const(mConst,"CGS_FOOTLAMBERT",DBL2NUM(GSL_CONST_CGS_FOOTLAMBERT));
    /**/
    rb_define_const(mConst,"CGS_GRAM_FORCE",DBL2NUM(GSL_CONST_CGS_GRAM_FORCE));
    /**/
    rb_define_const(mConst,"CGS_GRAVITATIONAL_CONSTANT",DBL2NUM(GSL_CONST_CGS_GRAVITATIONAL_CONSTANT));
    /**/
    rb_define_const(mConst,"CGS_GRAV_ACCEL",DBL2NUM(GSL_CONST_CGS_GRAV_ACCEL));
    /**/
    rb_define_const(mConst,"CGS_HECTARE",DBL2NUM(GSL_CONST_CGS_HECTARE));
    /**/
    rb_define_const(mConst,"CGS_HORSEPOWER",DBL2NUM(GSL_CONST_CGS_HORSEPOWER));
    /**/
    rb_define_const(mConst,"CGS_HOUR",DBL2NUM(GSL_CONST_CGS_HOUR));
    /**/
    rb_define_const(mConst,"CGS_INCH",DBL2NUM(GSL_CONST_CGS_INCH));
    /**/
    rb_define_const(mConst,"CGS_INCH_OF_MERCURY",DBL2NUM(GSL_CONST_CGS_INCH_OF_MERCURY));
    /**/
    rb_define_const(mConst,"CGS_INCH_OF_WATER",DBL2NUM(GSL_CONST_CGS_INCH_OF_WATER));
    /**/
    rb_define_const(mConst,"CGS_JOULE",DBL2NUM(GSL_CONST_CGS_JOULE));
    /**/
    rb_define_const(mConst,"CGS_KILOMETERS_PER_HOUR",DBL2NUM(GSL_CONST_CGS_KILOMETERS_PER_HOUR));
    /**/
    rb_define_const(mConst,"CGS_KILOPOUND_FORCE",DBL2NUM(GSL_CONST_CGS_KILOPOUND_FORCE));
    /**/
    rb_define_const(mConst,"CGS_KNOT",DBL2NUM(GSL_CONST_CGS_KNOT));
    /**/
    rb_define_const(mConst,"CGS_LAMBERT",DBL2NUM(GSL_CONST_CGS_LAMBERT));
    /**/
    rb_define_const(mConst,"CGS_LIGHT_YEAR",DBL2NUM(GSL_CONST_CGS_LIGHT_YEAR));
    /**/
    rb_define_const(mConst,"CGS_LITER",DBL2NUM(GSL_CONST_CGS_LITER));
    /**/
    rb_define_const(mConst,"CGS_LUMEN",DBL2NUM(GSL_CONST_CGS_LUMEN));
    /**/
    rb_define_const(mConst,"CGS_LUX",DBL2NUM(GSL_CONST_CGS_LUX));
    /**/
    rb_define_const(mConst,"CGS_MASS_ELECTRON",DBL2NUM(GSL_CONST_CGS_MASS_ELECTRON));
    /**/
    rb_define_const(mConst,"CGS_MASS_MUON",DBL2NUM(GSL_CONST_CGS_MASS_MUON));
    /**/
    rb_define_const(mConst,"CGS_MASS_NEUTRON",DBL2NUM(GSL_CONST_CGS_MASS_NEUTRON));
    /**/
    rb_define_const(mConst,"CGS_MASS_PROTON",DBL2NUM(GSL_CONST_CGS_MASS_PROTON));
    /**/
    rb_define_const(mConst,"CGS_METER_OF_MERCURY",DBL2NUM(GSL_CONST_CGS_METER_OF_MERCURY));
    /**/
    rb_define_const(mConst,"CGS_METRIC_TON",DBL2NUM(GSL_CONST_CGS_METRIC_TON));
    /**/
    rb_define_const(mConst,"CGS_MICRON",DBL2NUM(GSL_CONST_CGS_MICRON));
    /**/
    rb_define_const(mConst,"CGS_MIL",DBL2NUM(GSL_CONST_CGS_MIL));
    /**/
    rb_define_const(mConst,"CGS_MILE",DBL2NUM(GSL_CONST_CGS_MILE));
    /**/
    rb_define_const(mConst,"CGS_MILES_PER_HOUR",DBL2NUM(GSL_CONST_CGS_MILES_PER_HOUR));
    /**/
    rb_define_const(mConst,"CGS_MINUTE",DBL2NUM(GSL_CONST_CGS_MINUTE));
    /**/
    rb_define_const(mConst,"CGS_MOLAR_GAS",DBL2NUM(GSL_CONST_CGS_MOLAR_GAS));
    /**/
    rb_define_const(mConst,"CGS_NAUTICAL_MILE",DBL2NUM(GSL_CONST_CGS_NAUTICAL_MILE));
    /**/
    rb_define_const(mConst,"CGS_NEWTON",DBL2NUM(GSL_CONST_CGS_NEWTON));
    /**/
    rb_define_const(mConst,"CGS_OUNCE_MASS",DBL2NUM(GSL_CONST_CGS_OUNCE_MASS));
    /**/
    rb_define_const(mConst,"CGS_PARSEC",DBL2NUM(GSL_CONST_CGS_PARSEC));
    /**/
    rb_define_const(mConst,"CGS_PHOT",DBL2NUM(GSL_CONST_CGS_PHOT));
    /**/
    rb_define_const(mConst,"CGS_PINT",DBL2NUM(GSL_CONST_CGS_PINT));
    /**/
    rb_define_const(mConst,"CGS_PLANCKS_CONSTANT_H",DBL2NUM(GSL_CONST_CGS_PLANCKS_CONSTANT_H));
    /**/
    rb_define_const(mConst,"CGS_PLANCKS_CONSTANT_HBAR",DBL2NUM(GSL_CONST_CGS_PLANCKS_CONSTANT_HBAR));
    /**/
    rb_define_const(mConst,"CGS_POINT",DBL2NUM(GSL_CONST_CGS_POINT));
    /**/
    rb_define_const(mConst,"CGS_POISE",DBL2NUM(GSL_CONST_CGS_POISE));
    /**/
    rb_define_const(mConst,"CGS_POUNDAL",DBL2NUM(GSL_CONST_CGS_POUNDAL));
    /**/
    rb_define_const(mConst,"CGS_POUND_FORCE",DBL2NUM(GSL_CONST_CGS_POUND_FORCE));
    /**/
    rb_define_const(mConst,"CGS_POUND_MASS",DBL2NUM(GSL_CONST_CGS_POUND_MASS));
    /**/
    rb_define_const(mConst,"CGS_PSI",DBL2NUM(GSL_CONST_CGS_PSI));
    /**/
    rb_define_const(mConst,"CGS_QUART",DBL2NUM(GSL_CONST_CGS_QUART));
    /**/
    rb_define_const(mConst,"CGS_RAD",DBL2NUM(GSL_CONST_CGS_RAD));
    /**/
    rb_define_const(mConst,"CGS_ROENTGEN",DBL2NUM(GSL_CONST_CGS_ROENTGEN));
    /**/
    rb_define_const(mConst,"CGS_RYDBERG",DBL2NUM(GSL_CONST_CGS_RYDBERG));
    /**/
    rb_define_const(mConst,"CGS_SOLAR_MASS",DBL2NUM(GSL_CONST_CGS_SOLAR_MASS));
    /**/
    rb_define_const(mConst,"CGS_SPEED_OF_LIGHT",DBL2NUM(GSL_CONST_CGS_SPEED_OF_LIGHT));
    /**/
    rb_define_const(mConst,"CGS_STANDARD_GAS_VOLUME",DBL2NUM(GSL_CONST_CGS_STANDARD_GAS_VOLUME));
    /**/
    rb_define_const(mConst,"CGS_STD_ATMOSPHERE",DBL2NUM(GSL_CONST_CGS_STD_ATMOSPHERE));
    /**/
    rb_define_const(mConst,"CGS_STEFAN_BOLTZMANN_CONSTANT",DBL2NUM(GSL_CONST_CGS_STEFAN_BOLTZMANN_CONSTANT));
    /**/
    rb_define_const(mConst,"CGS_STILB",DBL2NUM(GSL_CONST_CGS_STILB));
    /**/
    rb_define_const(mConst,"CGS_STOKES",DBL2NUM(GSL_CONST_CGS_STOKES));
    /**/
    rb_define_const(mConst,"CGS_TABLESPOON",DBL2NUM(GSL_CONST_CGS_TABLESPOON));
    /**/
    rb_define_const(mConst,"CGS_TEASPOON",DBL2NUM(GSL_CONST_CGS_TEASPOON));
    /**/
    rb_define_const(mConst,"CGS_TEXPOINT",DBL2NUM(GSL_CONST_CGS_TEXPOINT));
    /**/
    rb_define_const(mConst,"CGS_THERM",DBL2NUM(GSL_CONST_CGS_THERM));
    /**/
    rb_define_const(mConst,"CGS_THOMSON_CROSS_SECTION",DBL2NUM(GSL_CONST_CGS_THOMSON_CROSS_SECTION));
    /**/
    rb_define_const(mConst,"CGS_TON",DBL2NUM(GSL_CONST_CGS_TON));
    /**/
    rb_define_const(mConst,"CGS_TORR",DBL2NUM(GSL_CONST_CGS_TORR));
    /**/
    rb_define_const(mConst,"CGS_TROY_OUNCE",DBL2NUM(GSL_CONST_CGS_TROY_OUNCE));
    /**/
    rb_define_const(mConst,"CGS_UK_GALLON",DBL2NUM(GSL_CONST_CGS_UK_GALLON));
    /**/
    rb_define_const(mConst,"CGS_UK_TON",DBL2NUM(GSL_CONST_CGS_UK_TON));
    /**/
    rb_define_const(mConst,"CGS_UNIFIED_ATOMIC_MASS",DBL2NUM(GSL_CONST_CGS_UNIFIED_ATOMIC_MASS));
    /**/
    rb_define_const(mConst,"CGS_US_GALLON",DBL2NUM(GSL_CONST_CGS_US_GALLON));
    /**/
    rb_define_const(mConst,"CGS_WEEK",DBL2NUM(GSL_CONST_CGS_WEEK));
    /**/
    rb_define_const(mConst,"CGS_YARD",DBL2NUM(GSL_CONST_CGS_YARD));
    /*The area of 1 acre. */
    rb_define_const(mConst,"MKSA_ACRE",DBL2NUM(GSL_CONST_MKSA_ACRE));
    /*The length of 1 angstrom. */
    rb_define_const(mConst,"MKSA_ANGSTROM",DBL2NUM(GSL_CONST_MKSA_ANGSTROM));
    /*The length of 1 astronomical unit (mean earth-sun distance), au. */
    rb_define_const(mConst,"MKSA_ASTRONOMICAL_UNIT",DBL2NUM(GSL_CONST_MKSA_ASTRONOMICAL_UNIT));
    /*The pressure of 1 bar. */
    rb_define_const(mConst,"MKSA_BAR",DBL2NUM(GSL_CONST_MKSA_BAR));
    /*The area of 1 barn. */
    rb_define_const(mConst,"MKSA_BARN",DBL2NUM(GSL_CONST_MKSA_BARN));
    /*The Bohr Magneton, \mu_B. */
    rb_define_const(mConst,"MKSA_BOHR_MAGNETON",DBL2NUM(GSL_CONST_MKSA_BOHR_MAGNETON));
    /*The Bohr radius, a_0. */
    rb_define_const(mConst,"MKSA_BOHR_RADIUS",DBL2NUM(GSL_CONST_MKSA_BOHR_RADIUS));
    /*The Boltzmann constant, k. */
    rb_define_const(mConst,"MKSA_BOLTZMANN",DBL2NUM(GSL_CONST_MKSA_BOLTZMANN));
    /*The energy of 1 British Thermal Unit, btu. */
    rb_define_const(mConst,"MKSA_BTU",DBL2NUM(GSL_CONST_MKSA_BTU));
    /*The energy of 1 calorie. */
    rb_define_const(mConst,"MKSA_CALORIE",DBL2NUM(GSL_CONST_MKSA_CALORIE));
    /*The volume of 1 Canadian gallon. */
    rb_define_const(mConst,"MKSA_CANADIAN_GALLON",DBL2NUM(GSL_CONST_MKSA_CANADIAN_GALLON));
    /*The mass of 1 carat. */
    rb_define_const(mConst,"MKSA_CARAT",DBL2NUM(GSL_CONST_MKSA_CARAT));
    /**/
    rb_define_const(mConst,"MKSA_CUP",DBL2NUM(GSL_CONST_MKSA_CUP));
    /*The activity of 1 curie. */
    rb_define_const(mConst,"MKSA_CURIE",DBL2NUM(GSL_CONST_MKSA_CURIE));
    /*The number of seconds in 1 day. */
    rb_define_const(mConst,"MKSA_DAY",DBL2NUM(GSL_CONST_MKSA_DAY));
    /*The electric dipole moment of 1 Debye, D.*/
    rb_define_const(mConst,"MKSA_DEBYE",DBL2NUM(GSL_CONST_MKSA_DEBYE));
    /*The force of 1 Dyne = $10^{-5}$ 10^-5 Newton. */
    rb_define_const(mConst,"MKSA_DYNE",DBL2NUM(GSL_CONST_MKSA_DYNE));
    /*The charge of the electron, e. */
    rb_define_const(mConst,"MKSA_ELECTRON_CHARGE",DBL2NUM(GSL_CONST_MKSA_ELECTRON_CHARGE));
    /*The absolute value of the magnetic moment of the electron, \mu_e. The physical magnetic moment of the electron is negative. */
    rb_define_const(mConst,"MKSA_ELECTRON_MAGNETIC_MOMENT",DBL2NUM(GSL_CONST_MKSA_ELECTRON_MAGNETIC_MOMENT));
    /*The energy of 1 electron volt, eV. */
    rb_define_const(mConst,"MKSA_ELECTRON_VOLT",DBL2NUM(GSL_CONST_MKSA_ELECTRON_VOLT));
    /*The energy 1 erg = $10^{-7}$  10^-7 Joule.*/
    rb_define_const(mConst,"MKSA_ERG",DBL2NUM(GSL_CONST_MKSA_ERG));
    /*The molar charge of 1 Faraday. */
    rb_define_const(mConst,"MKSA_FARADAY",DBL2NUM(GSL_CONST_MKSA_FARADAY));
    /*The length of 1 fathom. */
    rb_define_const(mConst,"MKSA_FATHOM",DBL2NUM(GSL_CONST_MKSA_FATHOM));
    /**/
    rb_define_const(mConst,"MKSA_FLUID_OUNCE",DBL2NUM(GSL_CONST_MKSA_FLUID_OUNCE));
    /*The length of 1 foot. */
    rb_define_const(mConst,"MKSA_FOOT",DBL2NUM(GSL_CONST_MKSA_FOOT));
    /*The illuminance of 1 footcandle. */
    rb_define_const(mConst,"MKSA_FOOTCANDLE",DBL2NUM(GSL_CONST_MKSA_FOOTCANDLE));
    /*The luminance of 1 footlambert.*/
    rb_define_const(mConst,"MKSA_FOOTLAMBERT",DBL2NUM(GSL_CONST_MKSA_FOOTLAMBERT));
    /*The magnetic field of 1 Gauss.*/
    rb_define_const(mConst,"MKSA_GAUSS",DBL2NUM(GSL_CONST_MKSA_GAUSS));
    /*The force of 1 gram weight. */
    rb_define_const(mConst,"MKSA_GRAM_FORCE",DBL2NUM(GSL_CONST_MKSA_GRAM_FORCE));
    /*The gravitational constant, G. */
    rb_define_const(mConst,"MKSA_GRAVITATIONAL_CONSTANT",DBL2NUM(GSL_CONST_MKSA_GRAVITATIONAL_CONSTANT));
    /*The standard gravitational acceleration on Earth, g. */
    rb_define_const(mConst,"MKSA_GRAV_ACCEL",DBL2NUM(GSL_CONST_MKSA_GRAV_ACCEL));
    /*The area of 1 hectare. */
    rb_define_const(mConst,"MKSA_HECTARE",DBL2NUM(GSL_CONST_MKSA_HECTARE));
    /*The power of 1 horsepower.*/
    rb_define_const(mConst,"MKSA_HORSEPOWER",DBL2NUM(GSL_CONST_MKSA_HORSEPOWER));
    /*The number of seconds in 1 hour. */
    rb_define_const(mConst,"MKSA_HOUR",DBL2NUM(GSL_CONST_MKSA_HOUR));
    /*The length of 1 inch. */
    rb_define_const(mConst,"MKSA_INCH",DBL2NUM(GSL_CONST_MKSA_INCH));
    /*The pressure of 1 inch of mercury. */
    rb_define_const(mConst,"MKSA_INCH_OF_MERCURY",DBL2NUM(GSL_CONST_MKSA_INCH_OF_MERCURY));
    /*The pressure of 1 inch of water. */
    rb_define_const(mConst,"MKSA_INCH_OF_WATER",DBL2NUM(GSL_CONST_MKSA_INCH_OF_WATER));
    /*The SI unit of energy, 1 Joule. */
    rb_define_const(mConst,"MKSA_JOULE",DBL2NUM(GSL_CONST_MKSA_JOULE));
    /*The speed of 1 kilometer per hour. */
    rb_define_const(mConst,"MKSA_KILOMETERS_PER_HOUR",DBL2NUM(GSL_CONST_MKSA_KILOMETERS_PER_HOUR));
    /*The force of 1 kilopound weight. */
    rb_define_const(mConst,"MKSA_KILOPOUND_FORCE",DBL2NUM(GSL_CONST_MKSA_KILOPOUND_FORCE));
    /*The speed of 1 knot.*/
    rb_define_const(mConst,"MKSA_KNOT",DBL2NUM(GSL_CONST_MKSA_KNOT));
    /*The luminance of 1 lambert. */
    rb_define_const(mConst,"MKSA_LAMBERT",DBL2NUM(GSL_CONST_MKSA_LAMBERT));
    /*The distance of 1 light-year, ly. */
    rb_define_const(mConst,"MKSA_LIGHT_YEAR",DBL2NUM(GSL_CONST_MKSA_LIGHT_YEAR));
    /*The volume of 1 liter. */
    rb_define_const(mConst,"MKSA_LITER",DBL2NUM(GSL_CONST_MKSA_LITER));
    /*The luminous flux of 1 lumen. */
    rb_define_const(mConst,"MKSA_LUMEN",DBL2NUM(GSL_CONST_MKSA_LUMEN));
    /*The illuminance of 1 lux. */
    rb_define_const(mConst,"MKSA_LUX",DBL2NUM(GSL_CONST_MKSA_LUX));
    /*The mass of the electron, m_e. */
    rb_define_const(mConst,"MKSA_MASS_ELECTRON",DBL2NUM(GSL_CONST_MKSA_MASS_ELECTRON));
    /*The mass of the muon, m_\mu. */
    rb_define_const(mConst,"MKSA_MASS_MUON",DBL2NUM(GSL_CONST_MKSA_MASS_MUON));
    /*The mass of the neutron, m_n. */
    rb_define_const(mConst,"MKSA_MASS_NEUTRON",DBL2NUM(GSL_CONST_MKSA_MASS_NEUTRON));
    /*The mass of the proton, m_p. */
    rb_define_const(mConst,"MKSA_MASS_PROTON",DBL2NUM(GSL_CONST_MKSA_MASS_PROTON));
    /*The pressure of 1 meter of mercury. */
    rb_define_const(mConst,"MKSA_METER_OF_MERCURY",DBL2NUM(GSL_CONST_MKSA_METER_OF_MERCURY));
    /*The mass of 1 metric ton (1000 kg). */
    rb_define_const(mConst,"MKSA_METRIC_TON",DBL2NUM(GSL_CONST_MKSA_METRIC_TON));
    /*The length of 1 micron. */
    rb_define_const(mConst,"MKSA_MICRON",DBL2NUM(GSL_CONST_MKSA_MICRON));
    /*The length of 1 mil (1/1000th of an inch).*/
    rb_define_const(mConst,"MKSA_MIL",DBL2NUM(GSL_CONST_MKSA_MIL));
    /*The length of 1 mile. */
    rb_define_const(mConst,"MKSA_MILE",DBL2NUM(GSL_CONST_MKSA_MILE));
    /*The speed of 1 mile per hour. */
    rb_define_const(mConst,"MKSA_MILES_PER_HOUR",DBL2NUM(GSL_CONST_MKSA_MILES_PER_HOUR));
    /*The number of seconds in 1 minute. */
    rb_define_const(mConst,"MKSA_MINUTE",DBL2NUM(GSL_CONST_MKSA_MINUTE));
    /*The molar gas constant, R_0. */
    rb_define_const(mConst,"MKSA_MOLAR_GAS",DBL2NUM(GSL_CONST_MKSA_MOLAR_GAS));
    /*The length of 1 nautical mile. */
    rb_define_const(mConst,"MKSA_NAUTICAL_MILE",DBL2NUM(GSL_CONST_MKSA_NAUTICAL_MILE));
    /*The SI unit of force, 1 Newton. */
    rb_define_const(mConst,"MKSA_NEWTON",DBL2NUM(GSL_CONST_MKSA_NEWTON));
    /*The Nuclear Magneton, \mu_N. */
    rb_define_const(mConst,"MKSA_NUCLEAR_MAGNETON",DBL2NUM(GSL_CONST_MKSA_NUCLEAR_MAGNETON));
    /*The mass of 1 ounce. */
    rb_define_const(mConst,"MKSA_OUNCE_MASS",DBL2NUM(GSL_CONST_MKSA_OUNCE_MASS));
    /*The distance of 1 parsec, pc. */
    rb_define_const(mConst,"MKSA_PARSEC",DBL2NUM(GSL_CONST_MKSA_PARSEC));
    /*The illuminance of 1 phot. */
    rb_define_const(mConst,"MKSA_PHOT",DBL2NUM(GSL_CONST_MKSA_PHOT));
    /*The volume of 1 pint.*/
    rb_define_const(mConst,"MKSA_PINT",DBL2NUM(GSL_CONST_MKSA_PINT));
    /*Planck's constant, h. */
    rb_define_const(mConst,"MKSA_PLANCKS_CONSTANT_H",DBL2NUM(GSL_CONST_MKSA_PLANCKS_CONSTANT_H));
    /*Planck's constant divided by 2\pi, \hbar. */
    rb_define_const(mConst,"MKSA_PLANCKS_CONSTANT_HBAR",DBL2NUM(GSL_CONST_MKSA_PLANCKS_CONSTANT_HBAR));
    /*The length of 1 printer's point (1/72 inch). */
    rb_define_const(mConst,"MKSA_POINT",DBL2NUM(GSL_CONST_MKSA_POINT));
    /*The dynamic viscosity of 1 poise. */
    rb_define_const(mConst,"MKSA_POISE",DBL2NUM(GSL_CONST_MKSA_POISE));
    /*The force of 1 poundal.*/
    rb_define_const(mConst,"MKSA_POUNDAL",DBL2NUM(GSL_CONST_MKSA_POUNDAL));
    /*The force of 1 pound weight. */
    rb_define_const(mConst,"MKSA_POUND_FORCE",DBL2NUM(GSL_CONST_MKSA_POUND_FORCE));
    /*The mass of 1 pound. */
    rb_define_const(mConst,"MKSA_POUND_MASS",DBL2NUM(GSL_CONST_MKSA_POUND_MASS));
    /*The magnetic moment of the proton, \mu_p. */
    rb_define_const(mConst,"MKSA_PROTON_MAGNETIC_MOMENT",DBL2NUM(GSL_CONST_MKSA_PROTON_MAGNETIC_MOMENT));
    /*The pressure of 1 pound per square inch.*/
    rb_define_const(mConst,"MKSA_PSI",DBL2NUM(GSL_CONST_MKSA_PSI));
    /*The volume of 1 quart. */
    rb_define_const(mConst,"MKSA_QUART",DBL2NUM(GSL_CONST_MKSA_QUART));
    /*The absorbed dose of 1 rad.*/
    rb_define_const(mConst,"MKSA_RAD",DBL2NUM(GSL_CONST_MKSA_RAD));
    /*The exposure of 1 roentgen. */
    rb_define_const(mConst,"MKSA_ROENTGEN",DBL2NUM(GSL_CONST_MKSA_ROENTGEN));
    /*The Rydberg constant, Ry, in units of energy.  This is related to the Rydberg inverse wavelength R_\infty by Ry = h c R_\infty. */
    rb_define_const(mConst,"MKSA_RYDBERG",DBL2NUM(GSL_CONST_MKSA_RYDBERG));
    /*The mass of the Sun.*/
    rb_define_const(mConst,"MKSA_SOLAR_MASS",DBL2NUM(GSL_CONST_MKSA_SOLAR_MASS));
    /*The speed of light in vacuum, c. */
    rb_define_const(mConst,"MKSA_SPEED_OF_LIGHT",DBL2NUM(GSL_CONST_MKSA_SPEED_OF_LIGHT));
    /*The standard gas volume, V_0. */
    rb_define_const(mConst,"MKSA_STANDARD_GAS_VOLUME",DBL2NUM(GSL_CONST_MKSA_STANDARD_GAS_VOLUME));
    /*The pressure of 1 standard atmosphere. */
    rb_define_const(mConst,"MKSA_STD_ATMOSPHERE",DBL2NUM(GSL_CONST_MKSA_STD_ATMOSPHERE));
    /*The Stefan-Boltzmann radiation constant, \sigma. */
    rb_define_const(mConst,"MKSA_STEFAN_BOLTZMANN_CONSTANT",DBL2NUM(GSL_CONST_MKSA_STEFAN_BOLTZMANN_CONSTANT));
    /*The luminance of 1 stilb. */
    rb_define_const(mConst,"MKSA_STILB",DBL2NUM(GSL_CONST_MKSA_STILB));
    /*The kinematic viscosity of 1 stokes.*/
    rb_define_const(mConst,"MKSA_STOKES",DBL2NUM(GSL_CONST_MKSA_STOKES));
    /**/
    rb_define_const(mConst,"MKSA_TABLESPOON",DBL2NUM(GSL_CONST_MKSA_TABLESPOON));
    /**/
    rb_define_const(mConst,"MKSA_TEASPOON",DBL2NUM(GSL_CONST_MKSA_TEASPOON));
    /*The length of 1 TeX point (1/72.27 inch).*/
    rb_define_const(mConst,"MKSA_TEXPOINT",DBL2NUM(GSL_CONST_MKSA_TEXPOINT));
    /*The energy of 1 Therm. */
    rb_define_const(mConst,"MKSA_THERM",DBL2NUM(GSL_CONST_MKSA_THERM));
    /*The Thomson cross section, \sigma_T. */
    rb_define_const(mConst,"MKSA_THOMSON_CROSS_SECTION",DBL2NUM(GSL_CONST_MKSA_THOMSON_CROSS_SECTION));
    /*The mass of 1 ton. */
    rb_define_const(mConst,"MKSA_TON",DBL2NUM(GSL_CONST_MKSA_TON));
    /*The pressure of 1 torr. */
    rb_define_const(mConst,"MKSA_TORR",DBL2NUM(GSL_CONST_MKSA_TORR));
    /*The mass of 1 troy ounce. */
    rb_define_const(mConst,"MKSA_TROY_OUNCE",DBL2NUM(GSL_CONST_MKSA_TROY_OUNCE));
    /*The volume of 1 UK gallon. */
    rb_define_const(mConst,"MKSA_UK_GALLON",DBL2NUM(GSL_CONST_MKSA_UK_GALLON));
    /*The mass of 1 UK ton. */
    rb_define_const(mConst,"MKSA_UK_TON",DBL2NUM(GSL_CONST_MKSA_UK_TON));
    /*The unified atomic mass, amu. */
    rb_define_const(mConst,"MKSA_UNIFIED_ATOMIC_MASS",DBL2NUM(GSL_CONST_MKSA_UNIFIED_ATOMIC_MASS));
    /*The volume of 1 US gallon. */
    rb_define_const(mConst,"MKSA_US_GALLON",DBL2NUM(GSL_CONST_MKSA_US_GALLON));
    /*The permeability of free space, \mu_0. This constant is defined in the MKSA system only. */
    rb_define_const(mConst,"MKSA_VACUUM_PERMEABILITY",DBL2NUM(GSL_CONST_MKSA_VACUUM_PERMEABILITY));
    /*The permittivity of free space, \epsilon_0.  This constant is defined in the MKSA system only. */
    rb_define_const(mConst,"MKSA_VACUUM_PERMITTIVITY",DBL2NUM(GSL_CONST_MKSA_VACUUM_PERMITTIVITY));
    /*The number of seconds in 1 week.*/
    rb_define_const(mConst,"MKSA_WEEK",DBL2NUM(GSL_CONST_MKSA_WEEK));
    /*The length of 1 yard. */
    rb_define_const(mConst,"MKSA_YARD",DBL2NUM(GSL_CONST_MKSA_YARD));
    /**/
    rb_define_const(mConst,"MKS_ACRE",DBL2NUM(GSL_CONST_MKS_ACRE));
    /**/
    rb_define_const(mConst,"MKS_ANGSTROM",DBL2NUM(GSL_CONST_MKS_ANGSTROM));
    /**/
    rb_define_const(mConst,"MKS_ASTRONOMICAL_UNIT",DBL2NUM(GSL_CONST_MKS_ASTRONOMICAL_UNIT));
    /**/
    rb_define_const(mConst,"MKS_BAR",DBL2NUM(GSL_CONST_MKS_BAR));
    /**/
    rb_define_const(mConst,"MKS_BARN",DBL2NUM(GSL_CONST_MKS_BARN));
    /**/
    rb_define_const(mConst,"MKS_BOHR_MAGNETON",DBL2NUM(GSL_CONST_MKS_BOHR_MAGNETON));
    /**/
    rb_define_const(mConst,"MKS_BOHR_RADIUS",DBL2NUM(GSL_CONST_MKS_BOHR_RADIUS));
    /**/
    rb_define_const(mConst,"MKS_BOLTZMANN",DBL2NUM(GSL_CONST_MKS_BOLTZMANN));
    /**/
    rb_define_const(mConst,"MKS_BTU",DBL2NUM(GSL_CONST_MKS_BTU));
    /**/
    rb_define_const(mConst,"MKS_CALORIE",DBL2NUM(GSL_CONST_MKS_CALORIE));
    /**/
    rb_define_const(mConst,"MKS_CANADIAN_GALLON",DBL2NUM(GSL_CONST_MKS_CANADIAN_GALLON));
    /**/
    rb_define_const(mConst,"MKS_CARAT",DBL2NUM(GSL_CONST_MKS_CARAT));
    /**/
    rb_define_const(mConst,"MKS_CUP",DBL2NUM(GSL_CONST_MKS_CUP));
    /**/
    rb_define_const(mConst,"MKS_CURIE",DBL2NUM(GSL_CONST_MKS_CURIE));
    /**/
    rb_define_const(mConst,"MKS_DAY",DBL2NUM(GSL_CONST_MKS_DAY));
    /**/
    rb_define_const(mConst,"MKS_DEBYE",DBL2NUM(GSL_CONST_MKS_DEBYE));
    /**/
    rb_define_const(mConst,"MKS_DYNE",DBL2NUM(GSL_CONST_MKS_DYNE));
    /**/
    rb_define_const(mConst,"MKS_ELECTRON_CHARGE",DBL2NUM(GSL_CONST_MKS_ELECTRON_CHARGE));
    /**/
    rb_define_const(mConst,"MKS_ELECTRON_MAGNETIC_MOMENT",DBL2NUM(GSL_CONST_MKS_ELECTRON_MAGNETIC_MOMENT));
    /**/
    rb_define_const(mConst,"MKS_ELECTRON_VOLT",DBL2NUM(GSL_CONST_MKS_ELECTRON_VOLT));
    /**/
    rb_define_const(mConst,"MKS_ERG",DBL2NUM(GSL_CONST_MKS_ERG));
    /**/
    rb_define_const(mConst,"MKS_FARADAY",DBL2NUM(GSL_CONST_MKS_FARADAY));
    /**/
    rb_define_const(mConst,"MKS_FATHOM",DBL2NUM(GSL_CONST_MKS_FATHOM));
    /**/
    rb_define_const(mConst,"MKS_FLUID_OUNCE",DBL2NUM(GSL_CONST_MKS_FLUID_OUNCE));
    /**/
    rb_define_const(mConst,"MKS_FOOT",DBL2NUM(GSL_CONST_MKS_FOOT));
    /**/
    rb_define_const(mConst,"MKS_FOOTCANDLE",DBL2NUM(GSL_CONST_MKS_FOOTCANDLE));
    /**/
    rb_define_const(mConst,"MKS_FOOTLAMBERT",DBL2NUM(GSL_CONST_MKS_FOOTLAMBERT));
    /**/
    rb_define_const(mConst,"MKS_GAUSS",DBL2NUM(GSL_CONST_MKS_GAUSS));
    /**/
    rb_define_const(mConst,"MKS_GRAM_FORCE",DBL2NUM(GSL_CONST_MKS_GRAM_FORCE));
    /**/
    rb_define_const(mConst,"MKS_GRAVITATIONAL_CONSTANT",DBL2NUM(GSL_CONST_MKS_GRAVITATIONAL_CONSTANT));
    /**/
    rb_define_const(mConst,"MKS_GRAV_ACCEL",DBL2NUM(GSL_CONST_MKS_GRAV_ACCEL));
    /**/
    rb_define_const(mConst,"MKS_HECTARE",DBL2NUM(GSL_CONST_MKS_HECTARE));
    /**/
    rb_define_const(mConst,"MKS_HORSEPOWER",DBL2NUM(GSL_CONST_MKS_HORSEPOWER));
    /**/
    rb_define_const(mConst,"MKS_HOUR",DBL2NUM(GSL_CONST_MKS_HOUR));
    /**/
    rb_define_const(mConst,"MKS_INCH",DBL2NUM(GSL_CONST_MKS_INCH));
    /**/
    rb_define_const(mConst,"MKS_INCH_OF_MERCURY",DBL2NUM(GSL_CONST_MKS_INCH_OF_MERCURY));
    /**/
    rb_define_const(mConst,"MKS_INCH_OF_WATER",DBL2NUM(GSL_CONST_MKS_INCH_OF_WATER));
    /**/
    rb_define_const(mConst,"MKS_JOULE",DBL2NUM(GSL_CONST_MKS_JOULE));
    /**/
    rb_define_const(mConst,"MKS_KILOMETERS_PER_HOUR",DBL2NUM(GSL_CONST_MKS_KILOMETERS_PER_HOUR));
    /**/
    rb_define_const(mConst,"MKS_KILOPOUND_FORCE",DBL2NUM(GSL_CONST_MKS_KILOPOUND_FORCE));
    /**/
    rb_define_const(mConst,"MKS_KNOT",DBL2NUM(GSL_CONST_MKS_KNOT));
    /**/
    rb_define_const(mConst,"MKS_LAMBERT",DBL2NUM(GSL_CONST_MKS_LAMBERT));
    /**/
    rb_define_const(mConst,"MKS_LIGHT_YEAR",DBL2NUM(GSL_CONST_MKS_LIGHT_YEAR));
    /**/
    rb_define_const(mConst,"MKS_LITER",DBL2NUM(GSL_CONST_MKS_LITER));
    /**/
    rb_define_const(mConst,"MKS_LUMEN",DBL2NUM(GSL_CONST_MKS_LUMEN));
    /**/
    rb_define_const(mConst,"MKS_LUX",DBL2NUM(GSL_CONST_MKS_LUX));
    /**/
    rb_define_const(mConst,"MKS_MASS_ELECTRON",DBL2NUM(GSL_CONST_MKS_MASS_ELECTRON));
    /**/
    rb_define_const(mConst,"MKS_MASS_MUON",DBL2NUM(GSL_CONST_MKS_MASS_MUON));
    /**/
    rb_define_const(mConst,"MKS_MASS_NEUTRON",DBL2NUM(GSL_CONST_MKS_MASS_NEUTRON));
    /**/
    rb_define_const(mConst,"MKS_MASS_PROTON",DBL2NUM(GSL_CONST_MKS_MASS_PROTON));
    /**/
    rb_define_const(mConst,"MKS_METER_OF_MERCURY",DBL2NUM(GSL_CONST_MKS_METER_OF_MERCURY));
    /**/
    rb_define_const(mConst,"MKS_METRIC_TON",DBL2NUM(GSL_CONST_MKS_METRIC_TON));
    /**/
    rb_define_const(mConst,"MKS_MICRON",DBL2NUM(GSL_CONST_MKS_MICRON));
    /**/
    rb_define_const(mConst,"MKS_MIL",DBL2NUM(GSL_CONST_MKS_MIL));
    /**/
    rb_define_const(mConst,"MKS_MILE",DBL2NUM(GSL_CONST_MKS_MILE));
    /**/
    rb_define_const(mConst,"MKS_MILES_PER_HOUR",DBL2NUM(GSL_CONST_MKS_MILES_PER_HOUR));
    /**/
    rb_define_const(mConst,"MKS_MINUTE",DBL2NUM(GSL_CONST_MKS_MINUTE));
    /**/
    rb_define_const(mConst,"MKS_MOLAR_GAS",DBL2NUM(GSL_CONST_MKS_MOLAR_GAS));
    /**/
    rb_define_const(mConst,"MKS_NAUTICAL_MILE",DBL2NUM(GSL_CONST_MKS_NAUTICAL_MILE));
    /**/
    rb_define_const(mConst,"MKS_NEWTON",DBL2NUM(GSL_CONST_MKS_NEWTON));
    /**/
    rb_define_const(mConst,"MKS_NUCLEAR_MAGNETON",DBL2NUM(GSL_CONST_MKS_NUCLEAR_MAGNETON));
    /**/
    rb_define_const(mConst,"MKS_OUNCE_MASS",DBL2NUM(GSL_CONST_MKS_OUNCE_MASS));
    /**/
    rb_define_const(mConst,"MKS_PARSEC",DBL2NUM(GSL_CONST_MKS_PARSEC));
    /**/
    rb_define_const(mConst,"MKS_PHOT",DBL2NUM(GSL_CONST_MKS_PHOT));
    /**/
    rb_define_const(mConst,"MKS_PINT",DBL2NUM(GSL_CONST_MKS_PINT));
    /**/
    rb_define_const(mConst,"MKS_PLANCKS_CONSTANT_H",DBL2NUM(GSL_CONST_MKS_PLANCKS_CONSTANT_H));
    /**/
    rb_define_const(mConst,"MKS_PLANCKS_CONSTANT_HBAR",DBL2NUM(GSL_CONST_MKS_PLANCKS_CONSTANT_HBAR));
    /**/
    rb_define_const(mConst,"MKS_POINT",DBL2NUM(GSL_CONST_MKS_POINT));
    /**/
    rb_define_const(mConst,"MKS_POISE",DBL2NUM(GSL_CONST_MKS_POISE));
    /**/
    rb_define_const(mConst,"MKS_POUNDAL",DBL2NUM(GSL_CONST_MKS_POUNDAL));
    /**/
    rb_define_const(mConst,"MKS_POUND_FORCE",DBL2NUM(GSL_CONST_MKS_POUND_FORCE));
    /**/
    rb_define_const(mConst,"MKS_POUND_MASS",DBL2NUM(GSL_CONST_MKS_POUND_MASS));
    /**/
    rb_define_const(mConst,"MKS_PROTON_MAGNETIC_MOMENT",DBL2NUM(GSL_CONST_MKS_PROTON_MAGNETIC_MOMENT));
    /**/
    rb_define_const(mConst,"MKS_PSI",DBL2NUM(GSL_CONST_MKS_PSI));
    /**/
    rb_define_const(mConst,"MKS_QUART",DBL2NUM(GSL_CONST_MKS_QUART));
    /**/
    rb_define_const(mConst,"MKS_RAD",DBL2NUM(GSL_CONST_MKS_RAD));
    /**/
    rb_define_const(mConst,"MKS_ROENTGEN",DBL2NUM(GSL_CONST_MKS_ROENTGEN));
    /**/
    rb_define_const(mConst,"MKS_RYDBERG",DBL2NUM(GSL_CONST_MKS_RYDBERG));
    /**/
    rb_define_const(mConst,"MKS_SOLAR_MASS",DBL2NUM(GSL_CONST_MKS_SOLAR_MASS));
    /**/
    rb_define_const(mConst,"MKS_SPEED_OF_LIGHT",DBL2NUM(GSL_CONST_MKS_SPEED_OF_LIGHT));
    /**/
    rb_define_const(mConst,"MKS_STANDARD_GAS_VOLUME",DBL2NUM(GSL_CONST_MKS_STANDARD_GAS_VOLUME));
    /**/
    rb_define_const(mConst,"MKS_STD_ATMOSPHERE",DBL2NUM(GSL_CONST_MKS_STD_ATMOSPHERE));
    /**/
    rb_define_const(mConst,"MKS_STEFAN_BOLTZMANN_CONSTANT",DBL2NUM(GSL_CONST_MKS_STEFAN_BOLTZMANN_CONSTANT));
    /**/
    rb_define_const(mConst,"MKS_STILB",DBL2NUM(GSL_CONST_MKS_STILB));
    /**/
    rb_define_const(mConst,"MKS_STOKES",DBL2NUM(GSL_CONST_MKS_STOKES));
    /**/
    rb_define_const(mConst,"MKS_TABLESPOON",DBL2NUM(GSL_CONST_MKS_TABLESPOON));
    /**/
    rb_define_const(mConst,"MKS_TEASPOON",DBL2NUM(GSL_CONST_MKS_TEASPOON));
    /**/
    rb_define_const(mConst,"MKS_TEXPOINT",DBL2NUM(GSL_CONST_MKS_TEXPOINT));
    /**/
    rb_define_const(mConst,"MKS_THERM",DBL2NUM(GSL_CONST_MKS_THERM));
    /**/
    rb_define_const(mConst,"MKS_THOMSON_CROSS_SECTION",DBL2NUM(GSL_CONST_MKS_THOMSON_CROSS_SECTION));
    /**/
    rb_define_const(mConst,"MKS_TON",DBL2NUM(GSL_CONST_MKS_TON));
    /**/
    rb_define_const(mConst,"MKS_TORR",DBL2NUM(GSL_CONST_MKS_TORR));
    /**/
    rb_define_const(mConst,"MKS_TROY_OUNCE",DBL2NUM(GSL_CONST_MKS_TROY_OUNCE));
    /**/
    rb_define_const(mConst,"MKS_UK_GALLON",DBL2NUM(GSL_CONST_MKS_UK_GALLON));
    /**/
    rb_define_const(mConst,"MKS_UK_TON",DBL2NUM(GSL_CONST_MKS_UK_TON));
    /**/
    rb_define_const(mConst,"MKS_UNIFIED_ATOMIC_MASS",DBL2NUM(GSL_CONST_MKS_UNIFIED_ATOMIC_MASS));
    /**/
    rb_define_const(mConst,"MKS_US_GALLON",DBL2NUM(GSL_CONST_MKS_US_GALLON));
    /**/
    rb_define_const(mConst,"MKS_VACUUM_PERMEABILITY",DBL2NUM(GSL_CONST_MKS_VACUUM_PERMEABILITY));
    /**/
    rb_define_const(mConst,"MKS_VACUUM_PERMITTIVITY",DBL2NUM(GSL_CONST_MKS_VACUUM_PERMITTIVITY));
    /**/
    rb_define_const(mConst,"MKS_WEEK",DBL2NUM(GSL_CONST_MKS_WEEK));
    /**/
    rb_define_const(mConst,"MKS_YARD",DBL2NUM(GSL_CONST_MKS_YARD));
    /*$10^{-18}$ 10^-18 */
    rb_define_const(mConst,"NUM_ATTO",DBL2NUM(GSL_CONST_NUM_ATTO));
    /*Avogadro's number, N_a. */
    rb_define_const(mConst,"NUM_AVOGADRO",DBL2NUM(GSL_CONST_NUM_AVOGADRO));
    /*$10^{18}$ 10^18 */
    rb_define_const(mConst,"NUM_EXA",DBL2NUM(GSL_CONST_NUM_EXA));
    /*$10^{-15}$ 10^-15 */
    rb_define_const(mConst,"NUM_FEMTO",DBL2NUM(GSL_CONST_NUM_FEMTO));
    /*The electromagnetic fine structure constant \alpha. */
    rb_define_const(mConst,"NUM_FINE_STRUCTURE",DBL2NUM(GSL_CONST_NUM_FINE_STRUCTURE));
    /*10^9 */
    rb_define_const(mConst,"NUM_GIGA",DBL2NUM(GSL_CONST_NUM_GIGA));
    /*10^3 */
    rb_define_const(mConst,"NUM_KILO",DBL2NUM(GSL_CONST_NUM_KILO));
    /*10^6 */
    rb_define_const(mConst,"NUM_MEGA",DBL2NUM(GSL_CONST_NUM_MEGA));
    /*$10^{-6}$ 10^-6 */
    rb_define_const(mConst,"NUM_MICRO",DBL2NUM(GSL_CONST_NUM_MICRO));
    /*$10^{-3}$ 10^-3 */
    rb_define_const(mConst,"NUM_MILLI",DBL2NUM(GSL_CONST_NUM_MILLI));
    /*$10^{-9}$ 10^-9 */
    rb_define_const(mConst,"NUM_NANO",DBL2NUM(GSL_CONST_NUM_NANO));
    /*$10^{15}$ 10^15 */
    rb_define_const(mConst,"NUM_PETA",DBL2NUM(GSL_CONST_NUM_PETA));
    /*$10^{-12}$ 10^-12 */
    rb_define_const(mConst,"NUM_PICO",DBL2NUM(GSL_CONST_NUM_PICO));
    /*$10^{12}$ 10^12 */
    rb_define_const(mConst,"NUM_TERA",DBL2NUM(GSL_CONST_NUM_TERA));
    /*$10^{-24}$ 10^-24*/
    rb_define_const(mConst,"NUM_YOCTO",DBL2NUM(GSL_CONST_NUM_YOCTO));
    /*$10^{24}$ 10^24 */
    rb_define_const(mConst,"NUM_YOTTA",DBL2NUM(GSL_CONST_NUM_YOTTA));
    /*$10^{-21}$ 10^-21 */
    rb_define_const(mConst,"NUM_ZEPTO",DBL2NUM(GSL_CONST_NUM_ZEPTO));
    /*$10^{21}$ 10^21 */
    rb_define_const(mConst,"NUM_ZETTA",DBL2NUM(GSL_CONST_NUM_ZETTA));
#line 12 "../gen/tmpl/init_module.c"
    }
#line 41 "../gen/tmpl/lib.c"
}
