###
### $Rev$
### $Release: 3.2.0 $
### copyright(c) 2004-2006 kuwata-lab.com all rights reserved
###

require "#{File.dirname(__FILE__)}/test.rb"


class ConverterTest < Test::Unit::TestCase


  ## define test methods
  filename = __FILE__.sub(/\.rb$/, '.yaml')
  #load_yaml_testdata(filename)
  langs = %w[eruby php jstl eperl]
  load_yaml_testdata_with_each_lang(filename, :langs=>langs)


  def _test
    (@properties ||= {}).keys.each do |key|
      @properties[key.intern] = @properties.delete(key) if key.is_a?(String)
    end
    parser = Kwartz::PresentationLogicParser.get_class('css').new
    ruleset_list = parser.parse(@plogic.to_s)
    #ruleset_list = []
    handler = Kwartz::Handler.get_class(@lang).new(ruleset_list, @properties)
    converter = Kwartz::TextConverter.new(handler, @properties)
    if @exception
      error_class = @exception.split(/::/).inject(Object) {|cls, name| cls.const_get(name) }
      errmsg = nil
      assert_raise(error_class) do
        begin
          stmt_list = converter.convert(@pdata)
        rescue => ex
          errmsg = ex.message
          raise ex
        end
      end
      assert_equal(@errormsg, errmsg)
    else
      stmt_list = converter.convert(@pdata)
      sb = ''
      stmt_list.each do |stmt|
        sb << (s = stmt._inspect)
        sb << "\n" unless s[-1] == ?\n
      end
      assert_text_equal(@expected, sb)
    end
  end


end
