/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.bootstrap.swt;

import java.util.function.Consumer;
import name.abuchen.portfolio.bootstrap.Messages;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CustomStackRenderer
extends StackRenderer {
    private static final String SELECTED_PART = "name.abuchen.portfolio.selectedPart";

    protected void populateTabMenu(Menu menu, MPart part) {
        menu.setData(SELECTED_PART, (Object)part);
        if (this.isClosable(part)) {
            this.doCreateMenuItem(menu, Messages.LabelCloseWindow, e -> this.closeSelectedPart(menu));
        }
        if (this.isCloneable(part)) {
            this.doCreateMenuItem(menu, Messages.LabelCloneWindow, e -> this.cloneSelectedPart(menu));
        }
    }

    private MenuItem doCreateMenuItem(Menu menu, String menuItemText, Consumer<SelectionEvent> c) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(menuItemText);
        menuItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(c));
        return menuItem;
    }

    private void closeSelectedPart(Menu menu) {
        MPart selectedPart = (MPart)menu.getData(SELECTED_PART);
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)selectedPart).get(EPartService.class);
        if (partService.savePart(selectedPart, true)) {
            partService.hidePart(selectedPart);
        }
    }

    private void cloneSelectedPart(Menu menu) {
        MPart selectedPart = (MPart)menu.getData(SELECTED_PART);
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)selectedPart).get(EPartService.class);
        MPart part = partService.createPart(selectedPart.getElementId());
        part.setLabel(selectedPart.getLabel());
        selectedPart.getTransientData().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("name.abuchen.portfolio.")).forEach(entry -> {
            Object v = part.getTransientData().put((String)entry.getKey(), entry.getValue());
        });
        part.getTransientData().putAll(selectedPart.getTransientData());
        selectedPart.getParent().getChildren().add(part);
        part.setVisible(true);
        part.getParent().setVisible(true);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
    }

    protected boolean isCloneable(MPart part) {
        return part.getTags().contains("Cloneable");
    }
}

