/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.bootstrap;

import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.bootstrap.CustomSaveHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.osgi.service.event.Event;

public class SaveHandlerProcessor {
    private final MWindow window;
    private final IEventBroker eventBroker;

    @Inject
    public SaveHandlerProcessor(@Named(value="name.abuchen.portfolio.ui.window.mainwindow") MWindow window, IEventBroker eventBroker) {
        this.window = window;
        this.eventBroker = eventBroker;
    }

    @Execute
    void installIntoContext() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", event -> {
            if (!UIEvents.isSET((Event)event)) {
                return;
            }
            if (!this.window.equals(event.getProperty("ChangedElement")) || this.window.getContext() == null) {
                return;
            }
            this.window.getContext().runAndTrack(new RunAndTrack(){
                private final ISaveHandler saveHandler = new CustomSaveHandler();

                public boolean changed(IEclipseContext context) {
                    Object value = context.get(ISaveHandler.class);
                    if (!this.saveHandler.equals(value)) {
                        context.set(ISaveHandler.class, (Object)this.saveHandler);
                    }
                    return true;
                }
            });
        });
    }
}

