/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import name.abuchen.portfolio.bootstrap.Messages;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class FilePickerDialog
extends Dialog {
    public static final int SAVE_ALL = 42;
    public static final int SAVE_NONE = 43;
    private LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            FileInfo info = (FileInfo)element;
            String path = info.getPath();
            return path != null ? String.valueOf(info.getName()) + " (" + path + ")" : info.getName();
        }
    };
    private Object[] elements;
    private Object[] selected;
    private CheckboxTableViewer tableViewer;

    public FilePickerDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 42, Messages.LabelSaveAll, false);
        this.createButton(parent, 43, Messages.LabelSaveNone, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 42 || buttonId == 43) {
            this.setReturnCode(buttonId);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void setElements(Collection<?> elements) {
        this.selected = elements.toArray();
        this.elements = this.selected;
    }

    public Object[] getResult() {
        return this.selected != null ? this.selected : new Object[]{};
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText(Messages.SaveHandlerTitle);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 300).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        Label label = new Label(container, 0);
        label.setText(Messages.SaveHandlerTitle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        Composite tableArea = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)tableArea);
        tableArea.setLayout((Layout)new FillLayout());
        TableColumnLayout layout = new TableColumnLayout();
        tableArea.setLayout((Layout)layout);
        Table table = new Table(tableArea, 2082);
        this.tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput((Object)this.elements);
        this.tableViewer.setCheckedElements(this.elements);
        this.tableViewer.setComparator(new ViewerComparator());
        this.hookListener();
        return composite;
    }

    private void hookListener() {
        this.tableViewer.addCheckStateListener(event -> {
            this.selected = this.tableViewer.getCheckedElements();
            Object[] objectArray = this.selected;
        });
    }

    public static class FileInfo {
        private List<MPart> parts = new ArrayList<MPart>();
        private String name;
        private String path;

        public FileInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public void addPart(MPart part) {
            this.parts.add(part);
        }

        public void addParts(List<MPart> parts) {
            this.parts.addAll(parts);
        }

        public List<MPart> getParts() {
            return this.parts;
        }
    }
}

