/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.Month;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.util.HolidayName;
import name.abuchen.portfolio.util.HolidayType;
import name.abuchen.portfolio.util.TradeCalendar;

public class TradeCalendarManager {
    private static String defaultCalendarCode = "default";
    private static final Map<String, TradeCalendar> CACHE = new HashMap<String, TradeCalendar>();

    static {
        TradeCalendar tc = new TradeCalendar("default", Messages.LabelTradeCalendarDefault);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.easter(HolidayName.EASTER_MONDAY, 1));
        tc.add(HolidayType.fixed(HolidayName.LABOUR_DAY, Month.MAY, 1));
        tc.add(HolidayType.fixed(HolidayName.CHRISTMAS_EVE, Month.DECEMBER, 24));
        tc.add(HolidayType.fixed(HolidayName.FIRST_CHRISTMAS_DAY, Month.DECEMBER, 25));
        tc.add(HolidayType.fixed(HolidayName.SECOND_CHRISTMAS_DAY, Month.DECEMBER, 26));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("de", Messages.LabelTradeCalendarGermany);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.easter(HolidayName.EASTER_MONDAY, 1));
        tc.add(HolidayType.easter(HolidayName.WHIT_MONDAY, 50));
        tc.add(HolidayType.fixed(HolidayName.LABOUR_DAY, Month.MAY, 1));
        tc.add(HolidayType.fixed(HolidayName.UNIFICATION_GERMANY, Month.OCTOBER, 3).validFrom(1990));
        tc.add(HolidayType.fixed(HolidayName.REFORMATION_DAY, Month.OCTOBER, 31).validFrom(2017).validTo(2017));
        tc.add(HolidayType.fixed(HolidayName.CHRISTMAS_EVE, Month.DECEMBER, 24));
        tc.add(HolidayType.fixed(HolidayName.FIRST_CHRISTMAS_DAY, Month.DECEMBER, 25));
        tc.add(HolidayType.fixed(HolidayName.SECOND_CHRISTMAS_DAY, Month.DECEMBER, 26));
        tc.add(HolidayType.fixed(HolidayName.NEW_YEARS_EVE, Month.DECEMBER, 31));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("nyse", Messages.LabelTradeCalendarNYSE);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1).moveIf(DayOfWeek.SATURDAY, -1).moveIf(DayOfWeek.SUNDAY, 1));
        tc.add(HolidayType.fixed(HolidayName.REMEMBERANCE_OF_PRESIDENT_FORD, Month.JANUARY, 2).validFrom(2007).validTo(2007));
        tc.add(HolidayType.weekday(HolidayName.MARTIN_LUTHER_KING, 3, DayOfWeek.MONDAY, Month.JANUARY));
        tc.add(HolidayType.weekday(HolidayName.WASHINGTONS_BIRTHDAY, 3, DayOfWeek.MONDAY, Month.FEBRUARY));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.last(HolidayName.MEMORIAL, DayOfWeek.MONDAY, Month.MAY));
        tc.add(HolidayType.fixed(HolidayName.FUNERAL_OF_PRESIDENT_REAGAN, Month.JUNE, 11).validFrom(2004).validTo(2004));
        tc.add(HolidayType.fixed(HolidayName.INDEPENDENCE, Month.JULY, 4).moveIf(DayOfWeek.SATURDAY, -1).moveIf(DayOfWeek.SUNDAY, 1));
        tc.add(HolidayType.weekday(HolidayName.LABOUR_DAY, 1, DayOfWeek.MONDAY, Month.SEPTEMBER));
        tc.add(HolidayType.fixed(HolidayName.HURRICANE_SANDY, Month.OCTOBER, 29).validFrom(2012).validTo(2012));
        tc.add(HolidayType.fixed(HolidayName.HURRICANE_SANDY, Month.OCTOBER, 30).validFrom(2012).validTo(2012));
        tc.add(HolidayType.weekday(HolidayName.THANKSGIVING, 4, DayOfWeek.THURSDAY, Month.NOVEMBER));
        tc.add(HolidayType.fixed(HolidayName.CHRISTMAS, Month.DECEMBER, 25).moveIf(DayOfWeek.SATURDAY, -1).moveIf(DayOfWeek.SUNDAY, 1));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("lse", Messages.LabelTradeCalendarLSE);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.easter(HolidayName.EASTER_MONDAY, 1));
        tc.add(HolidayType.weekday(HolidayName.EARLY_MAY_BANK_HOLIDAY, 1, DayOfWeek.MONDAY, Month.MAY));
        tc.add(HolidayType.last(HolidayName.SPRING_MAY_BANK_HOLIDAY, DayOfWeek.MONDAY, Month.MAY));
        tc.add(HolidayType.last(HolidayName.SUMMER_BANK_HOLIDAY, DayOfWeek.MONDAY, Month.AUGUST));
        tc.add(HolidayType.fixed(HolidayName.FIRST_CHRISTMAS_DAY, Month.DECEMBER, 25));
        tc.add(HolidayType.fixed(HolidayName.BOXING_DAY, Month.DECEMBER, 26));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("euronext", Messages.LabelTradeCalendarEuronext);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.easter(HolidayName.EASTER_MONDAY, 1));
        tc.add(HolidayType.fixed(HolidayName.LABOUR_DAY, Month.MAY, 1));
        tc.add(HolidayType.fixed(HolidayName.FIRST_CHRISTMAS_DAY, Month.DECEMBER, 25));
        tc.add(HolidayType.fixed(HolidayName.BOXING_DAY, Month.DECEMBER, 26));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("six", Messages.LabelTradeCalendarSix);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1));
        tc.add(HolidayType.fixed(HolidayName.BERCHTOLDSTAG, Month.JANUARY, 2));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.easter(HolidayName.EASTER_MONDAY, 1));
        tc.add(HolidayType.fixed(HolidayName.LABOUR_DAY, Month.MAY, 1));
        tc.add(HolidayType.easter(HolidayName.ASCENSION_DAY, 39));
        tc.add(HolidayType.easter(HolidayName.WHIT_MONDAY, 50));
        tc.add(HolidayType.fixed(HolidayName.NATION_DAY, Month.AUGUST, 1));
        tc.add(HolidayType.fixed(HolidayName.CHRISTMAS_EVE, Month.DECEMBER, 24));
        tc.add(HolidayType.fixed(HolidayName.FIRST_CHRISTMAS_DAY, Month.DECEMBER, 25));
        tc.add(HolidayType.fixed(HolidayName.SECOND_CHRISTMAS_DAY, Month.DECEMBER, 26));
        tc.add(HolidayType.fixed(HolidayName.NEW_YEARS_EVE, Month.DECEMBER, 31));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("ise", Messages.LabelTradeCalendarISE);
        tc.add(HolidayType.fixed(HolidayName.NEW_YEAR, Month.JANUARY, 1));
        tc.add(HolidayType.easter(HolidayName.GOOD_FRIDAY, -2));
        tc.add(HolidayType.easter(HolidayName.EASTER_MONDAY, 1));
        tc.add(HolidayType.fixed(HolidayName.LABOUR_DAY, Month.MAY, 1));
        tc.add(HolidayType.fixed(HolidayName.ASSUMPTION_DAY, Month.AUGUST, 15));
        tc.add(HolidayType.fixed(HolidayName.CHRISTMAS_EVE, Month.DECEMBER, 24));
        tc.add(HolidayType.fixed(HolidayName.FIRST_CHRISTMAS_DAY, Month.DECEMBER, 25));
        tc.add(HolidayType.fixed(HolidayName.SECOND_CHRISTMAS_DAY, Month.DECEMBER, 26));
        tc.add(HolidayType.fixed(HolidayName.NEW_YEARS_EVE, Month.DECEMBER, 31));
        CACHE.put(tc.getCode(), tc);
        tc = new TradeCalendar("empty", Messages.LabelTradeCalendarEmpty);
        CACHE.put(tc.getCode(), tc);
    }

    private TradeCalendarManager() {
    }

    public static Stream<TradeCalendar> getAvailableCalendar() {
        return CACHE.values().stream();
    }

    public static void setDefaultCalendarCode(String defaultCalendarCode) {
        if (!CACHE.containsKey(defaultCalendarCode)) {
            PortfolioLog.warning(MessageFormat.format("Attempting to set unkown calendar code: {0}", defaultCalendarCode));
            return;
        }
        TradeCalendarManager.defaultCalendarCode = defaultCalendarCode;
    }

    public static TradeCalendar getInstance(String calendarCode) {
        return CACHE.get(calendarCode);
    }

    public static TradeCalendar createInheritDefaultOption() {
        String description = MessageFormat.format(Messages.LabelTradeCalendarUseDefault, TradeCalendarManager.getDefaultInstance().getDescription());
        return new TradeCalendar("", description);
    }

    public static TradeCalendar getDefaultInstance() {
        return CACHE.get(defaultCalendarCode);
    }

    public static TradeCalendar getInstance(Security security) {
        TradeCalendar calendar = null;
        if (security.getCalendar() != null) {
            calendar = CACHE.get(security.getCalendar());
        }
        return calendar == null ? TradeCalendarManager.getDefaultInstance() : calendar;
    }
}

