/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private IProgressMonitor monitor;
    private int updateIncrement;
    private long bytesRead = 0L;
    private long nextUpdate = 0L;

    public ProgressMonitorInputStream(InputStream in, int updateIncrement, IProgressMonitor monitor) {
        super(in);
        this.updateIncrement = updateIncrement;
        this.monitor = monitor;
        this.nextUpdate = updateIncrement;
    }

    public ProgressMonitorInputStream(InputStream in, IProgressMonitor monitor) throws IOException {
        this(in, (int)Math.min((long)in.available() / 20L, Integer.MAX_VALUE), monitor);
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.monitor.done();
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            ++this.bytesRead;
            this.update();
        }
        return b;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        try {
            int count = this.in.read(buffer, offset, length);
            if (count != -1) {
                this.bytesRead += (long)count;
                this.update();
            }
            return count;
        }
        catch (InterruptedIOException e) {
            this.bytesRead += (long)e.bytesTransferred;
            this.update();
            throw e;
        }
    }

    @Override
    public long skip(long amount) throws IOException {
        try {
            long count = this.in.skip(amount);
            this.bytesRead += count;
            this.update();
            return count;
        }
        catch (InterruptedIOException e) {
            this.bytesRead += (long)e.bytesTransferred;
            this.update();
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void update() {
        if (this.bytesRead >= this.nextUpdate) {
            this.monitor.worked(1);
            this.nextUpdate += (long)this.updateIncrement;
        }
    }
}

