/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import name.abuchen.portfolio.money.Values;

public final class Interval {
    private final LocalDate start;
    private final LocalDate end;

    private Interval(LocalDate start, LocalDate end) {
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
    }

    public static Interval of(LocalDate start, LocalDate end) {
        return new Interval(start, end);
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public boolean isLongerThan(Interval other) {
        return this.getDays() > other.getDays();
    }

    public boolean contains(LocalDate other) {
        return other.isAfter(this.start) && !other.isAfter(this.end);
    }

    public boolean contains(LocalDateTime other) {
        return this.contains(other.toLocalDate());
    }

    public long getDays() {
        return ChronoUnit.DAYS.between(this.start, this.end);
    }

    public List<Year> getYears() {
        return this.collect(Year::from);
    }

    public List<YearMonth> getYearMonths() {
        return this.collect(YearMonth::from);
    }

    private <T> List<T> collect(Function<LocalDate, T> collector) {
        ArrayList<T> answer = new ArrayList<T>();
        Object lastItem = null;
        LocalDate index = this.start.plusDays(1L);
        while (!index.isAfter(this.end)) {
            T item = collector.apply(index);
            if (!item.equals(lastItem)) {
                answer.add(item);
                lastItem = item;
            }
            index = index.plusDays(1L);
        }
        return answer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end.hashCode();
        result = 31 * result + this.start.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return this.end.equals(other.end) && this.start.equals(other.start);
    }

    public String toString() {
        return String.valueOf(Values.Date.format(this.start)) + " - " + Values.Date.format(this.end);
    }
}

