/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import name.abuchen.portfolio.PortfolioLog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageLoader;

public class ImageUtil {
    private static final String BASE64PREFIX = "data:image/png;base64,";

    public static Image toImage(String value, int logicalWidth, int logicalHeight) {
        byte[] buff;
        block6: {
            if (value == null || value.length() == 0) {
                return null;
            }
            if (!value.startsWith(BASE64PREFIX)) {
                return null;
            }
            try {
                int splitPos = value.indexOf(44);
                if (splitPos >= 0 && splitPos < value.length() - 1) {
                    value = value.substring(splitPos + 1);
                }
                if ((buff = Base64.getDecoder().decode(value)) != null && buff.length != 0) break block6;
                return null;
            }
            catch (Exception ex) {
                PortfolioLog.error(ex);
                return null;
            }
        }
        return new Image(null, (ImageDataProvider)new ZoomingImageDataProvider(buff, logicalWidth, logicalHeight));
    }

    private static ImageData toImageData(byte[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            ImageLoader loader = new ImageLoader();
            ByteArrayInputStream bis = new ByteArrayInputStream(value);
            ImageData[] imgArr = loader.load((InputStream)bis);
            return imgArr[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static byte[] encode(ImageData image) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        loader.save((OutputStream)bos, 5);
        return bos.toByteArray();
    }

    public static String loadAndPrepare(String filename, int maxWidth, int maxHeight) throws IOException {
        byte[] data = Files.readAllBytes(Paths.get(filename, new String[0]));
        ImageData imgData = ImageUtil.toImageData(data);
        if (imgData.width > maxWidth || imgData.height > maxHeight) {
            imgData = ImageUtil.resize(imgData, maxWidth, maxHeight, true);
            data = ImageUtil.encode(imgData);
        }
        return BASE64PREFIX + Base64.getEncoder().encodeToString(data);
    }

    private static ImageData resize(ImageData image, int maxWidth, int maxHeight, boolean preserveRatio) {
        int posY;
        if (image.width == maxWidth && image.height == maxHeight) {
            return image;
        }
        int newHeight = maxHeight;
        int newWidth = image.width * newHeight / image.height;
        if (newWidth > maxWidth) {
            newWidth = maxWidth;
            newHeight = image.height * newWidth / image.width;
        }
        int imageWidth = preserveRatio ? newWidth : maxWidth;
        int imageHeight = preserveRatio ? newHeight : maxHeight;
        int posX = preserveRatio ? 0 : (maxWidth - newWidth) / 2;
        int n = posY = preserveRatio ? 0 : (maxHeight - newHeight) / 2;
        if (posX + newWidth > imageWidth) {
            newWidth = imageWidth - posX;
        }
        if (posY + newHeight > imageHeight) {
            newWidth = imageHeight - posY;
        }
        ImageData imageData = ImageUtil.getTransparentImage(imageWidth, imageHeight);
        Image canvas = new Image(null, imageData);
        GC gc = new GC((Drawable)canvas);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        Image source = new Image(null, image);
        gc.drawImage(source, 0, 0, image.width, image.height, posX, posY, newWidth, newHeight);
        gc.dispose();
        source.dispose();
        ImageData answer = canvas.getImageData();
        canvas.dispose();
        return answer;
    }

    private static ImageData getTransparentImage(int imageWidth, int imageHeight) {
        boolean useHack;
        Image background = new Image(null, imageWidth, imageHeight);
        ImageData imageData = background.getImageData();
        String flag = System.getProperty("transparency-hack");
        String os = Platform.getOS();
        boolean bl = flag != null ? Boolean.parseBoolean(flag) : (useHack = "macosx".equals(os) || "linux".equals(os));
        if (!useHack) {
            imageData.transparentPixel = imageData.getPixel(0, 0);
        } else {
            imageData.transparentPixel = imageData.getPixel(0, 0);
            imageData.alphaData = new byte[imageWidth * imageHeight];
            Arrays.fill(imageData.alphaData, (byte)-1);
            Arrays.fill(imageData.data, (byte)-1);
        }
        background.dispose();
        return imageData;
    }

    private static class ZoomingImageDataProvider
    implements ImageDataProvider {
        private int logicalWidth;
        private int logicalHeight;
        private ImageData fullSize;
        private HashMap<Integer, ImageData> zoomLevels = new HashMap();

        public ZoomingImageDataProvider(byte[] data, int logicalWidth, int logicalHeight) {
            this.logicalWidth = logicalWidth;
            this.logicalHeight = logicalHeight;
            this.fullSize = ImageUtil.toImageData(data);
        }

        public ImageData getImageData(int zoom) {
            ImageData imageData = this.zoomLevels.get(zoom);
            if (imageData != null) {
                return imageData;
            }
            float scaleW = 1.0f / (float)this.fullSize.width * (float)this.logicalWidth * ((float)zoom / 100.0f);
            float scaleH = 1.0f / (float)this.fullSize.height * (float)this.logicalHeight * ((float)zoom / 100.0f);
            imageData = ImageUtil.resize(this.fullSize, (int)((float)this.fullSize.width * scaleW), (int)((float)this.fullSize.height * scaleH), false);
            this.zoomLevels.put(zoom, imageData);
            return imageData;
        }
    }
}

