/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.util.Holiday;
import name.abuchen.portfolio.util.HolidayName;

abstract class HolidayType {
    private final HolidayName name;
    private int validFrom = -1;
    private int validTo = -1;
    private final List<MoveIf> moveIf = new ArrayList<MoveIf>();

    public HolidayType(HolidayName name) {
        this.name = name;
    }

    public static HolidayType fixed(HolidayName name, Month month, int dayOfMonth) {
        return new FixedHolidayType(name, month, dayOfMonth);
    }

    public static HolidayType weekday(HolidayName name, int which, DayOfWeek weekday, Month month) {
        return new FixedWeekdayHolidayType(name, which, weekday, month);
    }

    public static HolidayType last(HolidayName name, DayOfWeek weekday, Month month) {
        return new LastWeekdayHolidayType(name, weekday, month);
    }

    public static HolidayType easter(HolidayName name, int daysToAdd) {
        return new RelativeToEasterHolidayType(name, daysToAdd);
    }

    public HolidayName getName() {
        return this.name;
    }

    public HolidayType validFrom(int year) {
        this.validFrom = year;
        return this;
    }

    public HolidayType validTo(int year) {
        this.validTo = year;
        return this;
    }

    public HolidayType moveIf(DayOfWeek dayOfWeek, int daysToAdd) {
        this.moveIf.add(new MoveIf(dayOfWeek, daysToAdd));
        return this;
    }

    public Holiday getHoliday(int year) {
        if (this.validFrom != -1 && year < this.validFrom) {
            return null;
        }
        if (this.validTo != -1 && year > this.validTo) {
            return null;
        }
        Holiday answer = this.doGetHoliday(year);
        if (this.moveIf.isEmpty()) {
            return answer;
        }
        LocalDate date = answer.getDate();
        for (MoveIf mv : this.moveIf) {
            date = mv.apply(date);
        }
        return new Holiday(answer.getName(), date);
    }

    protected abstract Holiday doGetHoliday(int var1);

    private static class FixedHolidayType
    extends HolidayType {
        private final Month month;
        private final int dayOfMonth;

        public FixedHolidayType(HolidayName name, Month month, int dayOfMonth) {
            super(name);
            this.month = month;
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        protected Holiday doGetHoliday(int year) {
            LocalDate date = LocalDate.of(year, this.month.getValue(), this.dayOfMonth);
            return new Holiday(this.getName(), date);
        }
    }

    private static class FixedWeekdayHolidayType
    extends HolidayType {
        private final int which;
        private final DayOfWeek weekday;
        private final Month month;

        public FixedWeekdayHolidayType(HolidayName name, int which, DayOfWeek weekday, Month month) {
            super(name);
            this.which = which;
            this.weekday = weekday;
            this.month = month;
        }

        @Override
        protected Holiday doGetHoliday(int year) {
            LocalDate date = LocalDate.of(year, this.month, 1);
            return new Holiday(this.getName(), date.with(TemporalAdjusters.dayOfWeekInMonth(this.which, this.weekday)));
        }
    }

    private static class LastWeekdayHolidayType
    extends HolidayType {
        private final DayOfWeek weekday;
        private final Month month;

        public LastWeekdayHolidayType(HolidayName name, DayOfWeek weekday, Month month) {
            super(name);
            this.weekday = weekday;
            this.month = month;
        }

        @Override
        protected Holiday doGetHoliday(int year) {
            LocalDate date = LocalDate.of(year, this.month, 1);
            return new Holiday(this.getName(), date.with(TemporalAdjusters.lastInMonth(this.weekday)));
        }
    }

    private static class MoveIf {
        private final DayOfWeek dayOfWeek;
        private final int daysToAdd;

        public MoveIf(DayOfWeek dayOfWeek, int daysToAdd) {
            this.dayOfWeek = dayOfWeek;
            this.daysToAdd = daysToAdd;
        }

        public LocalDate apply(LocalDate date) {
            return date.getDayOfWeek() == this.dayOfWeek ? date.plusDays(this.daysToAdd) : date;
        }
    }

    private static class RelativeToEasterHolidayType
    extends HolidayType {
        private final int daysToAdd;

        public RelativeToEasterHolidayType(HolidayName name, int daysToAdd) {
            super(name);
            this.daysToAdd = daysToAdd;
        }

        @Override
        protected Holiday doGetHoliday(int year) {
            LocalDate easterSunday = this.calculateEasterSunday(year);
            return new Holiday(this.getName(), easterSunday.plusDays(this.daysToAdd));
        }

        private LocalDate calculateEasterSunday(int nYear) {
            int nA = 0;
            int nB = 0;
            int nC = 0;
            int nD = 0;
            int nE = 0;
            int nF = 0;
            int nG = 0;
            int nH = 0;
            int nI = 0;
            int nK = 0;
            int nL = 0;
            int nM = 0;
            int nP = 0;
            int nEasterMonth = 0;
            int nEasterDay = 0;
            nA = nYear % 19;
            nB = nYear / 100;
            nC = nYear % 100;
            nD = nB / 4;
            nE = nB % 4;
            nF = (nB + 8) / 25;
            nG = (nB - nF + 1) / 3;
            nH = (19 * nA + nB - nD - nG + 15) % 30;
            nI = nC / 4;
            nK = nC % 4;
            nL = (32 + 2 * nE + 2 * nI - nH - nK) % 7;
            nM = (nA + 11 * nH + 22 * nL) / 451;
            nEasterMonth = (nH + nL - 7 * nM + 114) / 31;
            nP = (nH + nL - 7 * nM + 114) % 31;
            nEasterDay = nP + 1;
            return LocalDate.of(nYear, nEasterMonth, nEasterDay);
        }
    }
}

