/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trail;

import java.util.Optional;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

public final class Trail {
    private final String label;
    private final TrailRecord record;

    public Trail(String label, TrailRecord record) {
        this.label = label;
        this.record = record;
    }

    public static Optional<Trail> of(String label, TrailRecord record) {
        if (record == null || record.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Trail(label, record));
    }

    public String getLabel() {
        return this.label;
    }

    public TrailRecord getRecord() {
        return this.record;
    }

    public int getDepth() {
        return this.depth(1, this.record);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.label).append('\n');
        int depth = this.getDepth();
        this.addRow(buffer, this.record, depth - 1, depth);
        return buffer.toString();
    }

    private void addRow(StringBuilder buffer, TrailRecord trail, int level, int depth) {
        for (TrailRecord child : trail.getInputs()) {
            this.addRow(buffer, child, level - 1, depth);
        }
        buffer.append(String.format("%-10s | %-30s | %5s |", trail.getDate() != null ? Values.Date.format(trail.getDate()) : "", trail.getLabel(), trail.getShares() != null ? Values.Share.format(trail.getShares()) : ""));
        int index = 0;
        while (index < depth) {
            String value = "";
            if (index == level) {
                value = trail.getValue() != null ? Values.Money.format(trail.getValue()) : "n/a";
            }
            buffer.append(String.format(" %12s |", value));
            ++index;
        }
        buffer.append('\n');
    }

    private int depth(int level, TrailRecord t) {
        if (t.getInputs().isEmpty()) {
            return level;
        }
        int d = level;
        for (TrailRecord child : t.getInputs()) {
            d = Math.max(d, this.depth(level + 1, child));
        }
        return d;
    }
}

