/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.trades;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.snapshot.trades.TradeCollectorException;

public class TradeCollector {
    private Client client;
    private CurrencyConverter converter;

    public TradeCollector(Client client, CurrencyConverter converter) {
        this.client = client;
        this.converter = converter;
    }

    public List<Trade> collect(Security security) throws TradeCollectorException {
        List<TransactionPair<?>> transactions = security.getTransactions(this.client);
        Collections.sort(transactions, (p1, p2) -> ((Transaction)p1.getTransaction()).getDateTime().compareTo(((Transaction)p2.getTransaction()).getDateTime()));
        ArrayList<Trade> trades = new ArrayList<Trade>();
        HashMap<Portfolio, List<TransactionPair<PortfolioTransaction>>> openTransactions = new HashMap<Portfolio, List<TransactionPair<PortfolioTransaction>>>();
        for (TransactionPair<PortfolioTransaction> transactionPair : transactions) {
            if (!(transactionPair.getTransaction() instanceof PortfolioTransaction)) continue;
            TransactionPair<PortfolioTransaction> pair = transactionPair;
            Portfolio portfolio = (Portfolio)transactionPair.getOwner();
            PortfolioTransaction t2 = (PortfolioTransaction)transactionPair.getTransaction();
            switch (t2.getType()) {
                case BUY: 
                case DELIVERY_INBOUND: {
                    openTransactions.computeIfAbsent(portfolio, p -> new ArrayList()).add(pair);
                    break;
                }
                case SELL: 
                case DELIVERY_OUTBOUND: {
                    trades.add(this.createNewTradeFromSell(openTransactions, pair));
                    break;
                }
                case TRANSFER_IN: {
                    this.moveOpenTransaction(openTransactions, pair);
                    break;
                }
                case TRANSFER_OUT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        for (Map.Entry entry : openTransactions.entrySet()) {
            List position = (List)entry.getValue();
            if (position.isEmpty()) continue;
            long shares = position.stream().mapToLong(p -> ((PortfolioTransaction)p.getTransaction()).getShares()).sum();
            Trade newTrade = new Trade(security, (Portfolio)entry.getKey(), shares);
            newTrade.setStart(((PortfolioTransaction)((TransactionPair)position.get(0)).getTransaction()).getDateTime());
            newTrade.getTransactions().addAll(position);
            trades.add(newTrade);
        }
        trades.forEach(t -> t.calculate(this.converter));
        return trades;
    }

    private Trade createNewTradeFromSell(Map<Portfolio, List<TransactionPair<PortfolioTransaction>>> openTransactions, TransactionPair<PortfolioTransaction> pair) throws TradeCollectorException {
        Trade newTrade = new Trade(pair.getTransaction().getSecurity(), (Portfolio)pair.getOwner(), pair.getTransaction().getShares());
        List<TransactionPair<PortfolioTransaction>> open = openTransactions.get(pair.getOwner());
        if (open == null || open.isEmpty()) {
            throw new TradeCollectorException(MessageFormat.format(Messages.MsgErrorTradeCollector_NoHoldingsForSell, pair.getTransaction().getSecurity(), pair.getOwner(), pair));
        }
        long sharesToDistribute = pair.getTransaction().getShares();
        Collections.sort(open, (p1, p2) -> ((PortfolioTransaction)p1.getTransaction()).getDateTime().compareTo(((PortfolioTransaction)p2.getTransaction()).getDateTime()));
        for (TransactionPair<PortfolioTransaction> candidate : new ArrayList<TransactionPair<PortfolioTransaction>>(open)) {
            if (sharesToDistribute == 0L) break;
            if (newTrade.getStart() == null) {
                newTrade.setStart(candidate.getTransaction().getDateTime());
            }
            if (sharesToDistribute >= candidate.getTransaction().getShares()) {
                newTrade.getTransactions().add(candidate);
                open.remove(candidate);
                sharesToDistribute -= candidate.getTransaction().getShares();
                continue;
            }
            if (sharesToDistribute >= candidate.getTransaction().getShares()) continue;
            newTrade.getTransactions().add(this.split(candidate, (Portfolio)pair.getOwner(), (double)sharesToDistribute / (double)candidate.getTransaction().getShares()));
            open.set(open.indexOf(candidate), this.split(candidate, (Portfolio)pair.getOwner(), (double)(candidate.getTransaction().getShares() - sharesToDistribute) / (double)candidate.getTransaction().getShares()));
            sharesToDistribute = 0L;
        }
        if (sharesToDistribute > 0L) {
            throw new TradeCollectorException(MessageFormat.format(Messages.MsgErrorTradeCollector_MissingHoldingsForSell, pair.getTransaction().getSecurity(), pair.getOwner(), Values.Share.format(sharesToDistribute), pair));
        }
        newTrade.getTransactions().add(pair);
        newTrade.setEnd(pair.getTransaction().getDateTime());
        return newTrade;
    }

    private void moveOpenTransaction(Map<Portfolio, List<TransactionPair<PortfolioTransaction>>> openTransactions, TransactionPair<PortfolioTransaction> pair) throws TradeCollectorException {
        PortfolioTransferEntry transfer = (PortfolioTransferEntry)pair.getTransaction().getCrossEntry();
        Portfolio outbound = (Portfolio)transfer.getOwner(transfer.getSourceTransaction());
        Portfolio inbound = (Portfolio)transfer.getOwner(transfer.getTargetTransaction());
        List target = openTransactions.computeIfAbsent(inbound, p -> new ArrayList());
        List<TransactionPair<PortfolioTransaction>> positions = openTransactions.get(outbound);
        if (positions == null || positions.isEmpty()) {
            throw new TradeCollectorException(MessageFormat.format(Messages.MsgErrorTradeCollector_NoHoldingsForTransfer, pair.getTransaction().getSecurity(), outbound, inbound, pair));
        }
        long sharesToTransfer = pair.getTransaction().getShares();
        for (TransactionPair<PortfolioTransaction> candidate : new ArrayList<TransactionPair<PortfolioTransaction>>(positions)) {
            if (sharesToTransfer == 0L) break;
            if (sharesToTransfer >= candidate.getTransaction().getShares()) {
                positions.remove(candidate);
                target.add(candidate);
                sharesToTransfer -= candidate.getTransaction().getShares();
                continue;
            }
            if (sharesToTransfer >= candidate.getTransaction().getShares()) continue;
            long remainingShares = candidate.getTransaction().getShares() - sharesToTransfer;
            positions.set(positions.indexOf(candidate), this.split(candidate, outbound, (double)remainingShares / (double)candidate.getTransaction().getShares()));
            target.add(this.split(candidate, inbound, (double)sharesToTransfer / (double)candidate.getTransaction().getShares()));
            sharesToTransfer = 0L;
        }
        if (sharesToTransfer > 0L) {
            throw new TradeCollectorException(MessageFormat.format(Messages.MsgErrorTradeCollector_MissingHoldingsForTransfer, pair.getTransaction().getSecurity(), outbound, inbound, Values.Share.format(sharesToTransfer), pair));
        }
    }

    private TransactionPair<PortfolioTransaction> split(TransactionPair<PortfolioTransaction> candidate, Portfolio newOwner, double weight) {
        if (candidate.getTransaction().getCrossEntry() instanceof BuySellEntry) {
            return this.splitBuySell((BuySellEntry)candidate.getTransaction().getCrossEntry(), newOwner, weight);
        }
        if (candidate.getTransaction() instanceof PortfolioTransaction) {
            return this.splitPortfolioTransaction((Portfolio)candidate.getOwner(), candidate.getTransaction(), weight);
        }
        throw new UnsupportedOperationException();
    }

    private TransactionPair<PortfolioTransaction> splitBuySell(BuySellEntry entry, Portfolio portfolio, double weight) {
        PortfolioTransaction t = entry.getPortfolioTransaction();
        BuySellEntry copy = new BuySellEntry();
        copy.setPortfolio(portfolio);
        copy.setAccount(entry.getAccount());
        copy.setDate(t.getDateTime());
        copy.setCurrencyCode(t.getCurrencyCode());
        copy.setSecurity(t.getSecurity());
        copy.setType(t.getType());
        copy.setNote(t.getNote());
        copy.setShares(Math.round((double)t.getShares() * weight));
        copy.setAmount(Math.round((double)t.getAmount() * weight));
        t.getUnits().forEach(unit -> copy.getPortfolioTransaction().addUnit(unit.split(weight)));
        return new TransactionPair<PortfolioTransaction>(entry.getPortfolio(), copy.getPortfolioTransaction());
    }

    private TransactionPair<PortfolioTransaction> splitPortfolioTransaction(Portfolio portfolio, PortfolioTransaction transaction, double weight) {
        PortfolioTransaction newTransaction = new PortfolioTransaction();
        newTransaction.setType(transaction.getType());
        newTransaction.setDateTime(transaction.getDateTime());
        newTransaction.setSecurity(transaction.getSecurity());
        newTransaction.setCurrencyCode(transaction.getCurrencyCode());
        newTransaction.setNote(transaction.getNote());
        newTransaction.setShares(Math.round((double)transaction.getShares() * weight));
        newTransaction.setAmount(Math.round((double)transaction.getAmount() * weight));
        transaction.getUnits().forEach(unit -> newTransaction.addUnit(unit.split(weight)));
        return new TransactionPair<PortfolioTransaction>(portfolio, newTransaction);
    }
}

