/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;

class SharesHeldCalculation
extends Calculation {
    private long sharesHeld;

    SharesHeldCalculation() {
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtStart item) {
        this.sharesHeld += item.getSecurityPosition().orElseThrow(IllegalArgumentException::new).getShares();
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, PortfolioTransaction t) {
        switch (t.getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                this.sharesHeld += t.getShares();
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                this.sharesHeld -= t.getShares();
                break;
            }
            case TRANSFER_IN: 
            case TRANSFER_OUT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public long getSharesHeld() {
        return this.sharesHeld;
    }
}

