/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

class CostCalculation
extends Calculation {
    private List<LineItem> fifo = new ArrayList<LineItem>();
    private long movingRelativeCost = 0L;
    private long movingRelativeNetCost = 0L;
    private long heldShares = 0L;
    private long fees;
    private long taxes;

    CostCalculation() {
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtStart item) {
        Money valuation = item.getValue();
        SecurityPosition position = item.getSecurityPosition().orElseThrow(IllegalArgumentException::new);
        long amount = converter.convert(item.getDateTime(), valuation).getAmount();
        TrailRecord trail = TrailRecord.ofPosition(item.getDateTime().toLocalDate(), (Portfolio)item.getOwner(), position);
        if (!this.getTermCurrency().equals(valuation.getCurrencyCode())) {
            trail = trail.convert(Money.of(this.getTermCurrency(), amount), converter.getRate(item.getDateTime(), valuation.getCurrencyCode()));
        }
        this.fifo.add(new LineItem(item.getOwner(), position.getShares(), amount, amount, trail));
        this.movingRelativeCost += amount;
        this.movingRelativeNetCost += amount;
        this.heldShares += position.getShares();
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, PortfolioTransaction t) {
        long fee = t.getUnitSum(Transaction.Unit.Type.FEE, converter).getAmount();
        long tax = t.getUnitSum(Transaction.Unit.Type.TAX, converter).getAmount();
        this.fees += fee;
        this.taxes += tax;
        switch (t.getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                long grossAmount = t.getMonetaryAmount(converter).getAmount();
                long netAmount = t.getGrossValue(converter).getAmount();
                TrailRecord trail = TrailRecord.ofTransaction(t);
                if (!this.getTermCurrency().equals(t.getCurrencyCode())) {
                    trail = trail.convert(Money.of(this.getTermCurrency(), grossAmount), converter.getRate(t.getDateTime(), t.getCurrencyCode()));
                }
                this.fifo.add(new LineItem(item.getOwner(), t.getShares(), grossAmount, netAmount, trail));
                this.movingRelativeCost += grossAmount;
                this.movingRelativeNetCost += netAmount;
                this.heldShares += t.getShares();
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                long sold = t.getShares();
                long remaining = this.heldShares - sold;
                if (remaining <= 0L) {
                    this.movingRelativeCost = 0L;
                    this.movingRelativeNetCost = 0L;
                    this.heldShares = 0L;
                } else {
                    this.movingRelativeCost = Math.round((double)this.movingRelativeCost / (double)this.heldShares * (double)remaining);
                    this.movingRelativeNetCost = Math.round((double)this.movingRelativeNetCost / (double)this.heldShares * (double)remaining);
                    this.heldShares = remaining;
                }
                for (LineItem entry : this.fifo) {
                    if (sold <= 0L) break;
                    if (!entry.owner.equals(item.getOwner()) || entry.shares == 0L) continue;
                    long n = Math.min(sold, entry.shares);
                    LineItem lineItem = entry;
                    lineItem.grossAmount = lineItem.grossAmount - Math.round((double)n / (double)entry.shares * (double)entry.grossAmount);
                    LineItem lineItem2 = entry;
                    lineItem2.netAmount = lineItem2.netAmount - Math.round((double)n / (double)entry.shares * (double)entry.netAmount);
                    LineItem lineItem3 = entry;
                    lineItem3.shares = lineItem3.shares - n;
                    sold -= n;
                }
                if (sold <= 0L) break;
                PortfolioLog.warning(MessageFormat.format(Messages.MsgNegativeHoldingsDuringFIFOCostCalculation, Values.Share.format(sold), t.getSecurity().getName(), Values.DateTime.format(t.getDateTime())));
                break;
            }
            case TRANSFER_IN: {
                long moved = t.getShares();
                TransactionOwner<? extends Transaction> source = t.getCrossEntry().getCrossOwner(t);
                for (LineItem entry : new ArrayList<LineItem>(this.fifo)) {
                    if (moved <= 0L) break;
                    if (!entry.owner.equals(source) || entry.shares == 0L) continue;
                    long n = Math.min(moved, entry.shares);
                    if (n == entry.shares) {
                        entry.owner = item.getOwner();
                    } else {
                        long transferredGrossAmount = Math.round((double)n / (double)entry.shares * (double)entry.grossAmount);
                        long transferredNetAmount = Math.round((double)n / (double)entry.shares * (double)entry.netAmount);
                        LineItem transfer = new LineItem(item.getOwner(), n, transferredGrossAmount, transferredNetAmount, entry.trail.fraction(Money.of(this.getTermCurrency(), transferredGrossAmount), n, entry.originalShares).transfer(item.getDateTime().toLocalDate(), entry.owner, item.getOwner()));
                        LineItem lineItem = entry;
                        lineItem.grossAmount = lineItem.grossAmount - transferredGrossAmount;
                        LineItem lineItem4 = entry;
                        lineItem4.netAmount = lineItem4.netAmount - transferredNetAmount;
                        LineItem lineItem5 = entry;
                        lineItem5.shares = lineItem5.shares - n;
                        this.fifo.add(this.fifo.indexOf(entry) + 1, transfer);
                    }
                    moved -= n;
                }
                if (moved <= 0L) break;
                PortfolioLog.warning(MessageFormat.format(Messages.MsgNegativeHoldingsDuringFIFOCostCalculation, Values.Share.format(moved), t.getSecurity().getName(), Values.DateTime.format(t.getDateTime())));
                break;
            }
            case TRANSFER_OUT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem item, AccountTransaction t) {
        switch (t.getType()) {
            case TAXES: {
                this.taxes += converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount();
                break;
            }
            case TAX_REFUND: {
                this.taxes -= converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount();
                break;
            }
            case FEES: {
                this.fees += converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount();
                break;
            }
            case FEES_REFUND: {
                this.fees -= converter.convert(t.getDateTime(), t.getMonetaryAmount()).getAmount();
            }
        }
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.DividendPayment t) {
        this.taxes += t.getTransaction().orElseThrow(IllegalArgumentException::new).getUnitSum(Transaction.Unit.Type.TAX, converter).getAmount();
        t.setFifoCost(this.getFifoCost());
        t.setMovingAverageCost(this.getMovingAverageCost());
        t.setTotalShares(this.getSharesHeld());
    }

    public Money getFifoCost() {
        long cost = 0L;
        for (LineItem entry : this.fifo) {
            cost += entry.grossAmount;
        }
        return Money.of(this.getTermCurrency(), cost);
    }

    public TrailRecord getFifoCostTrail() {
        return TrailRecord.of(this.fifo.stream().filter(entry -> ((LineItem)entry).grossAmount > 0L).map(entry -> ((LineItem)entry).trail.fraction(Money.of(this.getTermCurrency(), ((LineItem)entry).grossAmount), ((LineItem)entry).shares, ((LineItem)entry).originalShares)).collect(Collectors.toList()));
    }

    public Money getNetFifoCost() {
        long cost = 0L;
        for (LineItem entry : this.fifo) {
            cost += entry.netAmount;
        }
        return Money.of(this.getTermCurrency(), cost);
    }

    public Money getMovingAverageCost() {
        return Money.of(this.getTermCurrency(), this.movingRelativeCost);
    }

    public Money getNetMovingAverageCost() {
        return Money.of(this.getTermCurrency(), this.movingRelativeNetCost);
    }

    private long getSharesHeld() {
        long shares = 0L;
        for (LineItem entry : this.fifo) {
            shares += entry.shares;
        }
        return shares;
    }

    public Money getFees() {
        return Money.of(this.getTermCurrency(), this.fees);
    }

    public Money getTaxes() {
        return Money.of(this.getTermCurrency(), this.taxes);
    }

    private static class LineItem {
        private TransactionOwner<?> owner;
        private long shares;
        private long grossAmount;
        private long netAmount;
        private final TrailRecord trail;
        private final long originalShares;

        public LineItem(TransactionOwner<?> owner, long shares, long grossAmount, long netAmount, TrailRecord trail) {
            this.owner = owner;
            this.shares = shares;
            this.grossAmount = grossAmount;
            this.netAmount = netAmount;
            this.trail = trail;
            this.originalShares = shares;
        }
    }
}

