/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceIndicator;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

public final class CapitalGainsRecord
implements SecurityPerformanceIndicator.CapitalGains {
    private final Security security;
    private Money capitalGains;
    private TrailRecord capitalGainsTrail;
    private Money forexCaptialGains;
    private TrailRecord forexCapitalGainsTrail;

    CapitalGainsRecord(Security security, String termCurrency) {
        Money zero;
        this.security = security;
        this.capitalGains = zero = Money.of(termCurrency, 0L);
        this.capitalGainsTrail = TrailRecord.empty();
        this.forexCaptialGains = zero;
        this.forexCapitalGainsTrail = TrailRecord.empty();
    }

    public Security getSecurity() {
        return this.security;
    }

    @Override
    public Money getCapitalGains() {
        return this.capitalGains;
    }

    @Override
    public TrailRecord getCapitalGainsTrail() {
        return this.capitalGainsTrail;
    }

    @Override
    public Money getForexCaptialGains() {
        return this.forexCaptialGains;
    }

    @Override
    public TrailRecord getForexCapitalGainsTrail() {
        return this.forexCapitalGainsTrail;
    }

    public void addCapitalGains(Money other) {
        this.capitalGains = this.capitalGains.add(other);
    }

    void addCapitalGainsTrail(TrailRecord other) {
        this.capitalGainsTrail = this.capitalGainsTrail.add(other);
    }

    void addForexCaptialGains(Money other) {
        this.forexCaptialGains = this.forexCaptialGains.add(other);
    }

    void addForexCapitalGainsTrail(TrailRecord other) {
        this.forexCapitalGainsTrail = this.forexCapitalGainsTrail.add(other);
    }
}

