/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot.security;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.PortfolioLog;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.security.Calculation;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;
import name.abuchen.portfolio.snapshot.security.CapitalGainsRecord;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;

class CapitalGainsCalculation
extends Calculation {
    private List<LineItem> fifo = new ArrayList<LineItem>();
    private CapitalGainsRecord realizedCapitalGains;
    private CapitalGainsRecord unrealizedCapitalGains;

    CapitalGainsCalculation() {
    }

    @Override
    public void prepare() {
        this.realizedCapitalGains = new CapitalGainsRecord(this.getSecurity(), this.getTermCurrency());
        this.unrealizedCapitalGains = new CapitalGainsRecord(this.getSecurity(), this.getTermCurrency());
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.ValuationAtStart valuation) {
        SecurityPosition position = valuation.getSecurityPosition().orElseThrow(IllegalArgumentException::new);
        Money value = valuation.getValue();
        Money converted = value.with(converter.at(valuation.getDateTime()));
        TrailRecord trail = TrailRecord.ofPosition(valuation.getDateTime().toLocalDate(), (Portfolio)valuation.getOwner(), position);
        if (!value.getCurrencyCode().equals(converter.getTermCurrency())) {
            trail = trail.convert(converted, converter.getRate(valuation.getDateTime(), value.getCurrencyCode()));
        }
        this.fifo.add(new LineItem(position.getShares(), valuation.getDateTime().toLocalDate(), converted.getAmount(), trail, valuation));
    }

    @Override
    public void visit(CurrencyConverter converter, CalculationLineItem.TransactionItem transactionItem, PortfolioTransaction t) {
        String termCurrency = this.getTermCurrency();
        Money grossValue = t.getGrossValue();
        Money convertedGrossValue = grossValue.with(converter.at(t.getDateTime()));
        TrailRecord txTrail = TrailRecord.ofTransaction(t).asGrossValue(grossValue);
        if (!grossValue.getCurrencyCode().equals(converter.getTermCurrency())) {
            txTrail = txTrail.convert(convertedGrossValue, converter.getRate(transactionItem.getDateTime().toLocalDate(), grossValue.getCurrencyCode()));
        }
        switch (t.getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                this.fifo.add(new LineItem(t.getShares(), t.getDateTime().toLocalDate(), convertedGrossValue.getAmount(), txTrail, transactionItem));
                break;
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                long value = convertedGrossValue.getAmount();
                long sold = t.getShares();
                for (LineItem item : this.fifo) {
                    if (item.shares == 0L || !item.source.getOwner().equals(transactionItem.getOwner())) continue;
                    if (sold <= 0L) break;
                    long soldShares = Math.min(sold, item.shares);
                    long start = Math.round((double)soldShares / (double)item.shares * (double)item.value);
                    long end = Math.round((double)soldShares / (double)t.getShares() * (double)value);
                    TrailRecord startTrail = item.trail.fraction(Money.of(termCurrency, start), soldShares, item.originalShares);
                    long forexGain = 0L;
                    TrailRecord forexGainTrail = TrailRecord.empty();
                    if (!termCurrency.equals(t.getSecurity().getCurrencyCode())) {
                        CurrencyConverter convert2forex = converter.with(t.getSecurity().getCurrencyCode());
                        Money forex = convert2forex.convert(item.date, Money.of(termCurrency, start));
                        Money back = forex.with(converter.at(t.getDateTime()));
                        forexGain = back.getAmount() - start;
                        forexGainTrail = startTrail.convert(forex, convert2forex.getRate(item.date, termCurrency)).convert(back, converter.getRate(t.getDateTime(), t.getSecurity().getCurrencyCode())).subtract(startTrail);
                    }
                    this.realizedCapitalGains.addCapitalGains(Money.of(termCurrency, end - start));
                    this.realizedCapitalGains.addCapitalGainsTrail(txTrail.fraction(Money.of(termCurrency, end), soldShares, t.getShares()).subtract(startTrail));
                    this.realizedCapitalGains.addForexCaptialGains(Money.of(termCurrency, forexGain));
                    this.realizedCapitalGains.addForexCapitalGainsTrail(forexGainTrail);
                    LineItem lineItem = item;
                    lineItem.shares = lineItem.shares - soldShares;
                    LineItem lineItem2 = item;
                    lineItem2.value = lineItem2.value - start;
                    sold -= soldShares;
                }
                if (sold <= 0L) break;
                PortfolioLog.warning(MessageFormat.format(Messages.MsgNegativeHoldingsDuringFIFOCostCalculation, Values.Share.format(sold), t.getSecurity().getName(), Values.DateTime.format(t.getDateTime())));
                break;
            }
            case TRANSFER_IN: {
                long moved = t.getShares();
                TransactionOwner<? extends Transaction> source = t.getCrossEntry().getCrossOwner(t);
                for (LineItem entry : new ArrayList<LineItem>(this.fifo)) {
                    if (moved <= 0L) break;
                    if (!entry.source.getOwner().equals(source) || entry.shares == 0L) continue;
                    long n = Math.min(moved, entry.shares);
                    long transferredValue = Math.round((double)n / (double)entry.shares * (double)entry.value);
                    LineItem transfer = new LineItem(n, t.getDateTime().toLocalDate(), transferredValue, entry.trail.fraction(Money.of(this.getTermCurrency(), transferredValue), n, entry.originalShares).transfer(t.getDateTime().toLocalDate(), entry.source.getOwner(), transactionItem.getOwner()), transactionItem);
                    if (n == entry.shares) {
                        this.fifo.add(this.fifo.indexOf(entry) + 1, transfer);
                        this.fifo.remove(entry);
                    } else {
                        LineItem lineItem = entry;
                        lineItem.value = lineItem.value - transferredValue;
                        LineItem lineItem3 = entry;
                        lineItem3.shares = lineItem3.shares - n;
                        this.fifo.add(this.fifo.indexOf(entry) + 1, transfer);
                    }
                    moved -= n;
                }
                if (moved <= 0L) break;
                PortfolioLog.warning(MessageFormat.format(Messages.MsgNegativeHoldingsDuringFIFOCostCalculation, Values.Share.format(moved), t.getSecurity().getName(), Values.DateTime.format(t.getDateTime())));
                break;
            }
            case TRANSFER_OUT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void finish(CurrencyConverter converter, List<CalculationLineItem> lineItems) {
        String termCurrency = this.getTermCurrency();
        List valuationsAtEnd = lineItems.stream().filter(item -> item instanceof CalculationLineItem.ValuationAtEnd).map(item -> (CalculationLineItem.ValuationAtEnd)item).collect(Collectors.toList());
        if (valuationsAtEnd.isEmpty()) {
            long value = this.fifo.stream().mapToLong(item -> ((LineItem)item).value).sum();
            if (value != 0L) {
                PortfolioLog.warning(MessageFormat.format(Messages.MsgNegativeHoldingsDuringFIFOCostCalculation, Values.Money.format(Money.of(termCurrency, value)), this.getSecurity().getName(), this.fifo.stream().map(item -> Values.Date.format(((LineItem)item).date)).collect(Collectors.joining(","))));
            }
            return;
        }
        this.squashForexValuationsAtStart(converter);
        long start = this.fifo.stream().mapToLong(item -> ((LineItem)item).value).sum();
        TrailRecord startTrail = TrailRecord.of(this.fifo.stream().filter(item -> ((LineItem)item).shares != 0L).map(item -> ((LineItem)item).trail.fraction(Money.of(termCurrency, ((LineItem)item).value), ((LineItem)item).shares, ((LineItem)item).originalShares)).collect(Collectors.toList()));
        LocalDateTime valuationAtEndDate = ((CalculationLineItem.ValuationAtEnd)valuationsAtEnd.get(0)).getDateTime();
        Money endValue = valuationsAtEnd.stream().map(item -> item.getSecurityPosition().orElseThrow(IllegalArgumentException::new).calculateValue()).collect(MoneyCollectors.sum(this.getSecurity().getCurrencyCode()));
        TrailRecord endTrail = TrailRecord.of(valuationsAtEnd.stream().map(item -> TrailRecord.ofPosition(valuationAtEndDate.toLocalDate(), (Portfolio)item.getOwner(), item.getSecurityPosition().orElseThrow(IllegalArgumentException::new))).collect(Collectors.toList()));
        Money convertedEndValue = endValue.with(converter.at(valuationAtEndDate));
        if (!endValue.getCurrencyCode().equals(converter.getTermCurrency())) {
            endTrail = endTrail.convert(convertedEndValue, converter.getRate(valuationAtEndDate, endValue.getCurrencyCode()));
        }
        long end = convertedEndValue.getAmount();
        long forexGain = 0L;
        TrailRecord forexGainTrail = TrailRecord.empty();
        if (!termCurrency.equals(this.getSecurity().getCurrencyCode())) {
            CurrencyConverter convert2Forex = converter.with(this.getSecurity().getCurrencyCode());
            Money forex = this.fifo.stream().filter(item -> ((LineItem)item).value != 0L).map(item -> convert2Forex.convert(((LineItem)item).date, Money.of(termCurrency, ((LineItem)item).value))).collect(MoneyCollectors.sum(this.getSecurity().getCurrencyCode()));
            Money back = forex.with(converter.at(valuationAtEndDate));
            forexGain = back.getAmount() - start;
            forexGainTrail = TrailRecord.of(this.fifo.stream().filter(item -> ((LineItem)item).value != 0L).map(item -> ((LineItem)item).trail.fraction(Money.of(termCurrency, ((LineItem)item).value), ((LineItem)item).shares, ((LineItem)item).originalShares).convert(convert2Forex.convert(((LineItem)item).date, Money.of(termCurrency, ((LineItem)item).value)), convert2Forex.getRate(((LineItem)item).date, termCurrency))).collect(Collectors.toList()));
            forexGainTrail = forexGainTrail.convert(back, converter.getRate(valuationAtEndDate, this.getSecurity().getCurrencyCode())).subtract(startTrail);
        }
        this.unrealizedCapitalGains.addCapitalGains(Money.of(termCurrency, end - start));
        this.unrealizedCapitalGains.addCapitalGainsTrail(endTrail.subtract(startTrail));
        this.unrealizedCapitalGains.addForexCaptialGains(Money.of(termCurrency, forexGain));
        this.unrealizedCapitalGains.addForexCapitalGainsTrail(forexGainTrail);
    }

    private void squashForexValuationsAtStart(CurrencyConverter converter) {
        if (this.getSecurity().getCurrencyCode().equals(this.getTermCurrency())) {
            return;
        }
        List itemsToSquash = this.fifo.stream().filter(item -> ((LineItem)item).source instanceof CalculationLineItem.ValuationAtStart).filter(item -> ((LineItem)item).shares == ((LineItem)item).originalShares).collect(Collectors.toList());
        if (itemsToSquash.size() < 2) {
            return;
        }
        LocalDateTime valuationAtStartDate = ((LineItem)itemsToSquash.get(0)).source.getDateTime();
        long shares = itemsToSquash.stream().mapToLong(item -> ((LineItem)item).shares).sum();
        Money value = itemsToSquash.stream().map(item -> ((LineItem)item).source.getSecurityPosition().orElseThrow(IllegalArgumentException::new).calculateValue()).collect(MoneyCollectors.sum(this.getSecurity().getCurrencyCode()));
        Money converted = value.with(converter.at(valuationAtStartDate));
        TrailRecord trail = TrailRecord.of(itemsToSquash.stream().map(item -> TrailRecord.ofPosition(valuationAtStartDate.toLocalDate(), (Portfolio)((LineItem)item).source.getOwner(), ((LineItem)item).source.getSecurityPosition().orElseThrow(IllegalArgumentException::new))).collect(Collectors.toList()));
        trail = trail.convert(converted, converter.getRate(valuationAtStartDate, value.getCurrencyCode()));
        LineItem replacement = new LineItem(shares, valuationAtStartDate.toLocalDate(), converted.getAmount(), trail, null);
        this.fifo.removeAll(itemsToSquash);
        this.fifo.add(0, replacement);
    }

    public CapitalGainsRecord getRealizedCapitalGains() {
        return this.realizedCapitalGains;
    }

    public CapitalGainsRecord getUnrealizedCapitalGains() {
        return this.unrealizedCapitalGains;
    }

    private static class LineItem {
        private long shares;
        private LocalDate date;
        private long value;
        private final TrailRecord trail;
        private final long originalShares;
        private final CalculationLineItem source;

        public LineItem(long shares, LocalDate date, long value, TrailRecord trail, CalculationLineItem source) {
            this.shares = shares;
            this.date = Objects.requireNonNull(date);
            this.value = value;
            this.trail = trail;
            this.originalShares = shares;
            this.source = source;
        }
    }
}

