/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import com.google.common.base.Objects;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.function.Predicate;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;

public abstract class ReportingPeriod {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    private ReportingPeriod() {
    }

    public static final ReportingPeriod from(String code) throws IOException {
        char type = code.charAt(0);
        if (type == 'L') {
            return new LastX(code);
        }
        if (type == 'D') {
            return new LastXDays(code);
        }
        if (type == 'T') {
            return new LastXTradingDays(code);
        }
        if (type == 'F') {
            return new FromXtoY(code);
        }
        if (type == 'S') {
            return new SinceX(code);
        }
        if (type == 'Y') {
            return new YearX(code);
        }
        if (type == 'M') {
            return new CurrentMonth();
        }
        if (type == 'X') {
            return new YearToDate();
        }
        if (code.charAt(code.length() - 1) == 'Y') {
            return new LastX(Integer.parseInt(code.substring(0, code.length() - 1)), 0);
        }
        throw new IOException(code);
    }

    public final Predicate<Transaction> containsTransaction(LocalDate relativeTo) {
        Interval interval = this.toInterval(relativeTo);
        return t -> t.getDateTime().toLocalDate().isAfter(interval.getStart()) && !t.getDateTime().toLocalDate().isAfter(interval.getEnd());
    }

    public abstract Interval toInterval(LocalDate var1);

    public abstract void writeTo(StringBuilder var1);

    public String getCode() {
        StringBuilder buf = new StringBuilder();
        this.writeTo(buf);
        return buf.toString();
    }

    /* synthetic */ ReportingPeriod(ReportingPeriod reportingPeriod) {
        this();
    }

    public static class CurrentMonth
    extends ReportingPeriod {
        private static final char CODE = 'M';

        public CurrentMonth() {
            super(null);
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            LocalDate startDate = LocalDate.now().withDayOfMonth(1).minusDays(1L);
            if (startDate.isBefore(relativeTo)) {
                return Interval.of(startDate, relativeTo);
            }
            return Interval.of(startDate, startDate);
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('M');
        }

        public String toString() {
            return Messages.LabelReportingPeriodCurrentMonth;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Character.valueOf('M')});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }

    public static class FromXtoY
    extends ReportingPeriod {
        private static final char CODE = 'F';
        private final LocalDate startDate;
        private final LocalDate endDate;

        FromXtoY(String code) {
            this(LocalDate.parse(code.substring(1, code.indexOf(95))), LocalDate.parse(code.substring(code.indexOf(95) + 1)));
        }

        public FromXtoY(LocalDate startDate, LocalDate endDate) {
            super(null);
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public FromXtoY(Interval interval) {
            this(interval.getStart(), interval.getEnd());
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            return Interval.of(this.startDate, this.endDate);
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('F').append(this.startDate.toString()).append('_').append(this.endDate.toString());
        }

        public String toString() {
            return MessageFormat.format(Messages.LabelReportingPeriodFromXtoY, this.startDate.format(DATE_FORMATTER), this.endDate.format(DATE_FORMATTER));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.startDate, this.endDate});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FromXtoY other = (FromXtoY)obj;
            return this.startDate.equals(other.startDate) && this.endDate.equals(other.endDate);
        }
    }

    public static class LastX
    extends ReportingPeriod {
        private static final char CODE = 'L';
        private final int years;
        private final int months;

        LastX(String code) {
            this(Integer.parseInt(code.substring(1, code.indexOf(89))), Integer.parseInt(code.substring(code.indexOf(89) + 1)));
        }

        public LastX(int years, int months) {
            super(null);
            this.years = years;
            this.months = months;
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            return Interval.of(relativeTo.minusYears(this.years).minusMonths(this.months), relativeTo);
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('L').append(this.years).append('Y').append(this.months);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.years != 0) {
                buf.append(MessageFormat.format(Messages.LabelReportingPeriodYears, this.years));
                if (this.months != 0) {
                    buf.append(", ");
                }
            }
            if (this.months != 0) {
                buf.append(MessageFormat.format(Messages.LabelReportingPeriodMonths, this.months));
            }
            return buf.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.years, this.months});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LastX other = (LastX)obj;
            return this.years == other.years && this.months == other.months;
        }
    }

    public static class LastXDays
    extends ReportingPeriod {
        private static final char CODE = 'D';
        private final int days;

        LastXDays(String code) {
            this(Integer.parseInt(code.substring(1)));
        }

        public LastXDays(int days) {
            super(null);
            this.days = days;
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            return Interval.of(relativeTo.minusDays(this.days), relativeTo);
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('D').append(this.days);
        }

        public String toString() {
            return MessageFormat.format(Messages.LabelReportingPeriodLastXDays, this.days);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.days});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LastXDays other = (LastXDays)obj;
            return this.days == other.days;
        }
    }

    public static class LastXTradingDays
    extends ReportingPeriod {
        private static final char CODE = 'T';
        private final int tradingDays;

        LastXTradingDays(String code) {
            this(Integer.parseInt(code.substring(1)));
        }

        public LastXTradingDays(int tradingDays) {
            super(null);
            this.tradingDays = tradingDays;
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            return Interval.of(LastXTradingDays.tradingDaysUntil(relativeTo, this.tradingDays), relativeTo);
        }

        public static final LocalDate tradingDaysUntil(LocalDate referenceDate, int tradingDays) {
            TradeCalendar calendar = TradeCalendarManager.getDefaultInstance();
            LocalDate date = referenceDate;
            int daysToGo = tradingDays;
            while (daysToGo > 0) {
                if (!calendar.isHoliday(date)) {
                    --daysToGo;
                }
                date = date.minusDays(1L);
            }
            while (calendar.isHoliday(date)) {
                date = date.minusDays(1L);
            }
            return date;
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('T').append(this.tradingDays);
        }

        public String toString() {
            return MessageFormat.format(Messages.LabelReportingPeriodLastXTradingDays, this.tradingDays);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.tradingDays});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LastXTradingDays other = (LastXTradingDays)obj;
            return this.tradingDays == other.tradingDays;
        }
    }

    public static class SinceX
    extends ReportingPeriod {
        private static final char CODE = 'S';
        private final LocalDate startDate;

        SinceX(String code) {
            this(LocalDate.parse(code.substring(1)));
        }

        public SinceX(LocalDate startDate) {
            super(null);
            this.startDate = startDate;
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            if (this.startDate.isBefore(relativeTo)) {
                return Interval.of(this.startDate, relativeTo);
            }
            return Interval.of(this.startDate, this.startDate);
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('S').append(this.startDate.toString());
        }

        public String toString() {
            return MessageFormat.format(Messages.LabelReportingPeriodSince, this.startDate.format(DATE_FORMATTER));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.startDate});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SinceX other = (SinceX)obj;
            return this.startDate.equals(other.startDate);
        }
    }

    public static class YearToDate
    extends ReportingPeriod {
        private static final char CODE = 'X';

        public YearToDate() {
            super(null);
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            LocalDate startDate = LocalDate.now().withDayOfMonth(1).withMonth(1).minusDays(1L);
            if (startDate.isBefore(relativeTo)) {
                return Interval.of(startDate, relativeTo);
            }
            return Interval.of(startDate, startDate);
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('X');
        }

        public String toString() {
            return Messages.LabelReportingPeriodYTD;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Character.valueOf('X')});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }

    public static class YearX
    extends ReportingPeriod {
        private static final char CODE = 'Y';
        private final int year;

        YearX(String code) {
            this(Integer.parseInt(code.substring(1)));
        }

        public YearX(int year) {
            super(null);
            this.year = year;
        }

        @Override
        public Interval toInterval(LocalDate relativeTo) {
            return Interval.of(LocalDate.of(this.year - 1, 12, 31), LocalDate.of(this.year, 12, 31));
        }

        @Override
        public void writeTo(StringBuilder buffer) {
            buffer.append('Y').append(this.year);
        }

        public String toString() {
            return String.valueOf(this.year);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.year});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            YearX other = (YearX)obj;
            return this.year == other.year;
        }
    }
}

