/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;

public class QuoteQualityMetrics {
    private final Security security;
    private Interval checkInterval;
    private List<Interval> missingIntervals = new ArrayList<Interval>();
    private int expectedNumberOfQuotes;
    private int actualNumberOfQuotes;

    public QuoteQualityMetrics(Security security) {
        this.security = security;
        this.calculate();
    }

    public Optional<Interval> getCheckInterval() {
        return Optional.ofNullable(this.checkInterval);
    }

    public double getCompleteness() {
        return this.expectedNumberOfQuotes == 0 ? 0.0 : (double)this.actualNumberOfQuotes / (double)this.expectedNumberOfQuotes;
    }

    public List<Interval> getMissingIntervals() {
        return this.missingIntervals;
    }

    public int getExpectedNumberOfQuotes() {
        return this.expectedNumberOfQuotes;
    }

    public int getActualNumberOfQuotes() {
        return this.actualNumberOfQuotes;
    }

    public final void calculate() {
        ArrayList<SecurityPrice> copy = new ArrayList<SecurityPrice>(this.security.getPrices());
        if (copy.isEmpty()) {
            return;
        }
        LocalDate start = ((SecurityPrice)copy.get(0)).getDate();
        LocalDate end = "MANUAL".equals(this.security.getFeed()) ? ((SecurityPrice)copy.get(copy.size() - 1)).getDate() : LocalDate.now();
        this.checkInterval = Interval.of(start, end);
        TradeCalendar tradeCalendar = TradeCalendarManager.getInstance(this.security);
        ArrayList<LocalDate> missingDays = new ArrayList<LocalDate>();
        this.expectedNumberOfQuotes = 0;
        this.actualNumberOfQuotes = 0;
        int index = 0;
        LocalDate currentDay = start;
        while (!currentDay.isAfter(end)) {
            boolean hasQuote;
            boolean bl = hasQuote = index < copy.size() && currentDay.equals(((SecurityPrice)copy.get(index)).getDate());
            if (hasQuote) {
                ++this.actualNumberOfQuotes;
                ++this.expectedNumberOfQuotes;
                ++index;
            } else if (!tradeCalendar.isHoliday(currentDay)) {
                missingDays.add(currentDay);
                ++this.expectedNumberOfQuotes;
            }
            currentDay = currentDay.plusDays(1L);
        }
        this.missingIntervals = this.conflate(missingDays, tradeCalendar);
    }

    private List<Interval> conflate(List<LocalDate> dates, TradeCalendar tradeCalendar) {
        ArrayList<Interval> answer = new ArrayList<Interval>();
        Interval interval = null;
        for (LocalDate date : dates) {
            boolean haveBridgeDates = false;
            if (interval != null) {
                LocalDate bridgeDate = interval.getEnd().plusDays(1L);
                while (!bridgeDate.equals(date) && tradeCalendar.isHoliday(bridgeDate)) {
                    bridgeDate = bridgeDate.plusDays(1L);
                }
                if (bridgeDate.equals(date)) {
                    haveBridgeDates = true;
                }
            }
            if (haveBridgeDates) {
                interval = Interval.of(interval.getStart(), date);
                answer.set(answer.size() - 1, interval);
                continue;
            }
            interval = Interval.of(date, date);
            answer.add(interval);
        }
        return answer;
    }
}

