/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.snapshot.AccountSnapshot;
import name.abuchen.portfolio.snapshot.AssetCategory;
import name.abuchen.portfolio.snapshot.AssetPosition;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.PortfolioSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;

public final class GroupByTaxonomy {
    private final Taxonomy taxonomy;
    private final CurrencyConverter converter;
    private final LocalDate date;
    private final Money valuation;
    private final List<AssetCategory> categories = new ArrayList<AssetCategory>();

    private GroupByTaxonomy(Taxonomy taxonomy, CurrencyConverter converter, LocalDate date, Money valuation) {
        this.taxonomy = taxonomy;
        this.converter = converter;
        this.date = date;
        this.valuation = valuation;
    }

    GroupByTaxonomy(Taxonomy taxonomy, ClientSnapshot snapshot) {
        this(taxonomy, snapshot.getCurrencyConverter(), snapshot.getTime(), snapshot.getMonetaryAssets());
        HashMap<InvestmentVehicle, Item> vehicle2position = new HashMap<InvestmentVehicle, Item>();
        for (AccountSnapshot account : snapshot.getAccounts()) {
            if (account.getFunds().isZero()) continue;
            vehicle2position.put(account.unwrapAccount(), new Item(new SecurityPosition(account)));
        }
        if (snapshot.getJointPortfolio() != null) {
            for (SecurityPosition pos : snapshot.getJointPortfolio().getPositions()) {
                vehicle2position.put(pos.getSecurity(), new Item(pos));
            }
        }
        this.doGrouping(vehicle2position);
    }

    public GroupByTaxonomy(Taxonomy taxonomy, PortfolioSnapshot snapshot) {
        this(taxonomy, snapshot.getCurrencyConverter(), snapshot.getTime(), snapshot.getValue());
        HashMap<InvestmentVehicle, Item> vehicle2position = new HashMap<InvestmentVehicle, Item>();
        for (SecurityPosition pos : snapshot.getPositions()) {
            vehicle2position.put(pos.getSecurity(), new Item(pos));
        }
        this.doGrouping(vehicle2position);
    }

    private void doGrouping(Map<InvestmentVehicle, Item> vehicle2position) {
        if (this.taxonomy != null) {
            this.createCategoriesAndAllocate(vehicle2position);
            Collections.sort(this.categories, (r, l) -> Integer.compare(r.getClassification().getRank(), l.getClassification().getRank()));
        }
        this.allocateLeftOvers(vehicle2position);
    }

    private void createCategoriesAndAllocate(final Map<InvestmentVehicle, Item> vehicle2position) {
        for (Classification classification : this.taxonomy.getRoot().getChildren()) {
            final HashMap vehicle2item = new HashMap();
            classification.accept(new Taxonomy.Visitor(){

                @Override
                public void visit(Classification classification, Classification.Assignment assignment) {
                    Item item = (Item)vehicle2position.get(assignment.getInvestmentVehicle());
                    if (item != null) {
                        Item item2 = item;
                        item2.weight = item2.weight + assignment.getWeight();
                        Item item3 = vehicle2item.computeIfAbsent(assignment.getInvestmentVehicle(), v -> new Item(item.position));
                        item3.weight = item3.weight + assignment.getWeight();
                    }
                }
            });
            if (vehicle2item.isEmpty()) continue;
            AssetCategory category = new AssetCategory(classification, this.converter, this.date, this.valuation);
            this.categories.add(category);
            for (Map.Entry entry : vehicle2item.entrySet()) {
                Item item = (Item)entry.getValue();
                SecurityPosition position = item.position;
                if (item.weight != Classification.ONE_HUNDRED_PERCENT) {
                    position = SecurityPosition.split(position, item.weight);
                }
                category.addPosition(new AssetPosition(position, this.converter, this.date, this.getValuation()));
            }
            Collections.sort(category.getPositions(), new AssetPosition.ByDescription());
        }
    }

    private void allocateLeftOvers(Map<InvestmentVehicle, Item> vehicle2position) {
        Classification classification = new Classification(null, "$unassigned$", Messages.LabelWithoutClassification);
        AssetCategory unassigned = new AssetCategory(classification, this.converter, this.date, this.getValuation());
        for (Map.Entry<InvestmentVehicle, Item> entry : vehicle2position.entrySet()) {
            Item item = entry.getValue();
            if (item.weight >= Classification.ONE_HUNDRED_PERCENT) continue;
            SecurityPosition position = item.position;
            if (item.weight != 0) {
                position = SecurityPosition.split(position, Classification.ONE_HUNDRED_PERCENT - item.weight);
            }
            unassigned.addPosition(new AssetPosition(position, this.converter, this.date, this.getValuation()));
        }
        if (!unassigned.getPositions().isEmpty()) {
            this.categories.add(unassigned);
        }
    }

    public LocalDate getDate() {
        return this.date;
    }

    public Money getValuation() {
        return this.valuation;
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public List<AssetCategory> asList() {
        return this.categories;
    }

    public Stream<AssetCategory> getCategories() {
        return this.categories.stream();
    }

    AssetCategory byClassification(Classification classification) {
        for (AssetCategory category : this.categories) {
            if (!category.getClassification().equals(classification)) continue;
            return category;
        }
        return null;
    }

    private static final class Item {
        private SecurityPosition position;
        private int weight;

        private Item(SecurityPosition position) {
            this.position = position;
        }
    }
}

