/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.snapshot;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyAccount;

public class AccountSnapshot {
    private final Account account;
    private final LocalDate date;
    private final CurrencyConverter converter;
    private final Money funds;

    public static AccountSnapshot create(Account account, CurrencyConverter converter, LocalDate date) {
        long funds = 0L;
        LocalDateTime reference = date.atTime(LocalTime.MAX);
        for (AccountTransaction t : account.getTransactions()) {
            if (t.getDateTime().isAfter(reference)) continue;
            if (t.getType().isDebit()) {
                funds -= t.getAmount();
                continue;
            }
            funds += t.getAmount();
        }
        return new AccountSnapshot(account, date, converter, Money.of(account.getCurrencyCode(), funds));
    }

    private AccountSnapshot(Account account, LocalDate date, CurrencyConverter converter, Money funds) {
        this.account = account;
        this.date = date;
        this.converter = converter;
        this.funds = funds;
    }

    Account unwrapAccount() {
        return this.account instanceof ReadOnlyAccount ? ((ReadOnlyAccount)this.account).unwrap() : this.account;
    }

    public Account getAccount() {
        return this.account;
    }

    public LocalDate getTime() {
        return this.date;
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public Money getFunds() {
        return this.funds.with(this.converter.at(this.date));
    }

    public Money getUnconvertedFunds() {
        return this.funds;
    }
}

