/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.online.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.QuoteFeedData;
import name.abuchen.portfolio.util.Dates;
import name.abuchen.portfolio.util.WebAccess;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class FinnhubQuoteFeed
implements QuoteFeed {
    public static final String ID = "FINNHUB-CANDLE";
    private String apiKey;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return "Finnhub";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public Optional<LatestSecurityPrice> getLatestQuote(Security security) {
        QuoteFeedData data = this.getHistoricalQuotes(security, false, 5);
        List<LatestSecurityPrice> prices = data.getLatestPrices();
        if (prices.isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(prices, new SecurityPrice.ByDate());
        return Optional.of(prices.get(prices.size() - 1));
    }

    @Override
    public QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse) {
        int count = 20000;
        if (!security.getPrices().isEmpty()) {
            LocalDate startDate = security.getPrices().get(security.getPrices().size() - 1).getDate();
            count = Dates.daysBetween(startDate, LocalDate.now()) + 5;
        }
        return this.getHistoricalQuotes(security, collectRawResponse, count);
    }

    @Override
    public QuoteFeedData previewHistoricalQuotes(Security security) {
        return this.getHistoricalQuotes(security, true, 100);
    }

    private QuoteFeedData getHistoricalQuotes(Security security, boolean collectRawResponse, int count) {
        if (security.getTickerSymbol() == null) {
            return QuoteFeedData.withError(new IOException(MessageFormat.format(Messages.MsgMissingTickerSymbol, security.getName())));
        }
        QuoteFeedData data = new QuoteFeedData();
        try {
            JSONObject json;
            String status;
            WebAccess webaccess = new WebAccess("finnhub.io", "/api/v1/stock/candle").addParameter("symbol", security.getTickerSymbol()).addParameter("resolution", "D").addParameter("count", String.valueOf(count));
            if (this.apiKey != null) {
                webaccess.addParameter("token", this.apiKey);
            }
            String response = webaccess.get();
            if (collectRawResponse) {
                data.addResponse(webaccess.getURL(), response);
            }
            if ("no_data".equals(status = (String)(json = (JSONObject)JSONValue.parse((String)response)).get((Object)"s"))) {
                return data;
            }
            JSONArray timestamps = (JSONArray)json.get((Object)"t");
            JSONArray high = (JSONArray)json.get((Object)"h");
            JSONArray low = (JSONArray)json.get((Object)"l");
            JSONArray close = (JSONArray)json.get((Object)"c");
            JSONArray volume = (JSONArray)json.get((Object)"v");
            if (timestamps == null) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "t")));
                return data;
            }
            if (close == null) {
                data.addError(new IOException(MessageFormat.format(Messages.MsgErrorMissingKeyValueInJSON, "c")));
                return data;
            }
            int size = timestamps.size();
            int index = 0;
            while (index < size) {
                LatestSecurityPrice price = new LatestSecurityPrice();
                price.setDate(LocalDateTime.ofEpochSecond((Long)timestamps.get(index), 0, ZoneOffset.UTC).toLocalDate());
                Number c = (Number)close.get(index);
                price.setValue(c == null ? -1L : Values.Quote.factorize(c.doubleValue()));
                Number h = (Number)high.get(index);
                price.setHigh(h == null ? -1L : Values.Quote.factorize(h.doubleValue()));
                Number l = (Number)low.get(index);
                price.setLow(l == null ? -1L : Values.Quote.factorize(l.doubleValue()));
                Number v = (Number)volume.get(index);
                price.setVolume(v == null ? -1L : v.longValue());
                if (price.getValue() > 0L) {
                    data.addPrice(price);
                }
                ++index;
            }
        }
        catch (IOException | URISyntaxException e) {
            data.addError(e);
        }
        return data;
    }
}

