/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money.impl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;

public class ExchangeRateTimeSeriesImpl
implements ExchangeRateTimeSeries {
    private transient ExchangeRateProvider provider;
    private String baseCurrency;
    private String termCurrency;
    private List<ExchangeRate> rates = new ArrayList<ExchangeRate>();

    public ExchangeRateTimeSeriesImpl() {
    }

    public ExchangeRateTimeSeriesImpl(ExchangeRateTimeSeriesImpl template) {
        this.provider = template.provider;
        this.baseCurrency = template.baseCurrency;
        this.termCurrency = template.termCurrency;
        this.rates.addAll(template.rates);
    }

    public ExchangeRateTimeSeriesImpl(ExchangeRateProvider provider, String baseCurrency, String termCurrency) {
        this.provider = provider;
        this.baseCurrency = baseCurrency;
        this.termCurrency = termCurrency;
    }

    @Override
    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    @Override
    public String getTermCurrency() {
        return this.termCurrency;
    }

    @Override
    public Optional<ExchangeRateProvider> getProvider() {
        return Optional.of(this.provider);
    }

    @Override
    public List<ExchangeRate> getRates() {
        return new ArrayList<ExchangeRate>(this.rates);
    }

    public void setProvider(ExchangeRateProvider provider) {
        this.provider = provider;
    }

    public void setBaseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    public void setTermCurrency(String termCurrency) {
        this.termCurrency = termCurrency;
    }

    public void addRate(ExchangeRate rate) {
        int index = Collections.binarySearch(this.rates, rate);
        if (index < 0) {
            this.rates.add(~index, rate);
        } else {
            this.rates.set(index, rate);
        }
    }

    public Optional<ExchangeRate> getLatest() {
        return this.rates.isEmpty() ? Optional.empty() : Optional.of(this.rates.get(this.rates.size() - 1));
    }

    @Override
    public Optional<ExchangeRate> lookupRate(LocalDate requestedTime) {
        if (this.rates.isEmpty()) {
            return Optional.empty();
        }
        ExchangeRate r = new ExchangeRate(requestedTime, BigDecimal.ZERO);
        int index = Collections.binarySearch(this.rates, r);
        if (index >= 0) {
            return Optional.of(this.rates.get(index));
        }
        if (index == -1) {
            return Optional.of(this.rates.get(0));
        }
        return Optional.of(this.rates.get(-index - 2));
    }

    @Override
    public int getWeight() {
        return 2;
    }
}

