/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import name.abuchen.portfolio.money.impl.ECBExchangeRateProvider;
import name.abuchen.portfolio.money.impl.ExchangeRateTimeSeriesImpl;

class ECBData {
    private transient boolean isDirty = false;
    private long lastModified;
    private List<ExchangeRateTimeSeriesImpl> timeSeries = new ArrayList<ExchangeRateTimeSeriesImpl>();
    private transient Map<String, ExchangeRateTimeSeriesImpl> currency2series = new HashMap<String, ExchangeRateTimeSeriesImpl>();

    ECBData() {
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void addSeries(ExchangeRateTimeSeriesImpl series) {
        if (!"EUR".equals(series.getBaseCurrency())) {
            throw new UnsupportedOperationException();
        }
        this.timeSeries.add(series);
        this.currency2series.put(series.getTermCurrency(), series);
    }

    public List<ExchangeRateTimeSeriesImpl> getSeries() {
        return this.timeSeries;
    }

    public Map<String, ExchangeRateTimeSeriesImpl> getCurrencyMap() {
        return this.currency2series;
    }

    public ECBData copy() {
        ECBData copy = new ECBData();
        copy.lastModified = this.lastModified;
        for (ExchangeRateTimeSeriesImpl series : this.timeSeries) {
            copy.addSeries(new ExchangeRateTimeSeriesImpl(series));
        }
        return copy;
    }

    public void doPostLoadProcessing(ECBExchangeRateProvider provider) {
        this.currency2series = new HashMap<String, ExchangeRateTimeSeriesImpl>();
        for (ExchangeRateTimeSeriesImpl series : this.timeSeries) {
            series.setProvider(provider);
            this.currency2series.put(series.getTermCurrency(), series);
        }
    }
}

