/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.util.FormatHelper;

public abstract class Values<E> {
    public static final MathContext MC = new MathContext(10, RoundingMode.HALF_UP);
    public static final Values<Long> Amount = new Values<Long>("#,##0.00", 2){

        @Override
        public String format(Long amount) {
            return String.format("%,.2f", (double)amount.longValue() / this.divider());
        }
    };
    public static final MoneyValues Money = new MoneyValues();
    public static final Values<Long> AmountFraction = new Values<Long>("#,##0.00###", 5){
        private final DecimalFormat format = new DecimalFormat(this.pattern());

        @Override
        public String format(Long share) {
            return this.format.format((double)share.longValue() / this.divider());
        }
    };
    public static final Values<Long> AmountPlain = new Values<Long>("#,##0.##", 2){
        private final DecimalFormat format = new DecimalFormat(this.pattern());

        @Override
        public String format(Long amount) {
            return this.format.format((double)amount.longValue() / this.divider());
        }
    };
    public static final Values<Long> AmountShort = new Values<Long>("#,##0", 2){
        private final DecimalFormat format = new DecimalFormat(this.pattern());

        @Override
        public String format(Long amount) {
            return this.format.format((double)amount.longValue() / this.divider());
        }
    };
    public static final Values<Long> Share = new Values<Long>("#,##0.########", 8){
        private final DecimalFormat format = new DecimalFormat(this.pattern());

        @Override
        public String format(Long share) {
            return this.format.format((double)share.longValue() / this.divider());
        }
    };
    public static final QuoteValues Quote = new QuoteValues();
    public static final CalculatedQuoteValues CalculatedQuote = new CalculatedQuoteValues();
    public static final Values<BigDecimal> ExchangeRate = new Values<BigDecimal>("#,##0.0000", 0){

        @Override
        public String format(BigDecimal exchangeRate) {
            return String.format("%,.4f", exchangeRate);
        }
    };
    public static final Values<Integer> Index = new Values<Integer>("#,##0.00", 2){

        @Override
        public String format(Integer index) {
            return String.format("%,.2f", (double)index.intValue() / this.divider());
        }
    };
    public static final Values<LocalDate> Date = new Values<LocalDate>("yyyy-MM-dd", 0){
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(new Locale("pt").getLanguage().equals(Locale.getDefault().getLanguage()) ? FormatStyle.SHORT : FormatStyle.MEDIUM);

        @Override
        public String format(LocalDate date) {
            return this.formatter.format(date);
        }
    };
    public static final Values<LocalDateTime> DateTime = new Values<LocalDateTime>("yyyy-MM-dd HH:mm", 0){
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(new Locale("pt").getLanguage().equals(Locale.getDefault().getLanguage()) ? FormatStyle.SHORT : FormatStyle.MEDIUM, FormatStyle.SHORT);

        @Override
        public String format(LocalDateTime date) {
            if (date.toLocalTime().equals(LocalTime.MIDNIGHT)) {
                return Date.format(date.toLocalDate());
            }
            return this.formatter.format(date);
        }
    };
    public static final Values<Double> Thousands = new Values<Double>("0.###k", 0){
        private ThreadLocal<DecimalFormat> numberFormatter = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.###"));

        @Override
        public String format(Double value) {
            return String.valueOf(this.numberFormatter.get().format(value / 1000.0)) + "k";
        }
    };
    public static final Values<Double> Percent = new Values<Double>("0.00%", 0){

        @Override
        public String format(Double percent) {
            return String.format("%,.2f", percent * 100.0);
        }
    };
    public static final Values<Double> PercentShort = new Values<Double>("0.00%", 0){

        @Override
        public String format(Double percent) {
            return String.format("%,.1f", percent * 100.0);
        }
    };
    public static final Values<Double> PercentPlain = new Values<Double>("0.00", 0){

        @Override
        public String format(Double percent) {
            return String.format("%,.2f", percent);
        }
    };
    public static final Values<Integer> Weight = new Values<Integer>("#,##0.00", 2){

        @Override
        public String format(Integer weight) {
            return String.format("%,.2f", (double)weight.intValue() / this.divider());
        }
    };
    public static final Values<Integer> WeightPercent = new Values<Integer>("#,##0.00", 2){

        @Override
        public String format(Integer weight) {
            return String.format("%,.2f%%", (double)weight.intValue() / this.divider());
        }
    };
    public static final Values<Double> Percent2 = new Values<Double>("0.00%", 0){

        @Override
        public String format(Double percent) {
            return String.format("%,.2f%%", percent * 100.0);
        }
    };
    public static final Values<Double> Percent5 = new Values<Double>("0.00000%", 0){

        @Override
        public String format(Double percent) {
            return String.format("%,.5f%%", percent * 100.0);
        }
    };
    public static final Values<Integer> Id = new Values<Integer>("#,##0", 0){

        @Override
        public String format(Integer amount) {
            return String.format("%,.0f", (double)amount.intValue() / this.divider());
        }
    };
    public static final Values<Integer> Year = new Values<Integer>("0", 0){

        @Override
        public String format(Integer amount) {
            return String.valueOf(amount);
        }
    };
    private final String pattern;
    private final int factor;
    private final double divider;
    private final int precision;
    private final BigDecimal bdFactor;

    private Values(String pattern, int precision) {
        this.pattern = pattern;
        this.factor = BigInteger.TEN.pow(precision).intValue();
        this.divider = this.factor;
        this.precision = precision;
        this.bdFactor = BigDecimal.valueOf(this.factor);
    }

    public final String pattern() {
        return this.pattern;
    }

    public final double divider() {
        return this.divider;
    }

    public final int factor() {
        return this.factor;
    }

    public final int precision() {
        return this.precision;
    }

    public BigDecimal getBigDecimalFactor() {
        return this.bdFactor;
    }

    public long factorize(double value) {
        return Math.round(value * (double)this.factor);
    }

    public abstract String format(E var1);

    public String formatNonZero(E amount) {
        if (amount instanceof Double) {
            Double d = (Double)amount;
            if (d.isNaN()) {
                return null;
            }
            if (d == 0.0) {
                return null;
            }
            return this.format(amount);
        }
        if (amount instanceof Number) {
            boolean isNotZero = ((Number)amount).longValue() != 0L;
            return isNotZero ? this.format(amount) : null;
        }
        throw new UnsupportedOperationException();
    }

    public String formatNonZero(E amount, double threshold) {
        if (amount instanceof Double) {
            boolean isNotZero = Math.abs((Double)amount) >= threshold;
            return isNotZero ? this.format(amount) : null;
        }
        throw new UnsupportedOperationException();
    }

    /* synthetic */ Values(String string, int n, Values values) {
        this(string, n);
    }

    public static final class CalculatedQuoteValues
    extends Values<Long> {
        private static final String QUOTE_PATTERN = "#,##0.00######";
        private static final ThreadLocal<DecimalFormat> QUOTE_FORMAT = ThreadLocal.withInitial(() -> {
            int precision = FormatHelper.getCalculatedQuoteDisplayPrecision();
            DecimalFormat format = new DecimalFormat("#,##0.##");
            format.setMinimumFractionDigits(precision);
            format.setMaximumFractionDigits(precision);
            return format;
        });

        private CalculatedQuoteValues() {
            super(QUOTE_PATTERN, 8, null);
        }

        @Override
        public String format(Long quote) {
            DecimalFormat format = QUOTE_FORMAT.get();
            if (format.getMinimumFractionDigits() != FormatHelper.getCalculatedQuoteDisplayPrecision()) {
                QUOTE_FORMAT.remove();
                format = QUOTE_FORMAT.get();
            }
            return format.format((double)quote.longValue() / this.divider());
        }

        public String format(String currencyCode, long quote, String skipCurrency) {
            if (currencyCode == null || skipCurrency.equals(currencyCode)) {
                return this.format(quote);
            }
            return this.format(currencyCode, quote);
        }

        public String format(String currencyCode, long quote) {
            return String.valueOf(currencyCode) + " " + this.format(quote);
        }

        @Override
        public String format(Quote quote) {
            return this.format(quote.getCurrencyCode(), quote.getAmount());
        }

        public String format(Quote quote, String skipCurrency) {
            return this.format(quote.getCurrencyCode(), quote.getAmount(), skipCurrency);
        }

        public String formatNonZero(Quote amount, String skipCurrencyCode) {
            return amount == null || amount.isZero() ? null : this.format(amount, skipCurrencyCode);
        }
    }

    public static final class MoneyValues
    extends Values<Money> {
        private MoneyValues() {
            super("#,##0.00", 2, null);
        }

        @Override
        public String format(Money amount) {
            return String.format("%s %,.2f", amount.getCurrencyCode(), (double)amount.getAmount() / this.divider());
        }

        public String format(Money amount, String skipCurrencyCode) {
            if (skipCurrencyCode.equals(amount.getCurrencyCode())) {
                return String.format("%,.2f", (double)amount.getAmount() / this.divider());
            }
            return this.format(amount);
        }

        @Override
        public String formatNonZero(Money amount) {
            return amount == null || amount.isZero() ? null : this.format(amount);
        }

        @Override
        public String formatNonZero(Money amount, double threshold) {
            boolean isNotZero = amount != null && (double)Math.abs(amount.getAmount()) >= threshold;
            return isNotZero ? this.format(amount) : null;
        }

        public String formatNonZero(Money amount, String skipCurrencyCode) {
            return amount == null || amount.isZero() ? null : this.format(amount, skipCurrencyCode);
        }
    }

    public static final class QuoteValues
    extends Values<Long> {
        private static final String QUOTE_PATTERN = "#,##0.00######";
        private static final ThreadLocal<DecimalFormat> QUOTE_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat(QUOTE_PATTERN));
        private final BigDecimal factorToMoney = BigDecimal.valueOf(this.factor() / Money.factor());
        private final int precisionDeltaToMoney = this.precision() - Money.precision();

        private QuoteValues() {
            super(QUOTE_PATTERN, 8, null);
        }

        @Override
        public String format(Long quote) {
            return QUOTE_FORMAT.get().format((double)quote.longValue() / this.divider());
        }

        public String format(String currencyCode, long quote, String skipCurrency) {
            if (currencyCode == null || skipCurrency.equals(currencyCode)) {
                return this.format(quote);
            }
            return this.format(currencyCode, quote);
        }

        public String format(String currencyCode, long quote) {
            return String.valueOf(currencyCode) + " " + this.format(quote);
        }

        @Override
        public String format(Quote quote) {
            return this.format(quote.getCurrencyCode(), quote.getAmount());
        }

        public String format(Quote quote, String skipCurrency) {
            return this.format(quote.getCurrencyCode(), quote.getAmount(), skipCurrency);
        }

        public String formatNonZero(Quote amount, String skipCurrencyCode) {
            return amount == null || amount.isZero() ? null : this.format(amount, skipCurrencyCode);
        }

        public int factorToMoney() {
            return this.factor() / Money.factor();
        }

        public double dividerToMoney() {
            return this.divider() / Money.divider();
        }

        public BigDecimal getBigDecimalFactorToMoney() {
            return this.factorToMoney;
        }

        public int precisionDeltaToMoney() {
            return this.precisionDeltaToMoney;
        }
    }
}

