/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;

public class MoneyCollectors {
    private MoneyCollectors() {
    }

    public static Collector<Money, MutableMoney, Money> sum(String currencyCode) {
        return new AbstractMoneyAdder<Money>(currencyCode){

            @Override
            public BiConsumer<MutableMoney, Money> accumulator() {
                return (builder, money) -> {
                    MutableMoney mutableMoney = builder.add((Money)money);
                };
            }
        };
    }

    public static <T> Collector<T, MutableMoney, Money> sum(String currencyCode, final Function<T, Money> converter) {
        return new AbstractMoneyAdder<T>(currencyCode){

            @Override
            public BiConsumer<MutableMoney, T> accumulator() {
                return (builder, type) -> {
                    MutableMoney mutableMoney = builder.add((Money)converter.apply(type));
                };
            }
        };
    }

    private static abstract class AbstractMoneyAdder<T>
    implements Collector<T, MutableMoney, Money> {
        private final String currencyCode;

        private AbstractMoneyAdder(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public Supplier<MutableMoney> supplier() {
            return () -> MutableMoney.of(this.currencyCode);
        }

        @Override
        public BinaryOperator<MutableMoney> combiner() {
            return (left, right) -> left.add((MutableMoney)right);
        }

        @Override
        public Function<MutableMoney, Money> finisher() {
            return MutableMoney::toMoney;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }
}

