/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;

public interface ExchangeRateTimeSeries {
    public String getBaseCurrency();

    public String getTermCurrency();

    public Optional<ExchangeRateProvider> getProvider();

    public List<ExchangeRate> getRates();

    public Optional<ExchangeRate> lookupRate(LocalDate var1);

    default public Optional<ExchangeRate> lookupRate(LocalDateTime requestedTime) {
        return this.lookupRate(requestedTime.toLocalDate());
    }

    public int getWeight();

    default public String getLabel() {
        return String.valueOf(this.getBaseCurrency()) + '/' + this.getTermCurrency();
    }

    default public List<ExchangeRateTimeSeries> getComposition() {
        return Collections.emptyList();
    }
}

