/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.money;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import name.abuchen.portfolio.Messages;
import name.abuchen.portfolio.util.Pair;

public final class CurrencyUnit
implements Comparable<CurrencyUnit> {
    public static final CurrencyUnit EMPTY = new CurrencyUnit(Messages.LabelNoCurrency, Messages.LabelNoCurrencyDescription, null);
    public static final String EUR = "EUR";
    public static final String USD = "USD";
    private static final String BUNDLE_NAME = "name.abuchen.portfolio.money.currencies";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("name.abuchen.portfolio.money.currencies");
    private static final Map<String, CurrencyUnit> CACHE = new HashMap<String, CurrencyUnit>();
    private String currencyCode;
    private String displayName;
    private String currencySymbol;

    static {
        Enumeration<String> codes = BUNDLE.getKeys();
        while (codes.hasMoreElements()) {
            String currencyCode = codes.nextElement();
            if (currencyCode.indexOf(46) >= 0) continue;
            String displayName = BUNDLE.getString(currencyCode);
            String currencySymbol = null;
            try {
                currencySymbol = BUNDLE.getString(String.valueOf(currencyCode) + ".symbol");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            CACHE.put(currencyCode, new CurrencyUnit(currencyCode, displayName, currencySymbol));
        }
    }

    private CurrencyUnit(String currencyCode, String displayName, String currencySymbol) {
        this.currencyCode = currencyCode;
        this.displayName = displayName;
        this.currencySymbol = currencySymbol;
    }

    public static List<CurrencyUnit> getAvailableCurrencyUnits() {
        return new ArrayList<CurrencyUnit>(CACHE.values());
    }

    public static CurrencyUnit getInstance(String currencyCode) {
        return CACHE.get(currencyCode);
    }

    public static List<Pair<String, List<CurrencyUnit>>> getAvailableCurrencyUnitsGrouped() {
        TreeMap sublists = new TreeMap();
        sublists.put(0, new Pair("A - D", new ArrayList()));
        sublists.put(4, new Pair("E - I", new ArrayList()));
        sublists.put(9, new Pair("J - M", new ArrayList()));
        sublists.put(13, new Pair("N - R", new ArrayList()));
        sublists.put(18, new Pair("S - V", new ArrayList()));
        sublists.put(22, new Pair("W - Z", new ArrayList()));
        for (CurrencyUnit unit : CACHE.values()) {
            int letter = unit.getCurrencyCode().charAt(0) - 65;
            ((List)((Pair)sublists.floorEntry(letter).getValue()).getRight()).add(unit);
        }
        ArrayList<Pair<String, List<CurrencyUnit>>> answer = new ArrayList<Pair<String, List<CurrencyUnit>>>(sublists.values());
        for (Pair pair : answer) {
            Collections.sort((List)pair.getRight());
        }
        return answer;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getLabel() {
        return MessageFormat.format(Messages.FixAssignCurrencyCode, this.currencyCode, this.displayName);
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public int compareTo(CurrencyUnit other) {
        return this.getCurrencyCode().compareTo(other.getCurrencyCode());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currencyCode == null ? 0 : this.currencyCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurrencyUnit other = (CurrencyUnit)obj;
        return !(this.currencyCode == null ? other.currencyCode != null : !this.currencyCode.equals(other.currencyCode));
    }
}

