/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.model;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.InvestmentVehicle;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.SecurityProperty;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.util.Pair;

public final class Security
implements Attributable,
InvestmentVehicle {
    private String uuid;
    private String onlineId;
    private String name;
    private String currencyCode = "EUR";
    private String targetCurrencyCode;
    private String note;
    private String isin;
    private String tickerSymbol;
    private String wkn;
    private String calendar;
    private String feed;
    private String feedURL;
    private List<SecurityPrice> prices = new ArrayList<SecurityPrice>();
    private String latestFeed;
    private String latestFeedURL;
    private LatestSecurityPrice latest;
    private Attributes attributes;
    private List<SecurityEvent> events;
    private List<SecurityProperty> properties;
    private boolean isRetired = false;
    @Deprecated
    private String type;
    @Deprecated
    private String industryClassification;

    public Security() {
        this.uuid = UUID.randomUUID().toString();
    }

    public Security(String name, String currencyCode) {
        this();
        this.name = name;
        this.currencyCode = currencyCode;
    }

    public Security(String name, String isin, String tickerSymbol, String feed) {
        this();
        this.name = name;
        this.isin = isin;
        this.tickerSymbol = tickerSymbol;
        this.feed = feed;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    void generateUUID() {
        this.uuid = UUID.randomUUID().toString();
    }

    public void fixMissingUUID() {
        if (this.uuid == null) {
            this.generateUUID();
        }
    }

    public String getOnlineId() {
        return this.onlineId;
    }

    public void setOnlineId(String onlineId) {
        this.onlineId = onlineId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getTargetCurrencyCode() {
        return this.targetCurrencyCode;
    }

    public void setTargetCurrencyCode(String targetCurrencyCode) {
        this.targetCurrencyCode = targetCurrencyCode;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    public String getIsin() {
        return this.isin;
    }

    public void setIsin(String isin) {
        this.isin = isin;
    }

    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public String getWkn() {
        return this.wkn;
    }

    public void setWkn(String wkn) {
        this.wkn = wkn;
    }

    public String getCalendar() {
        return this.calendar;
    }

    public void setCalendar(String calendar) {
        this.calendar = calendar;
    }

    public boolean isExchangeRate() {
        return this.targetCurrencyCode != null;
    }

    public String getExternalIdentifier() {
        if (this.isin != null && this.isin.length() > 0) {
            return this.isin;
        }
        if (this.tickerSymbol != null && this.tickerSymbol.length() > 0) {
            return this.tickerSymbol;
        }
        if (this.wkn != null && this.wkn.length() > 0) {
            return this.wkn;
        }
        return this.name;
    }

    @Deprecated
    String getIndustryClassification() {
        return this.industryClassification;
    }

    @Deprecated
    void setIndustryClassification(String industryClassification) {
        this.industryClassification = industryClassification;
    }

    @Deprecated
    String getType() {
        return this.type;
    }

    @Deprecated
    void setType(String type) {
        this.type = type;
    }

    public String getFeed() {
        return this.feed;
    }

    public void setFeed(String feed) {
        this.feed = feed;
    }

    public String getFeedURL() {
        return this.feedURL;
    }

    public void setFeedURL(String feedURL) {
        this.feedURL = feedURL;
    }

    public List<SecurityPrice> getPrices() {
        return Collections.unmodifiableList(this.prices);
    }

    public List<SecurityPrice> getPricesIncludingLatest() {
        if (this.latest == null) {
            return this.getPrices();
        }
        int index = Collections.binarySearch(this.prices, new SecurityPrice(this.latest.getDate(), this.latest.getValue()));
        if (index >= 0) {
            return this.getPrices();
        }
        ArrayList<SecurityPrice> copy = new ArrayList<SecurityPrice>(this.prices);
        copy.add(~index, this.latest);
        return copy;
    }

    public boolean addPrice(SecurityPrice price) {
        return this.addPrice(price, true);
    }

    public boolean addPrice(SecurityPrice price, boolean overwriteExisting) {
        Objects.requireNonNull(price);
        int index = Collections.binarySearch(this.prices, price);
        if (index < 0) {
            this.prices.add(~index, price);
            return true;
        }
        SecurityPrice replaced = this.prices.get(index);
        if (!replaced.equals(price) && (overwriteExisting || (double)replaced.getValue() == 0.0)) {
            this.prices.set(index, price);
            return true;
        }
        return false;
    }

    public boolean addAllPrices(List<SecurityPrice> newPrices) {
        if (newPrices.isEmpty()) {
            return false;
        }
        LocalDate now = LocalDate.now();
        LocalDate last = null;
        if (!this.prices.isEmpty()) {
            last = this.prices.get(this.prices.size() - 1).getDate();
        }
        boolean isUpdated = false;
        for (SecurityPrice p : newPrices) {
            if (p.getDate().isAfter(now)) continue;
            boolean doOverwrite = p.getDate().equals(last);
            boolean isAdded = this.addPrice(p, doOverwrite);
            boolean bl = isUpdated = isUpdated || isAdded;
        }
        return isUpdated;
    }

    public void removePrice(SecurityPrice price) {
        this.prices.remove(price);
    }

    public void removeAllPrices() {
        this.prices.clear();
    }

    public SecurityPrice getSecurityPrice(LocalDate requestedDate) {
        SecurityPrice lastHistoric;
        SecurityPrice securityPrice = lastHistoric = this.prices.isEmpty() ? null : this.prices.get(this.prices.size() - 1);
        if (this.latest != null && (lastHistoric == null || !requestedDate.isBefore(this.latest.getDate()) && !this.latest.getDate().isBefore(lastHistoric.getDate()))) {
            return this.latest;
        }
        if (lastHistoric == null) {
            return new SecurityPrice(requestedDate, 0L);
        }
        if (!lastHistoric.getDate().isAfter(requestedDate)) {
            return lastHistoric;
        }
        SecurityPrice p = new SecurityPrice(requestedDate, 0L);
        int index = Collections.binarySearch(this.prices, p);
        if (index >= 0) {
            return this.prices.get(index);
        }
        if (index == -1) {
            return this.prices.get(0);
        }
        return this.prices.get(-index - 2);
    }

    public Optional<Pair<SecurityPrice, SecurityPrice>> getLatestTwoSecurityPrices() {
        if (this.prices.isEmpty()) {
            return Optional.empty();
        }
        List<SecurityPrice> list = this.getPricesIncludingLatest();
        if (list.size() < 2) {
            return Optional.empty();
        }
        LocalDate now = LocalDate.now();
        SecurityPrice today = null;
        int index = list.size() - 1;
        while (index >= 0) {
            today = list.get(index);
            if (!today.getDate().isAfter(now)) break;
            --index;
        }
        return index > 0 ? Optional.of(new Pair<SecurityPrice, SecurityPrice>(list.get(index), list.get(index - 1))) : Optional.empty();
    }

    public String getLatestFeed() {
        return this.latestFeed;
    }

    public void setLatestFeed(String latestFeed) {
        this.latestFeed = latestFeed;
    }

    public String getLatestFeedURL() {
        return this.latestFeedURL;
    }

    public void setLatestFeedURL(String latestFeedURL) {
        this.latestFeedURL = latestFeedURL;
    }

    public LatestSecurityPrice getLatest() {
        return this.latest;
    }

    public boolean setLatest(LatestSecurityPrice latest) {
        if (!Objects.equals(latest, this.latest)) {
            this.latest = latest;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRetired() {
        return this.isRetired;
    }

    @Override
    public void setRetired(boolean isRetired) {
        this.isRetired = isRetired;
    }

    public List<SecurityEvent> getEvents() {
        if (this.events == null) {
            this.events = new ArrayList<SecurityEvent>();
        }
        return this.events;
    }

    public void addEvent(SecurityEvent event) {
        if (this.events == null) {
            this.events = new ArrayList<SecurityEvent>();
        }
        this.events.add(event);
    }

    public void removeEvent(SecurityEvent event) {
        if (this.events == null) {
            this.events = new ArrayList<SecurityEvent>();
        }
        this.events.remove(event);
    }

    public boolean removeEventIf(Predicate<SecurityEvent> filter) {
        if (this.events != null) {
            return this.events.removeIf(filter);
        }
        return false;
    }

    public Stream<SecurityProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<SecurityProperty>();
        }
        return this.properties.stream();
    }

    public Optional<String> getPropertyValue(SecurityProperty.Type type, String name) {
        return this.getProperties().filter(p -> p.getType() == type && name.equals(p.getName())).map(SecurityProperty::getValue).findAny();
    }

    public boolean setPropertyValue(SecurityProperty.Type type, String name, String value) {
        Optional<SecurityProperty> prop;
        if (this.properties == null) {
            this.properties = new ArrayList<SecurityProperty>();
        }
        if ((prop = this.properties.stream().filter(p -> p.getType() == type && name.equals(p.getName())).findAny()).isPresent()) {
            boolean isEqual = Objects.equals(prop.get().getValue(), value);
            if (!isEqual) {
                this.properties.remove(prop.get());
                if (value != null) {
                    this.properties.add(new SecurityProperty(type, name, value));
                }
            }
            return !isEqual;
        }
        if (value != null) {
            this.properties.add(new SecurityProperty(type, name, value));
            return true;
        }
        return false;
    }

    public void addProperty(SecurityProperty data) {
        if (this.properties == null) {
            this.properties = new ArrayList<SecurityProperty>();
        }
        this.properties.add(data);
    }

    public boolean removeProperty(SecurityProperty data) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.remove(data);
    }

    public boolean removePropertyIf(Predicate<SecurityProperty> filter) {
        if (this.properties != null) {
            return this.properties.removeIf(filter);
        }
        return false;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Stream<Bookmark> getCustomBookmarks() {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        this.getAttributes().getAllValues().filter(v -> v instanceof Bookmark).forEach(v -> {
            boolean bl = bookmarks.add((Bookmark)v);
        });
        if (!Strings.isNullOrEmpty((String)this.note)) {
            Pattern urlPattern = Pattern.compile("(https?\\:\\/\\/[^ \\t\\r\\n]+)", 2);
            Matcher m = urlPattern.matcher(this.note);
            while (m.find()) {
                bookmarks.add(new Bookmark(m.group()));
            }
        }
        return bookmarks.stream();
    }

    public List<TransactionPair<?>> getTransactions(Client client) {
        ArrayList answer = new ArrayList();
        for (Account account : client.getAccounts()) {
            account.getTransactions().stream().filter(t -> this.equals(t.getSecurity())).filter(t -> t.getType() == AccountTransaction.Type.INTEREST || t.getType() == AccountTransaction.Type.DIVIDENDS || t.getType() == AccountTransaction.Type.TAXES || t.getType() == AccountTransaction.Type.TAX_REFUND || t.getType() == AccountTransaction.Type.FEES || t.getType() == AccountTransaction.Type.FEES_REFUND).map(t -> new TransactionPair<AccountTransaction>(account, (AccountTransaction)t)).forEach(answer::add);
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            portfolio.getTransactions().stream().filter(t -> this.equals(t.getSecurity())).map(t -> new TransactionPair<PortfolioTransaction>(portfolio, (PortfolioTransaction)t)).forEach(answer::add);
        }
        return answer;
    }

    public boolean hasTransactions(Client client) {
        Optional<Transaction> transaction;
        for (Portfolio portfolio : client.getPortfolios()) {
            transaction = portfolio.getTransactions().stream().filter(t -> this.equals(t.getSecurity())).findAny();
            if (!transaction.isPresent()) continue;
            return true;
        }
        for (Account account : client.getAccounts()) {
            transaction = account.getTransactions().stream().filter(t -> this.equals(t.getSecurity())).findAny();
            if (!transaction.isPresent()) continue;
            return true;
        }
        return false;
    }

    public Security deepCopy() {
        Security answer = new Security();
        answer.onlineId = this.onlineId;
        answer.name = this.name;
        answer.currencyCode = this.currencyCode;
        answer.targetCurrencyCode = this.targetCurrencyCode;
        answer.note = this.note;
        answer.isin = this.isin;
        answer.tickerSymbol = this.tickerSymbol;
        answer.wkn = this.wkn;
        answer.calendar = this.calendar;
        answer.feed = this.feed;
        answer.feedURL = this.feedURL;
        answer.prices = new ArrayList<SecurityPrice>(this.prices);
        answer.latestFeed = this.latestFeed;
        answer.latestFeedURL = this.latestFeedURL;
        answer.latest = this.latest;
        answer.events = new ArrayList<SecurityEvent>(this.getEvents());
        if (this.properties != null) {
            answer.properties = new ArrayList<SecurityProperty>(this.properties);
        }
        answer.isRetired = this.isRetired;
        return answer;
    }

    public String toString() {
        return this.getName();
    }

    public String toInfoString() {
        StringBuilder b = new StringBuilder();
        b.append(this.name);
        if (this.notEmpty(this.isin)) {
            b.append('\n').append(this.isin);
        }
        if (this.notEmpty(this.wkn)) {
            b.append('\n').append(this.wkn);
        }
        if (this.notEmpty(this.tickerSymbol)) {
            b.append('\n').append(this.tickerSymbol);
        }
        if (this.notEmpty(this.note)) {
            b.append("\n\n").append(this.note);
        }
        return b.toString();
    }

    private boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static final class ByName
    implements Comparator<Security>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Security s1, Security s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            return s1.name.compareToIgnoreCase(s2.name);
        }
    }
}

